/*-
 * Copyright (c) 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Paul Borman at Krystal Technologies.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)sjis.c	8.1 (Berkeley) 6/4/93";
#endif /* LIBC_SCCS and not lint */

#include <sys/types.h>

#include <errno.h>
#include <rune.h>
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>

rune_t	_SJIS_sgetrune __P((const char *, size_t, char const **, void *));
int	_SJIS_sputrune __P((rune_t, char *, size_t, char **, void *));

#define issjiskanji1(c) \
	((0x81 <= (c) && (c) <= 0x9f) || (0xe0 <= (c) && (c) <= 0xfc))
#define issjiskanji2(c) \
	((0x40 <= (c) && (c) <= 0x7e) || (0x80 <= (c) && (c) <= 0xfc))

int
_SJIS_init(rl)
	_RuneLocale *rl;
{
	rl->sgetrune = _SJIS_sgetrune;
	rl->sputrune = _SJIS_sputrune;
	_CurrentRuneLocale = rl;
	__mb_cur_max = 2;
	return (0);
}

/*
 * set 0: JIS X0201 left
 * set 1: JIS X0208
 * set 2: JIS X0201 right
 */
static inline int
_sjis_set(c)
	u_int c;
{
	c &= 0xff;

	return ((c & 0x80) ? (issjiskanji1(c) ? 1 : 2) : 0);
}

static inline int
_sjis_len(set)
	int set;
{
	return ((set == 1) ? 2 : 1);
}

static rune_t
euctosjis(euc)
	rune_t euc;
{
	u_char high;
	u_char low;
	
	high = (euc & 0x7f00) >> 8;
	low = euc & 0x007f;
	if (high & 1)
		low += 0x1f;
	else
		low += 0x7d;
	if (low >= 0x7f)
		low++;
	high = (high - 0x21 >> 1) + 0x81;
	if (high > 0x9f)
		high += 0x40;
	return ((u_int)high << 8) | low;
}

static rune_t
sjistoeuc(sjis)
	rune_t sjis;
{
	u_char high;
	u_char low;
	
	high = (sjis & 0xff00) >> 8;
	low = sjis & 0x00ff;
	if (high <= 0x9f)
		high -= 0x71;
	else
		high -= 0xb1;
	high = high * 2 + 1;
	if (low > 0x7f)
		low--;
	if (low >= 0x9e) {
		low -= 0x7d;
		high++;
	} else
		low -= 0x1f;
	return (((u_int)high << 8) | low) | 0x8080;
}

rune_t
_SJIS_sgetrune(string, n, result, state)
	const char *string;
	size_t n;
	char const **result;
	void *state;
{
	rune_t rune = 0;
	int len, set;

	if (n < 1 || (len = _sjis_len(set = _sjis_set(*string))) > n) {
		if (result)
			*result = string;
		return (_INVALID_RUNE);
	}
	switch (set) {
	case 1:
		rune = (u_int)(*string++) & 0xff;
		rune = (rune << 8) | (u_int)(*string++) & 0xff;
		rune = sjistoeuc(rune);
		break;
	case 0:
	case 2:
		rune = (u_int)(*string++) & 0xff;
		break;
	}
	if (result)
		*result = string;
	return rune;
}

int
_SJIS_sputrune(c, string, n, result, state)
	rune_t c;
	char *string, **result;
	size_t n;
	void *state;
{
	int i, len, set;

	switch (c & 0x8080) {
	case 0x0080:
		set = 2;
		break;
	case 0x8080:
		set = 1;
		break;
	case 0x0000:
		set = 0;
		break;
	case 0x8000:
		return 0;
	}
	len = _sjis_len(set);

	if (n < len) {
		if (result)
			*result = NULL;
	} else {
		if (result)
			*result = string + len;

		switch (set) {
		case 1:
			c = euctosjis(c);
			/* fall through */
		case 0:
		case 2:
			i = len;
			while (i-- > 0)
				*string++ = (c >> (i * 8)) & 0xff;
			break;
		}
	}

	return len;
}
