/*
 * Copyright (C) 1983-1989  Masatoshi Kurihara <kurihara@sra.co.jp>
 * Copyright (C) 1999, 2000 and 2001
 * Jun-ichiro itojun Hagino <itojun@iijlab.net>
 * All rights reserved.
 *
 * Note well: this is not a normal 3-clause BSD copyright;
 * commercial use of the software is restricted.
 *
 * Redistribution and non-commercial use in source and binary
 * forms, with or without modification, are permitted provided that the
 * following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the authors nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * Print Monthly Personal Schedule on Printer
 *
 *	% lpsch [-month] [user | -f schedule]
 *		month     -- month to be printed, default is this month
 *		schedule  -- schedule file, default is ~/.schrc
 *		user      -- user name, file is ~user/.schrc
 *
 *	Author	Masatoshi Kurihara
 *	Date	Fri Nov 21 20:38:56 JST 1986
 *	Office	Software Tools and Technology Group
 *		Software Research Associates, Inc.
 *		1-1-1 Hirakawa-cho Chiyoda-ku Tokyo, Japan
 *		03 (234) 2611 ext 153
 *		03 (234) 2615 (night only)
 *	Home	Waseda House 2A 
 *		1-9-22 Nishiwaseda Shinjuku-ku Tokyo, Japan
 *		03 (208) 3875
 *
 *	Copyright (C) 1986 - 1989 by Software Research Associates, Inc.
 */

static	char	sccsid[] = "@(#)lpsch.c\t1.1 (SRA) 3/11/87";

#include <stdio.h>
#include <ctype.h>
#include <pwd.h>
#include <time.h>

#define	MAXBUF	160
#define	MAXBAR	26
#define	COLMON	0
#define COLBEG	7
#define	COLEND	13
#define	COLMSG	35

#define	DATA	"/.schrc"
#define	LBP	"lbp"
#define	PRINT	"(/usr/sra/tbl; /usr/local/cal %d %d 3) | /usr/sra/ditroff | /usr/ucb/lpr -t -P%s"

/*
 * Print Monthly Personal Schedule for ROFF
 *
 *	% lpsch [-month] [user | -f schedule]
 *		month     -- month to be printed, default is this month
 *		schedule  -- schedule file, default is ~/.schrc
 *		user      -- user name, file is ~user/.schrc
 */

int
main(argc, argv)
	int argc;
	char *argv[];
{
	register FILE	*df, *lp;
	register int	month, mon;
	register int	lines, cnt;
	register int	start, stop;
	auto	 long	ltime;
	auto	 char	*pch;
	auto	 char	name[MAXBUF], buf[MAXBUF], bar[MAXBAR];
	auto	 struct	tm	*tm;
	auto	 struct passwd	*pwd;
	extern	 FILE	*popen();
	extern	 char	*strcpy(), *strcat(), *index(), *getenv();
	extern	 struct	tm	*localtime();
	extern	 struct	passwd	*getpwnam();

	/*
	 * Month Set
	 */
	time(&ltime);
	tm = localtime(&ltime);

	if (argc > 1 && *argv[1] == '-' && isdigit (*(argv[1] + 1))) {
		month = atoi(argv[1] + 1);
		argc--; argv++;
	}
	else {
		month = tm->tm_mon + 1;
	}

	/*
	 * File Set
	 */
	if (argc > 2 && ! strcmp (argv[1], "-f")) {
		strcpy(name, argv[2]);
	}
	else if (argc > 1) {
		if (pwd = getpwnam(argv[1])) {
			strcpy(name, pwd->pw_dir);
			strcat(name, DATA);
		}
		else {
			fprintf(stderr, "lpsch: unknown user %s.\n", argv[1]);
			exit(1);
		}
	}
	else {
		strcpy(name, getenv("HOME"));
		strcat(name, DATA);
	}
	endpwent();
	if ((df = fopen(name, "r")) == NULL) {
		fprintf(stderr, "lpsch: can't open%s.\n", name);
		exit(1);
	}

	/*
	 * Pipe Open
	 */
	pch = getenv("PRINTER");
	sprintf(name, PRINT, month, 1900 + tm->tm_year,
		(pch && ! strncmp(pch, LBP, 3)) ? pch : LBP);
	if ((lp = popen(name, "w")) == NULL) {
		fprintf(stderr, "lpsch: can't execute %s.\n", name);
		exit(1);
	}

	/*
	 * Data Print
	 */
	header(lp, month);

	lines = 0;
	while (fgets (buf, MAXBUF, df)) {
		if (pch = index (buf, '\n'))
			*pch = NULL;
		mon = atoi(buf + COLMON);
		if (mon > month)
			break;
		if (mon < month)
			continue;

		if (++lines > 50) {
			fputs(".TE\n", lp);
			fputs(".bp\n", lp);
			header(lp, month);
			lines = 1;
		}
		else if (lines > 5 && (lines % 5) == 1) {
			fputs("_\n", lp);
		}
		start = (atoi(buf + COLBEG    ) - 9) * 2 +
			(atoi(buf + COLBEG + 3)    ) / 30;
		stop  = (atoi(buf + COLEND    ) - 9) * 2 +
			(atoi(buf + COLEND + 3)    ) / 30;
		for (cnt = 0; cnt < MAXBAR; cnt++)
			bar[cnt] = ' ';
		bar[MAXBAR - 1] = NULL;
		if (start >= 0) {
			if (start == stop) {
				bar[start] = '*';
			}
			else {
				bar[start] = '<';
				bar[stop ] = '>';
				for (cnt = start + 1; cnt < stop; cnt++)
					bar[cnt] = '-';
			}
		}
		fprintf(lp, "%5.5s\t%s\t%s\n", buf+COLMON ,bar, buf+COLMSG);
	}

	/*
	 * Trailer Print
	 */
	fputs(".TE\n", lp);
	fputs(".sp\n", lp);
	fputs(".in 0.8c\n", lp);
	fputs(".nf\n", lp);

	/*
	 * Close & Exit
	 */
	pclose(lp);
	fclose(df);
	exit(0);
}

header(lp, month)
	FILE *lp;
	int month;
{
	static	 char	*tuki[] = { "", "", "", "", "", "", "",
				    "", "", "", "", "", "" };

	fputs(".bd K B 3\n", lp);
	fputs(".ft B\n", lp);
	fputs(".ps 24\n", lp);
	fprintf(lp, "%s塼ɽ \n", tuki[month]);
	fputs(".ps 10\n", lp);
	fputs(".sp 2\n", lp);
	fputs(".ft LP\n", lp);
	fputs(".TS\n", lp);
	fputs("box;\n", lp);
	fputs("r|l|lw(8c).\n", lp);
	fputs(" \t91011 N 1 2 3 4 5 6 7 8 9\t塼\n", lp);
	fputs("_\n", lp);
}
