require "eet"
require "test/unit"
require "common"

class BasicTestData
	def initialize
		@name = "moo"
		@short = 512
		@int = 1024
		@long_long = (2 << 63) - 1
		@flag = true
		@float = 1234.12424213138
	end

	private
	def to_eet_name
		"BasicTest"
	end

	def to_eet_properties
		{"name" => [@name],
		 "i16" => [@short, :short],
		 "i32" => [@int],
		 "i64" => [@long_long, :long_long],
		 "flag" => [@flag],
		 "f32" => [@float],
		 "f64" => [@float, :double]}
	end
end

class BasicTest < Test::Unit::TestCase
	def test_basic
		data = BasicTestData.new.to_eet
		assert_not_nil(data)

		stream = nil

		assert_nothing_raised do
			stream = Eet::Stream.deserialize(data)
		end

		assert_equal(1, stream.length)
		assert_equal("BasicTest", stream.first.tag)

		assert_nothing_raised do
			stream = Eet::Stream.deserialize(stream.first.data)
		end

		assert_equal(7, stream.length)

		values = {"name" => "moo\0",
		          "i16" => "\0\2", "i32" => "\0\4\0\0",
		          "i64" => "\377" * 8, "flag" => "\1",
		          "f32" => "0x1.3487f4p+10\0",
		          "f64" => "0x1.3487f39544c4p+10\0"}
		values.each do |k, v|
			found = stream.find { |c| c.tag == k }
			assert_not_nil(found, "chunk not found - #{k}")
			assert_equal(v, found.data)
			stream.delete(found)
		end

		assert_equal([], stream)
	end
end
