use strict;
use warnings;

use RT::Test tests => undef;

my @headers = qw/X-RT-Incoming-Encryption
    X-RT-Incoming-Signature
    X-RT-Privacy
    X-RT-Sign
    X-RT-Encrypt
    X-RT-GnuPG-Status
    X-RT-SMIME-Status
    RT-Send-Cc
    RT-Send-Bcc
    RT-Attach
    RT-Message-ID
    RT-DetectedAutoGenerated
    RT-Squelch-Replies-To
    /;

my $entity = MIME::Entity->build(
    From    => 'root@localhost',
    To      => 'nobody@test.example',
    Subject => 'Testing header sanitizing',
    Data    => ['Test'],
    map { /^X-/ ? $_ : "$_:" => 'Spoofed, haha!' } @headers,
);


RT::Interface::Email::Gateway( { message => $entity->as_string } );

my $last_ticket = RT::Test->last_ticket;
ok( $last_ticket, 'Created ticket' );

my $create_attachment = $last_ticket->Transactions->First->Attachments->First;
for my $header (@headers) {
    isnt( $create_attachment->GetHeader($header), 'Spoofed, haha!', "Header '$header' was correctly sanitized" );
}


RT::Interface::Email::Gateway( { message => $entity->as_string, ticket => $last_ticket->Id } );
my $txns = $last_ticket->Transactions;
$txns->Limit( FIELD => 'Type', VALUE => 'Correspond' );
my $correspond_txn = $txns->First;
ok( $correspond_txn, 'Found Correspond transaction' );

my $correspond_attachment = $correspond_txn->Attachments->First;
for my $header (@headers) {
    isnt( $correspond_attachment->GetHeader($header), 'Spoofed, haha!', "Header '$header' was correctly sanitized" );
}

done_testing;
