/* 
 * Oroborus Window Manager
 *
 * Copyright (C) 2001 Ken Lynch
 * Copyright (C) 2002 Stefan Pfetzing
 *
 * OroboROX Window Manager
 * 
 * Copyright (C) 2004 Guido Schimmels
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 */

#include "config.h"
#include <glib.h>
#include <X11/Xlib.h>
#include <X11/Xmd.h>
#include <X11/cursorfont.h>
#include <ft2build.h>
#include <X11/Xft/Xft.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include "keyboard.h"
#include "pixmap.h"
#include "hints.h"
#include "client.h"
#include "frame.h"
#include "settings.h"
#include "main.h"
#include "xerror.h"


Bool get_mouse_xy(Display * dpy, Window w, int *x2, int *y2)
{
	Window w1, w2;
	int x1, y1, m;

	return XQueryPointer(dpy, w, &w1, &w2, &x1, &y1, x2, y2, &m);
}

Window get_mouse_window(Display * dpy, Window w)
{
	Window w1, w2;
	int x1, y1, x2, y2, m;

	XQueryPointer(dpy, w, &w1, &w2, &x1, &y1, &x2, &y2, &m);
	return w2;
}

void warp_mouse_pointer(Client * c)
{
	if (!c || !warp_mouse)		// || (focus_policy & (FOCUS_UNIX)))
		return;

	int dest_y = (frameHeight(c) / 2);

	if (c->state & STATE_SHADED)
		dest_y *= -1;

	XWarpPointer(dpy, None, c->window, 0, 0, 0, 0, frameWidth(c) / 2, dest_y);
}


#ifdef HAVE_STARTUP_NOTIFICATION
  //SnMonitorContext *sn_context;
GSList *startup_sequences;
guint startup_sequence_timeout;
#endif

static Cursor create_font_cursor(unsigned int shape)
{
    XCreateFontCursor(dpy, shape);
}

void init_cursors(Display * dpy)
{
	/* cursors defined in X11/cursorfont.h */
	root_cursor = create_font_cursor(XC_left_ptr);
	move_cursor = create_font_cursor(XC_fleur);
	busy_cursor = create_font_cursor(XC_watch);	/* options: XC_clock, XC_shuttle, XC_watch */
	kill_cursor = create_font_cursor(XC_pirate);

	//if (button_cursors)
	{
		button_cursor[HIDE_BUTTON] = create_font_cursor(XC_dotbox);
		button_cursor[SHADE_BUTTON] = None; //create_font_cursor(XC_???);
		button_cursor[MAXIMIZE_BUTTON] = create_font_cursor(XC_double_arrow);
		button_cursor[CLOSE_BUTTON] = create_font_cursor(XC_crosshair);
		button_cursor[STICK_BUTTON] = create_font_cursor(XC_dot);
	}
		
	resize_cursor[CORNER_TOP_LEFT] = create_font_cursor(XC_top_left_corner);
	resize_cursor[CORNER_TOP_RIGHT] = create_font_cursor(XC_top_right_corner);
	resize_cursor[CORNER_BOTTOM_LEFT] = create_font_cursor(XC_bottom_left_corner);
	resize_cursor[CORNER_BOTTOM_RIGHT] = create_font_cursor(XC_bottom_right_corner);
	resize_cursor[CORNER_RIGHT] = create_font_cursor(XC_right_side);
	resize_cursor[CORNER_LEFT] = create_font_cursor(XC_left_side);
	resize_cursor[CORNER_BOTTOM] = create_font_cursor(XC_bottom_side);

	XDefineCursor(dpy, root, root_cursor);
}

void free_cursors(void)
{
	XFreeCursor(dpy, root_cursor);
	XFreeCursor(dpy, move_cursor);
	XFreeCursor(dpy, busy_cursor);
	XFreeCursor(dpy, kill_cursor);

	
	int i;

	//if (button_cursors)
	{
		for (i = 0; i < BUTTON_COUNT; i++)
			XFreeCursor(dpy, button_cursor[i]);
	}

	for (i = 0; i < 7; i++)
		XFreeCursor(dpy, resize_cursor[i]);
}

