#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <ctype.h>
#include "xmldocbook_generator.h"
#include "globals.h"
#include "util.h"


char               *
RB_XMLDB_Get_Default_Extension( void )
{
    return ".xml";
}

void
RB_XMLDB_Generate_String( FILE * dest_doc, char *a_string )
{
    int                 i;
    int                 l = strlen( a_string );
    unsigned char       c;

    for ( i = 0; i < l; ++i )
    {
        c = a_string[i];
        RB_XMLDB_Generate_Char( dest_doc, c );
    }
}

/* TODO Documentation */

void
RB_XMLDB_Generate_Label( FILE* dest_doc, char *name )
{
    int                 i;
    int                 l = strlen( name );
    unsigned char       c;

    fprintf( dest_doc, "<anchor id=\"" );
    for ( i = 0; i < l; ++i )
    {
        c = name[i];
        if ( isalnum( c) ) 
        {
            RB_XMLDB_Generate_Char( dest_doc, c );
        }
        else
        {
            char buf[4];
            sprintf(buf, "%02x", c );
            RB_XMLDB_Generate_Char( dest_doc, buf[0] );
            RB_XMLDB_Generate_Char( dest_doc, buf[1] );
        }
    }
    fprintf( dest_doc, "\"/>\n" );
}


/****f* Generator/RB_XMLDB_Generate_Char
 * NAME
 *   RB_XMLDB_Generate_Char
 * SYNOPSIS
 *   void RB_XMLDB_Generate_Char( FILE * dest_doc, int c )
 * FUNCTION
 *   Switchboard to RB_XMLDB_Generate_Char
 * SOURCE
 */

void
RB_XMLDB_Generate_Char( FILE * dest_doc, int c )
{
    switch ( c )
    {
    case '\n':
        assert( 0 );
        break;
    case '\t':
        assert( 0 );
        break;
    case '<':
        fprintf( dest_doc, "&lt;" );
        break;
    case '>':
        fprintf( dest_doc, "&gt;" );
        break;
    case '&':
        fprintf( dest_doc, "&amp;" );
        break;
    default:
        RB_FputcLatin1ToUtf8( dest_doc, c );
        break;
    }
}

/*****/

void
RB_XMLDB_Generate_Header_Start( FILE * dest_doc,
                                struct RB_header *cur_header )
{
    fprintf( dest_doc, "<section>\n" );
/*    fprintf( dest_doc, "<section id=\"%s\">\n", cur_header->unique_name ); */
    fprintf( dest_doc, "<title>\n" );
    RB_XMLDB_Generate_String( dest_doc, cur_header->name );
    fprintf( dest_doc, "</title>\n" );
}

void
RB_XMLDB_Generate_Header_End( FILE * dest_doc, struct RB_header *cur_header )
{
    fprintf( dest_doc, "</section>\n" );
}

void
RB_XMLDB_Generate_Link( FILE * dest, char *dest_name, char *filename,
                        char *labelname, char *linkname, int in_fold )
{
    fprintf( dest, "<link linkend=\"%s\">", labelname );
    RB_XMLDB_Generate_String( dest, linkname );
    fprintf( dest, "</link>" );
}

void
RB_XMLDB_Generate_Doc_Start( FILE * dest_doc, char *src_name, char *name,
                             char toc )
{

    if ( course_of_action & DO_HEADLESS ) 
    {
        /* The user does not want the document head. */
    }
    else
    {
        fprintf( dest_doc, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        fprintf( dest_doc, "%s",
                "<!DOCTYPE article PUBLIC \"-//OASIS//DTD DocBook XML V4.2//EN\" \n"
                "\"http://www.oasis-open.org/docbook/xml/4.2/docbookx.dtd\">\n"
                "<article lang=\"en\">\n" );
        fprintf( dest_doc, "%s",
                "<articleinfo> <title>API Documentation</title> </articleinfo>\n" );
    }
}


void
RB_XMLDB_Generate_Doc_End( FILE * dest_doc, char *name )
{
    if ( course_of_action & DO_FOOTLESS ) 
    {
        /* The user does not want the foot of the
         * document.
         */
    }
    else
    {
        fprintf( dest_doc, "%s", "</article>\n" );
    }
}


void
RB_XMLDB_Generate_Item_Name( FILE * dest_doc, char *name )
{

    fprintf( dest_doc, "<formalpara><title>" );
    RB_XMLDB_Generate_String( dest_doc, name );
    fprintf( dest_doc, "</title><para></para></formalpara>\n" );
}

void
RB_XMLDB_Generate_Item_Begin( FILE* dest_doc )
{

}


void
RB_XMLDB_Generate_Item_End( FILE * dest_doc )
{

}


void
RB_XMLDB_Generate_BeginSection( FILE * dest_doc, int depth, char *name )
{
    fprintf( dest_doc, "%s", "<section>\n<title>" );
    RB_XMLDB_Generate_String( dest_doc, name );
    fprintf( dest_doc, "%s", "</title>\n" );
}

void
RB_XMLDB_Generate_EndSection( FILE * dest_doc, int depth, char *name )
{
    fprintf( dest_doc, "%s", "</section>\n" );
}


void
RB_XMLDB_Generate_False_Link( FILE * dest_doc, char *name )
{
    RB_XMLDB_Generate_String( dest_doc, name );
}



void XMLDB_Generate_Begin_Paragraph( FILE* dest_doc )
{
    fprintf( dest_doc, "%s", "<para>\n" );
}

void XMLDB_Generate_End_Paragraph( FILE* dest_doc )
{
    fprintf( dest_doc, "%s", "</para>\n" );
}


void XMLDB_Generate_Begin_Preformatted( FILE* dest_doc )
{
    fprintf( dest_doc, "%s", "<literallayout class=\"monospaced\">\n" );
}

void XMLDB_Generate_End_Preformatted( FILE* dest_doc )
{
    fprintf( dest_doc, "%s", "</literallayout>\n" );
}


void XMLDB_Generate_Begin_List( FILE* dest_doc )
{
    fprintf( dest_doc, "%s", "<itemizedlist>" );
}

void XMLDB_Generate_End_List( FILE* dest_doc )
{
    fprintf( dest_doc, "%s", "</itemizedlist>" );
}

void XMLDB_Generate_Begin_List_Item( FILE* dest_doc )
{
    fprintf( dest_doc, "%s", "<listitem><para>" );
}

void XMLDB_Generate_End_List_Item( FILE* dest_doc )
{
    fprintf( dest_doc, "%s", "</para></listitem>" );
}


