#ifndef ROBODOC_ITEMS_H
#define ROBODOC_ITEMS_H


/****t* Items/ItemTypes 
 * NAME 
 *   ItemTypes -- enumeration of item types
 * FUNCTION
 *   Defines a number of item types. There are two kind of items:
 *   * the SOURCE item which is always available,
 *   * and items defined by the user (or through the default items).
 * SOURCE
 */

enum ItemType { POSSIBLE_ITEM = -2, NO_ITEM = -1, SOURCE_ITEM = 0, OTHER_ITEM };

/*****/


#define RBILA_BEGIN_PARAGRAPH  (1 << 1)
#define RBILA_END_PARAGRAPH    (1 << 2)
#define RBILA_BEGIN_LIST       (1 << 3)
#define RBILA_END_LIST         (1 << 4)
#define RBILA_BEGIN_LIST_ITEM  (1 << 5)
#define RBILA_END_LIST_ITEM    (1 << 6)
#define RBILA_BEGIN_PRE        (1 << 7)
#define RBILA_END_PRE          (1 << 8)

enum  ItemLineKind { 
    ITEM_LINE_RAW,     /* A line that does not start with a remark marker */
    ITEM_LINE_PLAIN,   /* A line that starts with a remark marker */
    ITEM_LINE_PIPE,    /* A line that starts with a remark marked and is
                          followed by a pipe marker. */
    ITEM_LINE_END      /* The last line of an item */
};


struct RB_Item_Line 
{
    char* line;
    enum  ItemLineKind kind;
    long  format;
    int   pipe_mode;
};

/****s* Items/RB_Item
 * FUNCTION
 *   Keeps track of where items start end end in the header.
 *   The index numbers point to the lines array in
 *   RB_header.
 * SOURCE
 */

struct RB_Item 
{
    struct RB_Item*       next;
    enum ItemType         type;
    int                   no_lines;
    struct RB_Item_Line** lines;
    int                   begin_index;
    int                   end_index;
};

/******/



int                 RB_Get_Item_Type( char * );
int                 RB_Get_Item_Attr( char *cmp_name );
enum ItemType       RB_Is_ItemName( char *line );
int                 RB_Ignore_Last_Item( void );
char*               RB_Get_Item_Name( void );
struct RB_Item*     RB_Create_Item( enum ItemType arg_item_type );
int                 Is_Ignore_Item( char* name );

#endif /* ROBODOC_ITEMS_H */
