/****h* ROBODoc/ASCII_Generator
 * NAME
 *   ASCII_Generator -- Generator for ASCII output
 * FUNCTION
 *   Plain ascii output, no formatting.
 * MODIFICATION HISTORY
 *   2003-06-17  Frans Slothouber V1.0
 *******
 * $Id: ascii_generator.c,v 1.14 2003/12/30 17:39:36 gumpu Exp $
 */

#include <stdio.h>
#include "ascii_generator.h"
#include "util.h"
#include "robodoc.h"
#include "globals.h"
#include "items.h"
#include "headers.h"
#include "generator.h"

#ifdef DMALLOC
#include <dmalloc.h>
#endif

/*x**h* ROBODoc/ASCII_Generator
 * FUNCTION
 *   Generator for plain ASCII output
 *******
 */


/*x**f* ASCII_Generator/RB_ASCII_Generate_Doc_Start
 * NAME
 *   RB_ASCII_Generate_Doc_Start --
 ******
 */

void
RB_ASCII_Generate_Doc_Start( FILE * dest_doc, char *src_name, char *name,
                             char toc )
{
    if ( course_of_action & DO_TOC )
    {
        fprintf( dest_doc, "TABLE OF CONTENTS\n" );
        /* TODO  TOC */
#if 0
        for ( cur_header = first_header, header_nr = 1;
              cur_header; cur_header = cur_header->next_header, header_nr++ )
        {
            if ( cur_header->name && cur_header->function_name )
            {
                fprintf( dest_doc, "%4.4d %s\n",
                         header_nr, cur_header->name );
            }
        }
#endif
        fputc( '\f', dest_doc );
    }
}

/*x**f* ASCII_Generator/RB_ASCII_Generate_Doc_End
 * NAME
 *   RB_ASCII_Generate_Doc_End --
 ******
 */

void
RB_ASCII_Generate_Doc_End( FILE * dest_doc, char *name )
{
    /* Empty */
}

/*x**f* ASCII_Generator/RB_ASCII_Generate_Header_Start
 * NAME
 *   RB_ASCII_Generate_Header_Start --
 ******
 */

void
RB_ASCII_Generate_Header_Start( FILE * dest_doc,
                                struct RB_header *cur_header )
{
    fprintf( dest_doc, "%s", cur_header->name );
    fprintf( dest_doc, "\n\n" );
}

void
RB_ASCII_Generate_Header_End( FILE * dest_doc, struct RB_header *cur_header )
{
    fputc( '\f', dest_doc );
}

/*x**f* ASCII_Generator/RB_ASCII_Generate_Empty_Item
 * NAME
 *   RB_ASCII_Generate_Empty_Item --
 ******
 */

void
RB_ASCII_Generate_Empty_Item( FILE * dest )
{
    /* Empty */
}



void
RB_ASCII_Generate_False_Link( FILE * dest_doc, char *name )
{
    fprintf( dest_doc, "%s", name );
}

char               *
RB_ASCII_Get_Default_Extension( void )
{
    return ( ".txt" );
}

void
RB_ASCII_Generate_Item_Name( FILE * dest_doc, char *name )
{
    fprintf( dest_doc, "%s\n", name );
}


void
RB_ASCII_Generate_Item_Begin( FILE * dest_doc )
{
    /* Empty */
}


void
RB_ASCII_Generate_Char( FILE * dest_doc, int c )
{
    fputc( c, dest_doc );
}


void
RB_ASCII_Generate_Item_End( FILE * dest_doc )
{
    /* Empty */
}
