/* riemann-c-client -- Riemann C client library
 * SPDX-FileCopyrightText: 2013-2024 Gergely Nagy
 * SPDX-FileContributor: Gergely Nagy
 *
 * SPDX-License-Identifier: EUPL-1.2
 */

#include <riemann/riemann-client.h>
#include "riemann/_private.h"

START_TEST (test_riemann_c_client_library)
{
  ck_assert_str_eq (riemann_client_version (), PACKAGE_VERSION);
  ck_assert_str_eq (riemann_client_version_string (), PACKAGE_STRING);
}
END_TEST

START_TEST (test_riemann_c_client_tls_library)
{
  riemann_client_tls_library_t tls_lib = riemann_client_get_tls_library();

#if !WITH_TLS
  ck_assert (tls_lib == RIEMANN_CLIENT_TLS_LIBRARY_NONE);
#else
#  if WITH_TLS_GNUTLS
  ck_assert (tls_lib == RIEMANN_CLIENT_TLS_LIBRARY_GNUTLS);
#  elif WITH_TLS_WOLFSSL
  ck_assert (tls_lib == RIEMANN_CLIENT_TLS_LIBRARY_WOLFSSL);
#  elif WITH_TLS_OPENSSL
  ck_assert (tls_lib == RIEMANN_CLIENT_TLS_LIBRARY_OPENSSL);
#  endif
#endif
}
END_TEST

START_TEST (test_riemann_client_check_version)
{
  // All components ignored => 0
  ck_assert_int_eq (_riemann_client_compare_versions (255, 255, 255,
                                                      -1, -1, -1),
                    0);
  // Current version => 0
  ck_assert_int_eq (riemann_client_check_version (RCC_MAJOR_VERSION,
                                                  RCC_MINOR_VERSION,
                                                  RCC_PATCH_VERSION),
                    0);

  // Lower major version requested => 1, regardless of other components.
  ck_assert_int_eq (_riemann_client_compare_versions (255, 255, 255,
                                                      0, 255, 255), 1);
  // Higher major version requested => -1, regardless of other components
  ck_assert_int_eq (_riemann_client_compare_versions (1, 255, 255,
                                                      255, 0, 0), -1);
  // Same major, lower minor => 1
  ck_assert_int_eq (_riemann_client_compare_versions (1, 1, 1,
                                                      1, 0, 255), 1);
  // Same major, higher minor => 1
  ck_assert_int_eq (_riemann_client_compare_versions (1, 1, 1,
                                                      1, 2, 0), -1);

  // Same major, same minor, lower patch
  ck_assert_int_eq (_riemann_client_compare_versions (1, 1, 1,
                                                      1, 1, 0), 1);
  // Same major, same minor, higher petch
  ck_assert_int_eq (_riemann_client_compare_versions (1, 1, 1,
                                                      1, 1, 2), -1);
}
END_TEST

static TCase *
test_riemann_library (void)
{
  TCase *test_library;

  test_library = tcase_create ("Core");
  tcase_add_test (test_library, test_riemann_c_client_library);
  tcase_add_test (test_library, test_riemann_c_client_tls_library);
  tcase_add_test (test_library, test_riemann_client_check_version);

  return test_library;
}
