/*
 * nasd_sys.h
 *
 * Defines and structures for system interface
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_SYS_H_
#define _NASD__NASD_SYS_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_types.h>

typedef struct nasd_edrfs_svinfo_s    nasd_edrfs_svinfo_t;
typedef struct nasd_od_config_s     nasd_od_config_t;
typedef struct nasd_options_s       nasd_options_t;
typedef struct nasd_svinfo_s        nasd_svinfo_t;
typedef struct nasd_timeout_test_s  nasd_timeout_test_t;

#ifdef LINUX
#include <nasd/linux/nasd_linux_sys.h>
#endif /* LINUX */

#ifdef DEC_OSF
#include <nasd/dux/nasd_dux_sys.h>
#endif /* DEC_OSF */

#ifdef FREEBSD
#include <nasd/freebsd/nasd_freebsd_sys.h>
#endif /* FREEBSD */

#ifdef SOLARIS
#include <nasd/solaris/nasd_solaris_sys.h>
#endif /* SOLARIS */

#ifdef IRIX
#include <nasd/irix/nasd_irix_sys.h>
#endif /* IRIX */

struct nasd_od_config_s {
  nasd_layout_type_t   layout_type;
  nasd_ioqueue_type_t  ioqueue_type;
  int                  ios_outstanding;
};

struct nasd_serv {
  char               root_path[1024];
  nasd_sys_dev_t     dev;
  int                do_format;
  int                cache_blocks;
  int                svc_threads;
  int                stack_size;
  int                port;
  int                verbose;
  int                use_tcp;
  int                security_enabled;
  nasd_uint64        max_disk_len;
  nasd_uint16        required_protection;
  nasd_key_t         daily;
  nasd_key_t         old_daily;
  nasd_key_t         working;
  nasd_key_t         master;
  nasd_od_config_t   config;
  nasd_uint16        ipport;
};

struct nasd_edrfs_mount {
  char         drive_ip_addr[16];
  char         name[64];
  char         path[1024];
  int          portnum;
  int          partnum;
  nasd_uint32  net_addr;
};

struct nasd_edrfs_config {
  struct nasd_edrfs_mount  *mount_array;
  int                       mount_array_len;
  int                       verbose;
  int                       svc_threads;
  int                       stack_size;
  int                       colocate;
  nasd_uint16               ipport;
};

struct nasd_options_s {
  nasd_uint64  opts1;
  nasd_uint64  opts_rpc;
  nasd_uint16  opts_seclevel;
};

struct nasd_timeout_test_s {
  nasd_status_t    nasd_status;
  nasd_timespec_t  delta;
};

/* opts1 stuff */
#define NASD_OPTS1_SECURITY     (1<<0)
#define NASD_OPTS1_EDRFS_CLIENT (1<<1)
#define NASD_OPTS1_EDRFS_FM     (1<<2)
#define NASD_OPTS1_DRIVE        (1<<3)
#define NASD_OPTS1_KPDEV        (1<<4)

/* opts_rpc stuff */
#define NASD_OPTS_RPC_COLOCATE  (1<<0)
#define NASD_OPTS_RPC_DCE       (1<<1)
#define NASD_OPTS_RPC_SRPC      (1<<2)

#ifdef KERNEL

struct nasd_svinfo_s {
  struct nasd_serv   srv;
#ifdef DEC_OSF
  size_t             size;
#else /* DEC_OSF */
  unsigned long      size;
#endif /* DEC_OSF */
};

struct nasd_edrfs_svinfo_s {
  struct nasd_edrfs_config  config;
};

#endif /* KERNEL */

#define NASD_SC_GET_OPTIONS       1
#define NASD_SC_TIMEOUT_TEST      2
#define NASD_SC_PSRV_GO           3
#define NASD_SC_SRV_PANIC         4
#define NASD_SC_EDRFS_SRV_GO      5
#define NASD_SC_ATOMIC_MATH_TEST  6

#define NASD_WIRE_DIR_READ  1
#define NASD_WIRE_DIR_WRITE 2
#define NASD_WIRE_DIR_TREAD 3
#define NASD_WIRE_DIR_ALL   4

#ifndef KERNEL
extern int nasd_srv(int cmd, void *arg);
extern nasd_status_t nasd_kernel_timeout_test(nasd_timespec_t delta);
#endif /* !KERNEL */

#ifdef KERNEL
extern int nasd_sys_wire_buf(void *buf, int len, void **iobufp, int dir);
extern int nasd_sys_unwire_buf(void *buf, int len, void *iobuf, int dir);
extern int nasd_sys_copyin(void *src, void *dst, int len);
extern int nasd_sys_copyout(void *src, void *dst, int len);
#endif /* KERNEL */

#endif /* !_NASD__NASD_SYS_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
