/*
 * nasd_general_simple.h
 *
 * No-types-dependent general stuff
 *
 * Authors: Mark Holland, Daniel Stodolsky, Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1995,1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_GENERAL_SIMPLE_H_
#define _NASD__NASD_GENERAL_SIMPLE_H_

#include <nasd/nasd_options.h>

#ifdef LINUX
#include <nasd/linux/nasd_linux_general_simple.h>
#endif /* LINUX */

#ifdef DEC_OSF
#include <nasd/dux/nasd_dux_general_simple.h>
#endif /* DEC_OSF */

#ifdef IRIX
#include <nasd/irix/nasd_irix_general_simple.h>
#endif /* IRIX */

#ifdef SOLARIS
#include <nasd/solaris/nasd_solaris_general_simple.h>
#endif /* SOLARIS */

#ifdef FREEBSD
#include <nasd/freebsd/nasd_freebsd_general_simple.h>
#endif /* FREEBSD */

#ifdef __STDC__
#define NASD_STRING(_str_) #_str_
#define NASD_CONCAT(_a_,_b_) _a_##_b_
#else /* __STDC__ */
#define NASD_STRING(_str_) "_str_"
#define NASD_CONCAT(_a_,_b_) _a_/**/_b_
#endif /* __STDC__ */

#define NASD_MIN(_a_,_b_) (((_a_)<(_b_))?(_a_):(_b_))
#define NASD_MAX(_a_,_b_) (((_a_)>(_b_))?(_a_):(_b_))
#define NASD_ABS(_a_)     (((_a_) > 0) ? (_a_) : (-(_a_)))

#endif /* !_NASD__NASD_GENERAL_SIMPLE_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
