/*
 * nasd_cheops_client_internal.h
 *
 * Interfaces internal to the Cheops Clerk
 */
/*
 * Authors: Sean Levy
 *
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */

#ifndef _NASD__NASD_CHEOPS_CLIENT_INTERNAL_H_
#define _NASD__NASD_CHEOPS_CLIENT_INTERNAL_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_itypes.h>
#include <nasd/nasd_common.h>
#include <nasd/nasd_threadstuff.h>
#include <nasd/nasd_shutdown.h>
#include <nasd/nasd_cheops_types.h>
#include <nasd/nasd_cheops_mgr.h>
#include <nasd/nasd_cheops_cache.h>
#include <nasd/nasd_cheops_ios.h>
#include <nasd/nasd_cheops_raidmap.h>
#include <nasd/nasd_pdrive_client.h>

/* nasd_cheops_cl_aio.c */
extern int _nasd_cheops_ioq_init(void);
extern void _nasd_cheops_deq_io(_nasd_cheops_io_t **ret_item);
extern void _nasd_cheops_init_io(NASD_pda_t *, _nasd_cheops_aggr_io_t *,
                                 _nasd_cheops_io_t *);
extern int _nasd_cheops_enq_io(_nasd_cheops_io_t *io);
extern void _nasd_cheops_asm_freeall(nasd_asm_t *);
extern void _nasd_cheops_io_freeall(_nasd_cheops_aggr_io_t *);
nasd_boolean_t _nasd_cheops_ioq_empty(_nasd_cheops_ioq_t *);

/* nasd_cheops_cl_doio.c */
extern void _nasd_cheops_doio_init(void);

extern void _nasd_cheops_print_asm(nasd_asm_t *);

extern int _nasd_cheops_doio_n_threads;
extern _nasd_cheops_cache_t *_nasd_cheops_dr_handle_cachep;

#endif /* !_NASD__NASD_CHEOPS_CLIENT_INTERNAL_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
