/*
 * nasd_cheops_mgr_sec.c
 *
 * Sec utilities
 *
 * Authors: Khalil Amiri, CMU SCS/ECE, July 18 1997
 *          Sean Levy, CMU SCS, July 1999
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <malloc.h>

#include <nasd/nasd_itypes.h>
#include <nasd/nasd_common.h>
#include <nasd/nasd_cheops_types.h>
#include <nasd/nasd_cheops_mgr_internal.h>
#include <nasd/nasd_cheops_common.h>
#include <nasd/nasd_cheops_mgr_common.h>  
#include <nasd/nasd_cheops_rpc.h>

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE
int
nasd_cheops_mgr_check_cookie(
  handle_t          client_handle,
  nasd_cookie_t     cookie, 
  nasd_identifier_t identifier, 
  nasd_cheops_mgr_op_t  op)
{
  return 0;
}
#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE */

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_SRPC
int
nasd_cheops_mgr_check_cookie(
  nasd_srpc_listener_t                  *listener,
  nasd_srpc_conn_t                      *conn,
  nasd_srpc_server_call_t               *call,
  nasd_cookie_t				 in_cookie,
  nasd_identifier_t			 in_oid,
  nasd_cheops_mgr_op_t			 op)
{
  return 0;
}
#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_SRPC */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
