/*
 * nasd_cheops_time.h
 *
 * Author: Khalil Amiri, CMU SCS/ECE
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>
#include <nasd/nasd_timer.h>

#define CHEOPS_REPORT_BANDWIDTH(_mb_) \
 (cheops_Msg "Bandwidth %f MB/sec\n", (_mb_)/accum_time)

#define CHEOPS_DECLARE_TIME \
  double accum_time, d, avg; \
  nasd_timespec_t diff; \
  nasd_timer_t timer; \
  int iter;

#define CHEOPS_INIT_TIME \
  accum_time = (double)0.0;

#define CHEOPS_BEGIN_TIME \
  NASD_TM_START(&timer); \

#define CHEOPS_END_TIME \
  NASD_TM_STOP(&timer); \
  NASD_TM_ELAPSED_TS(&timer, &diff); \
  d = (double)diff.ts_nsec; \
  d /= (double)1000000000.0; \
  d += (double)diff.ts_sec; \
  accum_time += d;

#define CHEOPS_REPORT_TIME(_op_) { \
  iter = 1; \
  avg = accum_time; \
  nasd_printf("OPERATION: %s\n", _op_); \
  nasd_printf("  %f seconds for %d operations\n", accum_time, iter); \
  nasd_printf("  %f seconds average\n", avg); \
}
