##### XML tools options.
# Build profiled binaries. Require profiled libraries (*_p.a) be
# installed on the system.
MKXMLTOOLS_PROFILE?=	no
# Build standalone (out-of-tree) shared binaries. For debugging
# purposes.
MKXMLTOOLS_STANDALONE?=	no

##### Build flags.
# -Wno-missing-field-initializers could be removed elegantly if we
# used C99 named initializers, but we don't use C99.
WARNS=		4
CWARNFLAGS+=	-Wno-missing-field-initializers

CPPFLAGS+=	-I${.CURDIR}/../

##### Expat.
# XXX: This will probably be simplified when Expat is imported into
# base. Until then, we will use Expat from pkgsrc.
EXPAT_PREFIX?=	/usr/pkg
EXPAT_INCLUDE?=	${EXPAT_PREFIX}/include
EXPAT_LIB?=	${EXPAT_PREFIX}/lib

.if empty(EXPAT_PREFIX)
LDADD+=		-lexpat
.else
CPPFLAGS+=	-I${EXPAT_INCLUDE}
LDADD+=		-L${EXPAT_LIB} -lexpat
LDFLAGS+=	-Wl,-rpath,${EXPAT_LIB}
.endif

##### libregxml.
.if ${.CURDIR:T} != "regxml"
LIBREGXML!=	cd ${.CURDIR}/../regxml && ${PRINTOBJDIR}
LDADD+=		-L${LIBREGXML}
.if ${MKPROFILE} == "yes" && ${MKXMLTOOLS_PROFILE} == "yes"
LDADD+=		-lregxml_p -lm_p -lc_p
.else
LDADD+=		-lregxml
.endif
DPADD+=		${LIBREGXML}/libregxml.a
.endif

##### Profiled build.
.if ${MKPROFILE} == "yes" && ${MKXMLTOOLS_PROFILE} == "yes"
COPTS+=		-pg -fno-inline
LDFLAGS+=	-pg
.endif

##### Stand-alone build.
.if ${MKXMLTOOLS_STANDALONE} == "yes"
.for libdir in ${LDADD:M-L*}
LDFLAGS+=	${libdir:C/^-L/-Wl,-rpath,/g}
.endfor
.endif
