# Adopters

We're happy to be trusted by the following projects and organizations.

If you're using Regal, please consider opening a pull request to add your project or organization to this list!

## Open Source Projects

Public open source projects integrating Regal for linting in their CI/CD pipelines.

<!-- cspell:disable -->
- [Brainiac](https://github.com/carbonetes/brainiac)
- [Cloudbeat](https://github.com/elastic/cloudbeat)
- [Conftest](https://github.com/open-policy-agent/conftest)
- [CVAT](https://github.com/opencv/cvat)
- [GKE Policy Automation](https://github.com/google/gke-policy-automation)
- [Konstraint](https://github.com/plexsystems/konstraint)
- [Kubescape](https://github.com/kubescape/regolibrary)
- [Legitify](https://github.com/Legit-Labs/legitify)
- [Matrix Authentication Service](https://github.com/element-hq/matrix-authentication-service/)
- [Minder](https://github.com/stacklok/minder)
- [Modernisation Platform](https://github.com/ministryofjustice/modernisation-platform)
- [OPA Library](https://github.com/open-policy-agent/library)
- [Red Hat COP](https://github.com/redhat-cop/rego-policies)
- [ScubaGear](https://github.com/cisagov/ScubaGear)
- [ScubaGoggles](https://github.com/cisagov/ScubaGoggles)
- [Spacelift Policy Library](https://github.com/spacelift-io/spacelift-policies-example-library)
- [Trino Operator](https://github.com/stackabletech/trino-operator)
- [Trivy](https://github.com/aquasecurity/trivy-checks)
- [Phylum](https://github.com/phylum-dev/policy)
<!-- cspell:enable -->

## Integrations

Projects and products that integrate Regal into their offerings.

<!-- cspell:disable -->
- [Dependency Management Data](https://gitlab.com/tanna.dev/dependency-management-data)
- [Enterprise OPA](https://github.com/styrainc/enterprise-opa)
- [The Rego Playground](https://play.openpolicyagent.org)
- [Trunk Check](https://trunk.io/check)
- [reviewdog/action-regal](https://github.com/reviewdog/action-regal)
<!-- cspell:enable-->

## Packaging

The following package managers include Regal in their repositories, either natively or via plugins.

- [Homebrew](https://brew.sh/) via Styra's [homebrew-packages](https://github.com/StyraInc/homebrew-packages)
- [asdf](https://asdf-vm.com/) via [asdf-regal](https://github.com/asdf-community/asdf-regal)
- [mise](https://mise.jdx.dev/) via its [aqua](https://aquaproj.github.io/) backend and [aqua's regal definition](https://github.com/aquaproj/aqua-registry/tree/main/pkgs/StyraInc/regal)
- [pkgsrc](https://www.pkgsrc.se/) and the [regal](https://pkgsrc.se/devel/regal) package
- [Nix](https://nixos.org/): [regal](https://search.nixos.org/packages?channel=24.05&show=regal&from=0&size=50&sort=relevance&type=packages&query=regal)
- [mason.vim](https://github.com/williamboman/mason.nvim): [regal](https://github.com/mason-org/mason-registry/blob/main/packages/regal/package.yaml)

## Companies and Organizations

Companies and organizations using Regal (not counting organizations behind the open source projects listed above).

<!-- cspell:disable -->
- [Atlassian](https://www.atlassian.com)
- [Bankdata](https://www.bankdata.dk)
- [Miro](https://miro.com)
- [Stacklok](https://stacklok.com)
- [Styra](https://www.styra.com)
- [UNIwise](https://uniwise.eu/)
- [VodafoneZiggo](https://www.vodafoneziggo.nl)
<!-- cspell:enable-->

## Community

If you'd like to discuss Regal adoption or just talk about Regal in general, please join us in the `#regal`
channel in the Styra Community [Slack](https://inviter.co/styra)!
