#!/bin/sh

cd ${HOME}/RC5/

HOSTNAME=`hostname -s`
NOW=`date +'%Y%m%d%H%M%S'`
CPU=`./bin/config.guess`

if [ ! -d log ] ; then
    mkdir log
fi

if [ ! -d $HOSTNAME ] ; then
    mkdir $HOSTNAME
fi

ARGS="-ini master.ini \
    -e explorer-rc5@flame.org \
    -l log/${HOSTNAME}-${NOW}.log \
    -b 40 \
    -nice 0 \
    -in ${HOSTNAME}/${HOSTNAME}-in.rc5 -out ${HOSTNAME}/${HOSTNAME}-out.rc5 \
    -in2 ${HOSTNAME}/${HOSTNAME}-in.des -out2 ${HOSTNAME}/${HOSTNAME}-out.des \
    -percentoff \
    -ckpoint ${HOSTNAME}/${HOSTNAME}-chkpt.rc5 \
    -ckpoint2 ${HOSTNAME}/${HOSTNAME}-chkpt.des \
"

case "$CPU" in
    alpha-*-netbsd1.3*)
	CLI=v2.7024.409/rc5des-netbsd-alpha-1.3.1
	;;
    arm32-*-netbsd1.3E)
	CLI=v2.7024.409/rc5des-netbsd-arm32-1.3E
	;;
    i386-*-netbsd1.2G)
	CLI=v2.7024.409/rc5des-netbsd-i386-1.2G
	;;
    i386-*-netbsd1.2*)
	CLI=v2.7024.409/rc5des-netbsd-i386-1.2
	;;
    i386-*-netbsd1.3*)
	CLI=v2.7024.409/rc5des-netbsd-i386-1.3.1
	;;
    i386-*-bsdi3.*)
	CLI=rc5des-bsdi-3.0
	;;
    i*86-*-linux)
	CLI=rc5des-linux-i386
	;;
esac

echo ./bin/$CLI $ARGS $*
./bin/$CLI $ARGS $* < /dev/null > /dev/null 2>&1 &

echo Client started
