/******************************************************************************/
/*                                                                            */
/*                         RAINE DOUBLE SIZE BLITTING                         */
/*                                                                            */
/******************************************************************************/

#include "raine.h"

void raine_blit_x2_y1_32(al_bitmap *src, al_bitmap *dest, int s_x, int s_y, int d_x, int d_y, int w, int h)
{
	int x, y;
	int new_x;

	acquire_bitmap(dest);
	for( y = 0; y < h ; y++ )
	{
		for( x = 0, new_x = 0; x < w; x++, new_x+=8 )
		{
			dest->line[ y + d_y ][ new_x + d_x   ] = src->line[ y + s_y ][ x + s_x   ];
			dest->line[ y + d_y ][ new_x + d_x+1 ] = src->line[ y + s_y ][ x + s_x+1 ];
			dest->line[ y + d_y ][ new_x + d_x+2 ] = src->line[ y + s_y ][ x + s_x+2 ];
			dest->line[ y + d_y ][ new_x + d_x+3 ] = src->line[ y + s_y ][ x + s_x+3 ];
			dest->line[ y + d_y ][ new_x + d_x+4 ] = src->line[ y + s_y ][ x + s_x   ];
			dest->line[ y + d_y ][ new_x + d_x+5 ] = src->line[ y + s_y ][ x + s_x+1 ];
			dest->line[ y + d_y ][ new_x + d_x+6 ] = src->line[ y + s_y ][ x + s_x+2 ];
			dest->line[ y + d_y ][ new_x + d_x+7 ] = src->line[ y + s_y ][ x + s_x+3 ];
		}
	}
	release_bitmap(dest);
}

void raine_blit_x2_y2_32(al_bitmap *src, al_bitmap *dest, int s_x, int s_y, int d_x, int d_y, int w, int h)
{
	int x, y;
	int new_x, new_y;

	acquire_bitmap(dest);
	for( y = 0, new_y = 0; y < h ; y++, new_y+=2 )
	{
		for( x = 0, new_x = 1; x < w; x++, new_x+=6 )
		{
			dest->line[ new_y + d_y   ][ new_x + d_x   ] = src->line[ y + s_y ][ x + s_x   ];
			dest->line[ new_y + d_y   ][ new_x + d_x+1 ] = src->line[ y + s_y ][ x + s_x+1 ];
			dest->line[ new_y + d_y   ][ new_x + d_x+2 ] = src->line[ y + s_y ][ x + s_x+2 ];
			dest->line[ new_y + d_y   ][ new_x + d_x+3 ] = src->line[ y + s_y ][ x + s_x+3 ];
			dest->line[ new_y + d_y   ][ new_x + d_x+4 ] = src->line[ y + s_y ][ x + s_x   ];
			dest->line[ new_y + d_y   ][ new_x + d_x+5 ] = src->line[ y + s_y ][ x + s_x+1 ];
			dest->line[ new_y + d_y   ][ new_x + d_x+6 ] = src->line[ y + s_y ][ x + s_x+2 ];
			dest->line[ new_y + d_y   ][ new_x + d_x+7 ] = src->line[ y + s_y ][ x + s_x+3 ];

			dest->line[ new_y + d_y+1 ][ new_x + d_x   ] = src->line[ y + s_y ][ x + s_x   ];
			dest->line[ new_y + d_y+1 ][ new_x + d_x+1 ] = src->line[ y + s_y ][ x + s_x+1 ];
			dest->line[ new_y + d_y+1 ][ new_x + d_x+2 ] = src->line[ y + s_y ][ x + s_x+2 ];
			dest->line[ new_y + d_y+1 ][ new_x + d_x+3 ] = src->line[ y + s_y ][ x + s_x+3 ];
			dest->line[ new_y + d_y+1 ][ new_x + d_x+4 ] = src->line[ y + s_y ][ x + s_x   ];
			dest->line[ new_y + d_y+1 ][ new_x + d_x+5 ] = src->line[ y + s_y ][ x + s_x+1 ];
			dest->line[ new_y + d_y+1 ][ new_x + d_x+6 ] = src->line[ y + s_y ][ x + s_x+2 ];
			dest->line[ new_y + d_y+1 ][ new_x + d_x+7 ] = src->line[ y + s_y ][ x + s_x+3 ];

		}
	}
	release_bitmap(dest);
}
