#!/usr/bin/perl

use v5.10;
use strict;

# take an official history.dat and filter out all the useless stuff for
# raine, + fix the urls they had previously !

my $history = shift @ARGV;
die "pass history file in parameter" if (!$history);

open(F,"./raine -gl|") || die "can't launch ./raine -gl";
my @games = ();
while (<F>) {
	if (/^(.+?)[ \t]*\: /) {
		push @games,$1;
	}
}
close(F);
# Games included in multi15, not everything, some couldn't be found in history.dat !
# But lots of clones there, so I guess it's normal.
push @games,("hangly","eyes","crush","mspacmat","lizwiz");
my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
$year += 1900;
$mon++;

say "# Generated by filter_history.pl on ".sprintf("%d-%02d-%02d",$year,$mon,$mday);
open(F,"<$history") || die "can't open $history";
my $skip = 0;
my $blank = 0;
while (<F>) {
	chomp;
	s/\r//;
	if (/^\$info\=(.+)/) {
		s/tharrier/tforceh/;
		s/blkheartj/blkhearj/;
		if (/tnzs,/ && !/tnzsb,/) {
			$_ .= "," if (!/,$/);
			$_ .= "tnzsb,tnzs2,";
		} elsif (/=bgaregga,/ && !/battleg/) {
			$_ .= "," if (!/,$/);
			$_ .= "battleg,";
		} elsif (/=tharrier,/) {
			$_ .= "tforceh";
		} elsif (/=megablst,/ && !/megab(,|$)/) {
			$_ .= "," if (!/,$/);
			$_ .= "megab";
		} elsif (/=dangar,/ && !/dangarb/) {
			$_ .= "," if (!/,$/);
			$_ .= "dangarb";
		} elsif (/=gekiridn,/ && !/gekirido/) {
			$_ .= "," if (/,$/);
			$_ .= "gekirido";
		}
		/^\$info\=(.+)/;
		my $list = $1;
		$list =~ s/ //g;
		my @list = split /\,/,$list;
		$skip = 1;
		foreach (@list) {
			my $game = $_;
			if (grep { $game eq $_} @games) {
				$skip = 0;
			}
		}
	} elsif (/^\$(.+?)\=/) { # toutes les consoles etc de ness sont arrivées là-dedans !
		$skip = 1;
	} elsif (/^\$end/) {
		if ($skip) {
			$skip = 0;
			next;
		}
	}
	next if ($skip);
	next if ($_ eq "" && $blank);
	s/^(.+): (http.+)/<a href="$2">$1<\/a>/;
	say;
	$blank = ($_ eq "");
}
close(F);
