/***********************************************************************
 *	¿ʴؿ
 ************************************************************************/
#include <string.h>

/*===========================================================================
 * ʸʸζ̤ʤʸ (stricmp/strcasecmp ?)
 *	: ׻ == 0, ԰׻ != 0 (羮ӤϤʤ)
 *===========================================================================*/
int	my_strcmp( const char *s, const char *d )
{
  if( s==NULL || d==NULL ) return 1;

  while( tolower(*s) == tolower(*d) ){
    if( *s == '\0' ) return 0;
    s++;
    d++;
  }
  return 1;
}

/*===========================================================================
 * ʸ ct  ʸ s  ԡ (strlcpy ?)
 *	s ʸüϡɬ '\0' Ȥʤꡢs Ĺ n-1 ʸʲ˼ޤ롣
 *	;ʬΰ \0 ʤ
 *	: ʤ
 *===========================================================================*/
void	my_strncpy( char *s, const char *ct, unsigned long n )
{
  s[0] = '\0';
  strncat( s, ct, n-1 );
}

/*===========================================================================
 * ʸ ct  ʸ s  Ϣ (strlcat ?)
 *	s ʸüϡɬ '\0' Ȥʤꡢs Ĺ n-1 ʸʲ˼ޤ롣
 *	: ʤ
 *===========================================================================*/
void	my_strncat( char *s, const char *ct, unsigned long n )
{
  size_t used = strlen(s) + 1;

  if( n > used )
    strncat( s, ct, n - used );
}

/*===========================================================================
 * SJIS  EUC Ѵ (ʤŬ)
 *	*sjis_p ʸ EUC Ѵơ*euc_p ˳Ǽ롣
 *
 *	աˤδؿϡХåեդåƤʤ
 *		*euc_p ϡ*sjis_p ܰʾĹʤȴ
 *===========================================================================*/
void	sjis2euc( char *euc_p, const char *sjis_p )
{
  int	h,l, h2, l2;

  while( ( h = (unsigned char)*sjis_p++ ) ){

    if( h < 0x80 ){				/* ASCII */

      *euc_p ++ = h;

    }else if( 0xa1 <= h && h <= 0xdf ){		/* Ⱦѥ */

      *euc_p ++ = (char)0x8e;
      *euc_p ++ = h;

    }else{					/* ʸ */

      if( ( l = (unsigned char)*sjis_p++ ) ){

	if( l <= 0x9e ){
	  if( h <= 0x9f ) h2 = (h - 0x71) *2 +1;
	  else            h2 = (h - 0xb1) *2 +1;
	  if( l >= 0x80 ) l2 = l - 0x1f -1;
	  else            l2 = l - 0x1f;
	}else{
	  if( h <= 0x9f ) h2 = (h - 0x70) *2;
	  else            h2 = (h - 0xb0) *2;
	  l2 = l - 0x7e;
	}
	*euc_p++ = 0x80 | h2;
	*euc_p++ = 0x80 | l2;

      }else{
	break;
      }

    }
  }

  *euc_p = '\0';
}


/*===========================================================================
 * EUC  SJIS Ѵ (ʤŬ)
 *	*euc_p ʸ SJIS Ѵơ*sjis_p ˳Ǽ롣
 *
 *	աˤδؿϡХåեդåƤʤ
 *		*sjis_p ϡ*euc_p ƱʾĹʤȴ
 *===========================================================================*/

void	euc2sjis( char *sjis_p, const char *euc_p )
{
  int	h,l;

  while( ( h = (unsigned char)*euc_p++ ) ){

    if( h < 0x80 ){				/* ASCII */

      *sjis_p ++ = h;

    }else if( h==0x8e ){			/* Ⱦѥ */

      if( ( h = (unsigned char)*euc_p++ ) ){

	if( 0xa1 <= h && h <= 0xdf )
	  *sjis_p ++ = h;

      }else{
	break;
      }

    }else if( h & 0x80 ){			/* ʸ */

      if( ( l = (unsigned char)*euc_p++ ) ){

	if( l & 0x80 ){

	  h = (h & 0x7f) - 0x21;
	  l = (l & 0x7f) - 0x21;

	  if( h & 0x01 ) l += 0x9e;
	  else           l += 0x40;
	  if( l >= 0x7f ) l += 1;

	  h = (h>>1) + 0x81;

	  if( h >= 0xa0 ) h += 0x40;

	  *sjis_p++ = h;
	  *sjis_p++ = l;

	}

      }else{
	break;
      }

    }
  }

  *sjis_p = '\0';
}


/*===========================================================================
 * EUCʸĹ׻ (äŬ)
 *	ASCIIȾѥʤ1ʸѴ2ʸȤ롣
 *	ʸΡ\0 Ĺ˴ޤʤ
 *===========================================================================*/

int	euclen( const char *euc_p )
{
  int	i = 0, h;

  while( ( h = (unsigned char)*euc_p++ ) ){

    if( h < 0x80 ){				/* ASCII */

      i++;

    }else if( h == 0x8e ){			/* Ⱦѥ */

      euc_p ++;
      i++;

    }else{					/*  */

      euc_p ++;
      i += 2;

    }
  }

  return i;
}

/*===========================================================================
 * ʸ src ȡʬ䤹롣
 *	ڤʸϡڡȥ֡ƬΥڡ̵֤뤵롣
 *	ʬ䤷ȡ ( \0 ղä ) dst ˥ԡ
 *	src λĤʸʬƬɥ쥹֤
 *	ʾʬǤʤ dst ˤ "\0" 򥳥ԡNULL֤
 *
 *	ȡʬ䤹ݤΥ롼
 *	   (\r or \n) ʤ ü(\0) ʸϽȤߤʤ
 *	̤ʸ
 *	   ڡȥ֤ϡڤʸȤ
 *	   # ϥʸȤüʸƱͤ˰
 *	   \ ϥʸȤ롣ڡ֡#"\  \ 
 *	     硢̤ʸȤ̾ʸƱͤ˰
 *	     ¾ʸ \ 硢ñ \ ϥåפ롣
 *	   " ϰʸȤ롣ʸǰϤޤ줿ʬʸˤĤơ
 *	     ڡ֡#\ ̤ʸȤߤʤʤ
 *	      "" 2ʸ³Ƥ˸¤ꡢ" Ȥߤʤ
 *===========================================================================*/
#define	COMMENT		'#'
#define	ESCAPE		'\\'
#define	QUOTE		'\"'
char	*my_strtok( char *dst, char *src )
{
  char *p = &src[0];
  char *q = &dst[0];

  int esc   = FALSE;			/* ץ󥹽 */
  int quote = FALSE;			/* ʸ         */

  *q = '\0';

  while( *p==' ' || *p=='\t' ){		/* ƬΥڡ֤򥹥å */
    p ++;
  }

  while(1){

    if( quote == FALSE ){		/* ̾ʬν */

      if( esc == FALSE ){
	if     ( *p=='\0' ||
		 *p=='\r' ||
		 *p=='\n' ||
		 *p==' '  ||
		 *p=='\t' ||
		 *p==COMMENT ){ *q = '\0';   break; }
	else if( *p==QUOTE   ){         p++; quote = TRUE; }
	else if( *p==ESCAPE  ){         p++; esc = TRUE;   }
	else                  { *q++ = *p++;               }
      }else{
	if     ( *p=='\0' ||
		 *p=='\r' ||
		 *p=='\n' )   { *q = '\0'; break; }
	else                  { *q++ = *p++; esc = FALSE;  }
      }

    }else{				/* " " ǰϤޤ줿ʬν */

	if     ( *p=='\0' ||
		 *p=='\r' ||
		 *p=='\n'   ){ *q = '\0';   break; }
	else if( *p==QUOTE  )
	  if( *(p+1)==QUOTE ){ *q++ = QUOTE; p+=2; quote = FALSE; }
	  else               {               p++;  quote = FALSE; }
	else                 { *q++ = *p++;                }

    }
  }

  if( *dst == '\0' ) return NULL;
  else               return p;
}
