/***********************************************************************
 * ɽϽ (ƥ¸)
 *
 *      ܺ٤ϡ snddrv.h / mame-quasi88.h 
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef	USE_SOUND

#include "mame-quasi88.h"

#define  SNDDRV_WORK_DEFINE
#include "audio.h"

#include "sysdep_mixer.h"	/* sysdep_mixer_init()	*/

/*----------------------------------------------------------------------*/
/* rc_struct ¤Τˤꡢץ椹 */

static struct rc_struct *rc;

extern	struct rc_option sound_opts[];


/*===========================================================================*/
/*              QUASI88 ƤӽФ롢MAME νؿ                    */
/*===========================================================================*/

/******************************************************************************
 * ɷϥץνλؿ
 *
 * int xmame_config_init(void)
 *      config_init() ꡢץβϤ򳫻Ϥ˸ƤӽФ롣
 *      MAME¸νʤɤɬפʾϡǹԤ
 *
 * void xmame_config_exit(void)
 *      config_exit() ꡢκǸ˸ƤӽФ롣
 *      xmame_config_init() νθդɬפʤ顢ǹԤ
 *
 *****************************************************************************/
/*		config_init() [src/unix/config.c] */
int		xmame_config_init(void)
{
   /* create the rc object */
   if (!(rc = rc_create()))
      return OSD_NOT_OK;

   if(sysdep_dsp_init(rc, NULL))
      return OSD_NOT_OK;

   if(sysdep_mixer_init(rc, NULL))
      return OSD_NOT_OK;

   if(rc_register(rc, sound_opts))
      return OSD_NOT_OK;

   return OSD_OK;
}

/*		config_exit() [src/unix/config.c] */
void	xmame_config_exit(void)
{
   if(rc)
   {
      sysdep_mixer_exit();
      sysdep_dsp_exit();
      rc_destroy(rc);
   }
}


/******************************************************************************
 * ɷϥץΥץơ֥
 *
 * const T_CONFIG_TABLE *xmame_config_get_opt_tbl(void)
 *      config_init() ꡢ xmame_config_init() θ˸ƤӽФ롣
 *
 *      ɷϥץβϽˤơ QUASI88 Υץơ֥
 *      T_CONFIG_TABLE Ѥ硢Υݥ󥿤֤
 *      ȼǲϤϡ NULL ֤
 *****************************************************************************/
const T_CONFIG_TABLE *xmame_config_get_opt_tbl(void)
{
	return NULL;
}


/******************************************************************************
 * ɷϥץΥإץåɽ
 *
 * void xmame_config_show_option(void)
 *      config_init() ꡢץ -help νκݤ˸ƤӽФ롣
 *      ɸϤ˥إץåɽ롣
 *****************************************************************************/
void	xmame_config_show_option(void)
{
	fprintf(stdout, 
			"\n"
			"==========================================\n"
			"== SOUND OPTIONS ( dependent on XMAME ) ==\n"
			"==                     [ XMAME 0.71.1 ] ==\n"
			"==========================================\n"
			);

	rc_print_help(rc, stdout);
}


/******************************************************************************
 * ɷϥץβϽ
 *
 * int xmame_config_check_option(char *opt1, char *opt2, int priority)
 *      config_init() ꡢեβϤԤʤݤˡ
 *      ΥץΤˤפʤ硢δؿƤӽФ롣
 *
 *              opt1      ǽΰ(ʸ)
 *              opt2      Τΰ(ʸ ʤ NULL)
 *              priority  ͥ (ͤ礭ۤͥ٤⤤)
 *
 *        1   1 (opt1 Τ߽ opt2 ̤)
 *              2   2 (opt1  opt2 )
 *              0   opt1 ̤ΤΰΤᡢ opt1 opt2 Ȥ̤
 *              -1  ̿Ūʰ۾郎ȯ
 *
 *      ΰ۾ (λͤϰϳʤ) 䡢ͥ٤ˤå
 *      줿褦ʾϡǤƱͤˡ 1  2 ֤
 *
 *       δؿϡȼǥץϤ뤿δؿʤΤǡ
 *         ץơ֥ T_CONFIG_TABLE ѤϡߡǤ褤
 *****************************************************************************/
int		xmame_config_check_option(char *opt1, char *opt2, int priority)
{
	return rc_quasi88(rc, opt1, opt2, priority);
}


/******************************************************************************
 * ɷϥץ¸뤿δؿ
 *
 * int  xmame_config_save_option(void (*real_write)
 *                                 (const char *opt_name, const char *opt_arg))
 *
 *      ե¸κݤˡƤӽФ롣
 *              opt_name ˥ץ opt_arg ˥ץ
 *                åȤreal_write ƤӽФ
 *              Ȥư¸ץФƷ֤Ԥʤ
 *
 *              () "-sound" ե¸
 *                      (real_write)("sound", NULL) ƤӽФ
 *              () "-fmvol 80" ե¸
 *                      (real_write)("fmvol", "80") ƤӽФ
 *
 *         0 ֤
 *
 *       δؿϡȼǥץϤ뤿δؿʤΤǡ
 *         ץơ֥ T_CONFIG_TABLE ѤϡߡǤ褤
 *****************************************************************************/
#include "rc_priv.h"
int		xmame_config_save_option(void (*real_write)
								   (const char *opt_name, const char *opt_arg))
{
	return rc_quasi88_save(rc->option, real_write);
}


/******************************************************************************
 * ɷϥץ˥塼ѹ뤿Υơ֥ؿ
 *
 * T_SNDDRV_CONFIG *xmame_config_get_sndopt_tbl(void)
 *
 *      ˥塼⡼ɤγϻ˸ƤӽФ롣
 *              ѹǽʥɷϥץξT_SNDDRV_CONFIG 
 *              ȤѰդƬݥ󥿤֤
 *              Ϻ5ĤޤǡˤϽüǡ򥻥åȤƤ
 *
 *              äѹǤΤ̵ NULL ֤
 *****************************************************************************/
/* T_SNDDRV_CONFIG *xmame_config_get_sndopt_tbl(void)     [src/unix/sound.c] */


/******************************************************************************
 * ɵǽξؿ
 *
 * int xmame_has_audiodevice(void)
 *      ɥǥХϤβݤ֤
 *      ʤǥХϲġʤԲġ
 *
 * int xmame_has_mastervolume(void)
 *      ɥǥХβ̤ѹǽɤ֤
 *      ʤѹǽʤԲġ
 *
 *****************************************************************************/
int		xmame_has_audiodevice(void)
{
	if (use_sound) {
		if (sound_stream) return TRUE;
	}
	return FALSE;
}

int		xmame_has_mastervolume(void)
{
    if (use_sound) {
		if (osd_has_sound_mixer()) return TRUE;
	}
	return FALSE;
}


/*===========================================================================*/
/*              MAME νؿƤӽФ롢ƥ¸ؿ        */
/*===========================================================================*/

/******************************************************************************
 * ɥǥХ
 *      δؿϡХѿ use_sound ξϡƤӽФʤ
 *
 * int osd_start_audio_stream(int stereo)
 *      ɥǥХ롣
 *          stereo ʤ饹ƥ쥪ϡʤΥϤǽ롣
 *          (ΥϤϡŤС MAME/XMAME  YM2203 
 *           ΤߡѤƤ롣ʳϤ٤ƥƥ쥪ϤѤ롣)
 *      δؿϡߥ졼γϻ˸ƤӽФ롣
 *          ϡ1ե졼ढΥץ֤
 *          Իϡ0 ֤
 *               0 ֤ QUASI88 λƤޤΤǡ
 *              ɥǥХν˼ԤǤ⡢ɽϤʤ
 *              ʤ᤿Ȥ硢ȤˤŬ֤ͤɬפ롣
 *
 * int osd_update_audio_stream(INT16 *buffer)
 *      ɥǥХ˽Ϥ롣
 *      δؿϡ1ե졼˸ƤӽФ롣buffer ˤ1ե졼ʬ
 *      (Machine->sample_rate / Machine->drv->frames_per_second) Υ
 *      ǡǼƤ롣ǡ 16bitդǡƥ쥪ξ
 *      ȱΥץ뤬ߤ¤Ǥ롣
 *
 *      ºݤˤδؿƤӽФ줿ߥ󥰤ǥǥХ˽Ϥ뤫뤤
 *      ǥХåե󥰤ӽϤ뤫ϡǤ롣
 *
 *      ͤϡ osd_start_audio_stream() Ʊ
 *
 * void osd_stop_audio_stream(void)
 *      ɥǥХλ롣
 *      δؿϡߥ졼νλ˸ƤӽФ롣
 *      ʹߡ osd_update_audio_stream() ʤɤϸƤӽФʤߥ졼
 *      Ƴϡ osd_start_audio_stream() ƤӽФ롣
 *
 * void osd_update_video_and_audio(void)
 *      ɥǥХνϤΣ
 *      ߥŪˤϡ osd_update_audio_stream() ľ˸ƤӽФ롣
 *      XMAME 0.106 ˹碌Ƥ뤬 osd_update_audio_stream() 
 *      ȼǤ줤СδؿϥߡǤ褤
 *
 * void osd_sound_enable(int enable)
 *      ɥǥХؤνϤꡦʤꤹ롣
 *          enable ʤϤꡢʤϤʤ
 *      δؿϡХѿ close_device ξΤߡƤӽФ롣
 *          ˥塼⡼ɤäݤˡ򵶤ȤƸƤӽФ
 *          ˥塼⡼ɤФݤˡ򿿤ȤƸƤӽФ
 *      δؿϡξˡɥǥХ (close) 
 *      ξ˳ (open) 褦ʼԤƤ뤬ɥǥХ
 *      ݤޤޤˤ褦ʼǤСߡδؿǤ褤
 *      ʤɥǥХؤνϤʤξ osd_update_audio_stream() 
 *      ʤɤδؿϸƤӽФ롣
 *
 *****************************************************************************/
/* int  osd_start_audio_stream(int stereo)                [src/unix/sound.c] */
/* int  osd_update_audio_stream(INT16 *buffer)            [src/unix/sound.c] */
/* void osd_stop_audio_stream(void)                       [src/unix/sound.c] */
/* void osd_sound_enable(int enable)                      [src/unix/sound.c] */

/*		osd_update_video_and_audio(struct mame_display *display) [src/unix/video.c] */
void	osd_update_video_and_audio(void)
{
   if (sound_stream && sound_enabled)
      sound_stream_update(sound_stream);
}


/******************************************************************************
 * 
 *
 * void osd_set_mastervolume(int attenuation)
 *      ɥǥХβ̤ꤹ롣 attenuation  ̤ǡ -320 
 *      (ñ̤ db) ѹΤǤʤǥХǤСߡǤ褤
 *
 * int osd_get_mastervolume(void)
 *      ߤΥɥǥХβ̤롣 ͤ -320 (ñ̤ db)
 *      ѹΤǤʤǥХǤСߡǤ褤
 *
 *****************************************************************************/
/* void osd_set_mastervolume(int attenuation)             [src/unix/sound.c] */
/* int  osd_get_mastervolume(void)                        [src/unix/sound.c] */

#endif	/* USE_SOUND */
