#ifndef SCREEN_H_INCLUDED
#define SCREEN_H_INCLUDED



typedef struct {
    unsigned	char	blue;			/* B̵ (07/255)	*/
    unsigned	char	red;			/* R̵ (07/255)	*/
    unsigned 	char	green;			/* G̵ (07/255)	*/
    unsigned 	char	padding;
} PC88_PALETTE_T;


/*
 *	PC-88 Related
 */

extern	PC88_PALETTE_T	vram_bg_palette;	/* طʥѥå	*/
extern	PC88_PALETTE_T	vram_palette[8];	/* Ƽѥå	*/

extern	byte	sys_ctrl;			/* OUT[30] SystemCtrl     */
extern	byte	grph_ctrl;			/* OUT[31] GraphCtrl      */
extern	byte	grph_pile;			/* OUT[53] Ť͹碌     */

#define	SYS_CTRL_80		(0x01)		/* TEXT COLUMN80 / COLUMN40*/
#define	SYS_CTRL_MONO		(0x02)		/* TEXT MONO     / COLOR   */

#define	GRPH_CTRL_200		(0x01)		/* VRAM-MONO 200 / 400 line*/
#define	GRPH_CTRL_64RAM		(0x02)		/* RAM   64K-RAM / ROM-RAM */
#define	GRPH_CTRL_N		(0x04)		/* BASIC       N / N88     */
#define GRPH_CTRL_VDISP		(0x08)		/* VRAM  DISPLAY / UNDISP  */
#define GRPH_CTRL_COLOR		(0x10)		/* VRAM  COLOR   / MONO    */
#define	GRPH_CTRL_25		(0x20)		/* TEXT  LINE25  / LINE20  */

#define	GRPH_PILE_TEXT		(0x01)		/* Ť͹碌 ɽ TEXT  */
#define	GRPH_PILE_BLUE		(0x02)		/*		       B   */
#define	GRPH_PILE_RED		(0x04)		/*		       R   */
#define	GRPH_PILE_GREEN		(0x08)		/*		       G   */



/*
 *	ѥ
 */

	/* 躹ʬ */

extern	char	screen_dirty_flag[ 0x4000*2 ];	/* ᥤΰ ʬ	*/
extern	int	screen_dirty_all;		/* ᥤΰ 蹹	*/
extern	int	screen_dirty_palette;		/*  		*/
extern	int	screen_dirty_status;		/* ơΰ 	*/
extern	int	screen_dirty_status_hide;	/* ơΰ õ	*/
extern	int	screen_dirty_status_show;	/* ơΰ */
extern	int	screen_dirty_frame;		/* ΰ 		*/

#define	screen_set_dirty_flag(x)	screen_dirty_flag[x] = 1
#define	screen_set_dirty_all()		screen_dirty_all = TRUE
#define	screen_set_dirty_palette()	do {				\
					  screen_dirty_palette = TRUE;	\
					  screen_dirty_all = TRUE;	\
					} while(0)
#define	screen_set_dirty_status()	screen_dirty_status = 0xff
#define	screen_set_dirty_status_hide()	screen_dirty_status_hide = TRUE
#define	screen_set_dirty_status_show()	screen_dirty_status_show = TRUE
#define	screen_set_dirty_frame()	screen_dirty_frame = TRUE;


	/* ¾ */

extern	int	frameskip_rate;		/* ɽιֳ		*/
extern	int	monitor_analog;		/* ʥ˥		*/
extern	int	use_auto_skip;		/* ưե졼ॹå		*/



/*
 *	ɽ
 */

enum {
    SCREEN_INTERLACE_NO = 0,		/* 󥿡쥹ɽʤ	*/
    SCREEN_INTERLACE_YES = 1,		/* 󥿡쥹ɽ		*/
    SCREEN_INTERLACE_SKIP = -1		/* 1饤󤪤ɽ		*/
};
extern	int	use_interlace;		/* 󥿡졼ɽ		*/

extern	int	use_half_interp;	/* ̥Ⱦʬ֤ */

enum {					/* ̥			*/
    SCREEN_SIZE_HALF,			/*		320 x 200	*/
    SCREEN_SIZE_FULL,			/*		640 x 400	*/
#ifdef	SUPPORT_DOUBLE
    SCREEN_SIZE_DOUBLE,			/*		1280x 800	*/
#endif
    SCREEN_SIZE_END
};
extern	int	screen_size;		/* ̥		*/

extern	int	use_fullscreen;		/* ɽ		*/

extern	double	mon_aspect;		/* ˥Υڥ	*/

extern	int	status_fg;		/* ơʿ		*/
extern	int	status_bg;		/* ơطʿ		*/

extern	int	show_status;		/* ơɽ̵ͭ		*/


/*
 *
 */

enum {
    SHOW_MOUSE = 0,
    HIDE_MOUSE = 1,
    AUTO_MOUSE = 2
};
extern	int	hide_mouse;		/* ޥ򱣤ɤ		*/
enum {
    UNGRAB_MOUSE = 0,
    GRAB_MOUSE   = 1
};
extern	int	grab_mouse;		/* ֤뤫ɤ		*/

extern	int	use_swcursor;		/* ˥塼ѥɽ롩*/
extern	int	now_swcursor;		/* ѥɽ?	*/


/*
 *	ɽǥХѥ
 */

#define	STATUS_HEIGHT	(20)

extern	int	WIDTH;			/* Хåե		*/
extern	int	HEIGHT;			/* Хåեĥ		*/
extern	int	DEPTH;			/* ӥåȿ	(8/16/32)	*/
extern	int	SCREEN_W;		/* ̲ (320/640/1280)	*/
extern	int	SCREEN_H;		/* ̽ĥ (200/400/800)	*/

extern	int	SCREEN_DX;		/* ɥȡ		*/
extern	int	SCREEN_DY;		/* ̥ꥢȤΥեå	*/

extern	char	*screen_buf;		/* ХåեƬ		*/
extern	char	*screen_start;		/* Ƭ			*/

extern	char	*status_buf;		/* ơ Ƭ		*/
extern	char	*status_start[3];	/* ơ Ƭ		*/
extern	int	status_sx[3];		/* ơ襵		*/
extern	int	status_sy[3];




extern	Ulong	color_pixel[16];		/* 		*/
extern	Ulong	color_half_pixel[16][16];	/* 䴰ο	*/
extern	Ulong	black_pixel;			/* ο		*/
enum {						/* ơ˻Ȥ	*/
    STATUS_BG,					/*	طʿ()	*/
    STATUS_FG,					/*	ʿ()	*/
    STATUS_BLACK,				/*			*/
    STATUS_WHITE,				/*			*/
    STATUS_RED,					/*	ֿ		*/
    STATUS_GREEN,				/*	п		*/
    STATUS_COLOR_END
};
extern	Ulong	status_pixel[STATUS_COLOR_END];	/* ơο	*/



/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
                          WIDTH
	 
	 
	                                       
	              SCREEN_DY                
	                                       
	     
	   SCREEN_DX                       
	                   HEIGHT
	                   SCREEN_W        
	                                   
	                SCREEN_H           
	                                   
	                   
	                                         
	 
	ơ0 ơ1 ơ2  STATUS_HEIGHT
	 
	    ơ02ΥΨϡ 1:3:1

	screen_buf	ХåեΡƬݥ
	WIDTH		ХåեΡԥ
	HEIGHT		                  ĥԥ

	screen_size	̥
	screen_start	̥ХåեΡƬݥ
	SCREEN_W	̥ХåեΡԥ (320/640/1280)
	SCREEN_H	              ĥԥ (200/400/800)

	DEPTH		 (ХåեΥӥå8/16/32)

	status_buf	ơХåեΡƬݥ
	status_start[3]	ơ 02 ΥХåեΡƬݥ
	status_sx[3]				      ԥ
	status_sy[3]				      ĥԥ


	 ɥɽξ硢
		WIDTH * (HEIGHT + STATUS_HEIGHT) Υǡ
		ɥޤ
			(ơɽʤ顢 WIDTH * HEIGHT)

	 ɽξ硢
		SCREEN_SX * (SCREEN_SY + STATUS_HEIGHT) ʾΥ
		̲ޤ
			(ơɽʤ顢ʬϹɤĤ֤)

   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/

/***********************************************************************
 * ̽νλ
 *	screen_init()	̤롣ư˸ƤФ롣
 *	screen_exit()	夫Ť롣λ˸ƤФ롣
 ************************************************************************/
int	screen_init(void);
void	screen_exit(void);


/***********************************************************************
 * ⡼ڤؤΡƼ
 *	ꥢ褹ɬפΤǡν򤹤롣
 * 	grab_mouse  hide_mouse ʤɤ˴Ťޥ򤹤롣
 *	ԡȤ䡢ơꤹ롣
 ************************************************************************/
void	screen_switch(void);


/***********************************************************************
 *
 ************************************************************************/
void	screen_attr_mouse_move(void);
void	screen_attr_mouse_click(void);
int	screen_attr_mouse_debug(void);


/***********************************************************************
 * PC-8801κǽŪʿ
 ************************************************************************/
void	screen_get_emu_palette(PC88_PALETTE_T pal[16]);
void	screen_get_menu_palette(PC88_PALETTE_T pal[16]);


/***********************************************************************
 * 
 ************************************************************************/
void	screen_update(void);		/*    (1/60sec)  */
void	screen_update_immidiate(void);	/* ¨ (˥) */


/***********************************************************************
 * ե졼ॹå
 ************************************************************************/
void	frameskip_blink_reset(void);	/* ǽ ƽ		*/
void	frameskip_counter_reset(void);	/* ե졼ॹå ƽ	*/
void	frameskip_check(int on_time);	/* ե졼ॹå Ƚ	*/

int	quasi88_cfg_now_frameskip_rate(void);
void	quasi88_cfg_set_frameskip_rate(int rate);



/***********************************************************************
 * HALFο䴰̵ͭϢδؿ
 ***********************************************************************/
int	quasi88_cfg_can_interp(void);
int	quasi88_cfg_now_interp(void);
void	quasi88_cfg_set_interp(int enable);

/***********************************************************************
 * INTERLACEϢδؿ
 ***********************************************************************/
int	quasi88_cfg_now_interlace(void);
void	quasi88_cfg_set_interlace(int interlace_mode);

/***********************************************************************
 * ơɽϢδؿ
 ***********************************************************************/
int	quasi88_cfg_can_showstatus(void);
int	quasi88_cfg_now_showstatus(void);
void	quasi88_cfg_set_showstatus(int show);

/***********************************************************************
 * ꡦ̥Ϣδؿ
 ***********************************************************************/
int	quasi88_cfg_can_fullscreen(void);
int	quasi88_cfg_now_fullscreen(void);
void	quasi88_cfg_set_fullscreen(int fullscreen);
int	quasi88_cfg_max_size(void);
int	quasi88_cfg_min_size(void);
int	quasi88_cfg_now_size(void);
void	quasi88_cfg_set_size(int new_size);
void	quasi88_cfg_set_size_large(void);
void	quasi88_cfg_set_size_small(void);

/***********************************************************************
 * ???
 ***********************************************************************/
int	quasi88_info_draw_count(void);

#endif	/* SCREEN_H_INCLUDED */
