/************************************************************************/
/*									*/
/* ̤ɽ								*/
/*									*/
/************************************************************************/

#include <string.h>

#include "quasi88.h"
#include "initval.h"
#include "screen.h"
#include "screen-func.h"
#include "graph.h"

#include "crtcdmac.h"
#include "pc88main.h"

#include "status.h"
#include "suspend.h"

#include "intr.h"
#include "q8tk.h"

#include "pause.h"			/* pause_event_focus_in_when_pause() */



PC88_PALETTE_T	vram_bg_palette;	/* OUT[52/54-5B]		*/
PC88_PALETTE_T	vram_palette[8];	/*		Ƽѥå	*/

byte	sys_ctrl;			/* OUT[30] SystemCtrl		*/
byte	grph_ctrl;			/* OUT[31] GraphCtrl		*/
byte	grph_pile;			/* OUT[53] Ť͹碌		*/



char	screen_dirty_flag[ 0x4000*2 ];		/* ᥤΰ ʬ	*/
int	screen_dirty_all = TRUE;		/* ᥤΰ 蹹	*/
int	screen_dirty_palette = TRUE;		/*  		*/
int	screen_dirty_status = FALSE;		/* ơΰ 	*/
int	screen_dirty_status_hide = FALSE;	/* ơΰ õ	*/
int	screen_dirty_status_show = FALSE;	/* ơΰ */
int	screen_dirty_frame = TRUE;		/* ΰ  		*/



int	frameskip_rate	= DEFAULT_FRAMESKIP;	/* ɽιֳ	*/
int	monitor_analog	= TRUE;			/* ʥ˥     */
int	use_auto_skip	= TRUE;			/* ưե졼ॹå	*/


static	int	do_skip_draw = FALSE;		/* 󥹥åפ뤫?	*/
static	int	already_skip_draw = FALSE;	/* 󥹥åפ?	*/

static	int	skip_counter = 0;	/* Ϣ³󥹥åפ	*/
static	int	skip_count_max = 15;	/* ʾϢ³åפ
						öŪ褹	*/

static	int	frame_counter = 0;	/* ե졼ॹåѤΥ	*/



static	int	blink_ctrl_cycle   = 1;	/* ɽѤΥ	*/
static	int	blink_ctrl_counter = 0;	/*              		*/





/*CFG*/	int	hide_mouse = FALSE;	/* ޥ򱣤ɤ		*/
/*CFG*/	int	grab_mouse = FALSE;	/* ֤뤫ɤ		*/

/*CFG*/	int	use_swcursor = FALSE;	/* ˥塼ѥɽ̵ͭ	*/
	int	now_swcursor;		/* ѥɽ?	*/




/*CFG*/	int	use_interlace = 0;		/* 󥿡졼ɽ	*/

static	int	enable_half_interp = FALSE;	/* HALFֲǽݤ */
/*CFG*/	int	use_half_interp = TRUE;		/* HALF֤	    */
static	int	now_half_interp = FALSE;	/* ߡ䴰ʤ鿿	    */



typedef	struct{				/* ̥Υꥹ		*/
    int		w,  h;
} SCREEN_SIZE_TABLE;

static const SCREEN_SIZE_TABLE screen_size_tbl[ SCREEN_SIZE_END ] =
{
    /*  w     h   */
    {  320,  200, },		/* SCREEN_SIZE_HALF	320x200	*/
    {  640,  400, },		/* SCREEN_SIZE_FULL	640x400	*/
#ifdef	SUPPORT_DOUBLE
    { 1280,  800, },		/* SCREEN_SIZE_DOUBLE	1280x800*/
#endif
};


static	int	screen_size_max = SCREEN_SIZE_END - 1; /*ѹǽʺ祵*/
static	int	screen_size_min = SCREEN_SIZE_HALF;    /*ѹǽʺǾ*/
/*CFG*/	int	screen_size	= SCREEN_SIZE_FULL;    /*̥      */
static	int	now_screen_size;		       /*ºݤΡ̥  */


static	int	enable_fullscreen = 0;	/* ɽǽɤ	*/
/*CFG*/	int	use_fullscreen = FALSE;	/* ɽ		*/
static	int	now_fullscreen = FALSE;	/* ߡɽʤ鿿	*/


/*CFG*/	double	mon_aspect = 0.0;	/* ˥Υڥ	*/


int	WIDTH  = 0;			/* Хåե		*/
int	HEIGHT = 0;			/* Хåեĥ		*/
int	DEPTH  = 8;			/* ӥåȿ	(8 or 16 or 32)	*/
int	SCREEN_W = 0;			/* ̲ (320/640/1280)	*/
int	SCREEN_H = 0;			/* ̽ĥ (200/400/800)	*/

int	SCREEN_DX = 0;			/* ɥȡ		*/
int	SCREEN_DY = 0;			/* ̥ꥢȤΥեå	*/

char	*screen_buf;			/* ХåեƬ		*/
char	*screen_start;			/* Ƭ			*/

static	int	screen_bx;		/* ܡ() x (ɥå)	*/
static	int	screen_by;		/*	   	    y (ɥå)	*/



/*CFG*/	int	status_fg = 0x000000;	/* ơʿ		*/
/*CFG*/	int	status_bg = 0xd6d6d6;	/* ơطʿ		*/

static	int	enable_status = TRUE;	/* ơɽǽɤ	*/
/*CFG*/	int	show_status = TRUE;	/* ơɽ̵ͭ		*/
static	int	now_status = FALSE;	/* ߡơɽʤ鿿	*/

char	*status_buf;			/* ơ Ƭ		*/
char	*status_start[3];		/* ơ Ƭ		*/
int	status_sx[3];			/* ơ襵		*/
int	status_sy[3];


Ulong	color_pixel[16];			/* 		*/
Ulong	color_half_pixel[16][16];		/* 䴰ο	*/
Ulong	black_pixel;				/* ο		*/
Ulong	status_pixel[ STATUS_COLOR_END ];	/* ơο	*/



static	int	screen_write_only;	/* ̥ХåեɽԲĤʤ顢	*/

static	void	(*draw_start)(void);	/* ΥХåؿ	*/
static	void	(*draw_finish)(void);	/* ΥХåؿ	*/
static	int	dont_frameskip;		/* ե졼ॹå׶ػߤʤ顢	*/



static	int	drawn_count;		/* fps׻Ѥ	*/

static	int	broken_mouse;		/* ƥΥޥɽ۾	*/
static	int	auto_mouse;		/* ǡޥưǱ⡼   */
static	int	auto_mouse_timer;	/* ưǱޤǤλĤ֥ޡ */
static	int	auto_grab;		/* ǡޥư֥⡼     */


enum {
    SETUP_START,
    SETUP_MOVE,
    SETUP_TIMEUP,
    SETUP_CLICK
};
static	void	screen_attr_setup(int stat);

static	void	check_half_interp(void);
static	void	trans_palette(PC88_PALETTE_T syspal[]);
static	void	set_vram2screen_list(void);
static	void	clear_all_screen(void);
static	void	put_image_all(void);

/***********************************************************************
 * ̽νλ
 ************************************************************************/
static	const T_GRAPH_SPEC *spec;

static	int	open_window(void);
static	void	open_window_or_exit(void);

int	screen_init(void)
{
    int i;
    int w, h, max, min;

    status_init();			/* ơɽΥ	*/

    spec = graph_init();
    if (spec == NULL) {
	return FALSE;
    }


    /* spec ˤäơɥκ硦Ǿ */

    min = -1;
    for (i = 0; i < SCREEN_SIZE_END; i++) {
	if (i == SCREEN_SIZE_HALF && spec->forbid_half) { continue; }

	if (spec->window_max_width  >= screen_size_tbl[ i ].w &&
	    spec->window_max_height >= screen_size_tbl[ i ].h) {
	    min = i;
	    break;
	}
    }
    max = -1;
    for (i = SCREEN_SIZE_END - 1; i >= 0; i--) {
	if (spec->window_max_width  >= screen_size_tbl[ i ].w &&
	    spec->window_max_height >= screen_size_tbl[ i ].h) {
	    max = i;
	    break;
	}
    }
    if (min < 0 || max < 0 || max < min) {
	if (verbose_proc) printf("  Not found drawable window size (bug?)\n");
	return FALSE;
    }
    screen_size_max = max;
    screen_size_min = min;


    /* spec ˤäơ̲ǽɤ */

    if (spec->forbid_half) { i = SCREEN_SIZE_FULL; }
    else                   { i = SCREEN_SIZE_HALF; }

    if (spec->fullscreen_max_width  >= screen_size_tbl[ i ].w &&
	spec->fullscreen_max_height >= screen_size_tbl[ i ].h) {
	enable_fullscreen = TRUE;
    } else {
	enable_fullscreen = FALSE;
    }



    /* screen_size, WIDTH, HEIGHT ˥ޥɥ饤ǻꤷɥ
       åȺѤߤʤΤǡȤ˥ܡ()Υ򻻽Ф */

    w = screen_size_tbl[ screen_size ].w;
    h = screen_size_tbl[ screen_size ].h;

    screen_bx = ((MAX(WIDTH,  w) - w) / 2) & ~7;	/* 8ܿ */
    screen_by = ((MAX(HEIGHT, h) - h) / 2);

    if (open_window()) {
	clear_all_screen();
	put_image_all();
	return TRUE;
    } else {
	return FALSE;
    }
}


void	screen_exit(void)
{
    graph_exit();
}



/*----------------------------------------------------------------------
 * ɥ
 *----------------------------------------------------------------------*/
static int added_color;
static unsigned long added_pixel[120+16];

#define	SET_N_COLOR(n, rgb)					\
		color[ n ].red   = ((rgb) >> 16) & 0xff;	\
		color[ n ].green = ((rgb) >>  8) & 0xff;	\
		color[ n ].blue  = ((rgb)      ) & 0xff;	\

/*
  ʲѿ˴Ť̤ʲѿ򥻥åȤ
	use_fullscreen, enable_fullscreen		 now_fullscreen
	screen_size   , screen_size_max, screen_size_min
	show_status					 now_status
	screen_bx     , screen_by
 */

static	int	open_window(void)
{
    int i, size, found = FALSE;
    int w = 0, h = 0, status_displayable = FALSE;
    const T_GRAPH_INFO *info;


    added_color = 0;

    if (enable_fullscreen == FALSE) {	/* ԲĤʤ顢̻ؼϵѲ */
	use_fullscreen = FALSE;
    }


    /* ե륹꡼ɽǽʥ礭ۤõФ */

    if (use_fullscreen) {
	for (size = screen_size; size >= screen_size_min; size--) {

	    for (i = 0; i < 3; i++) {	/* 3ѥΥˤƳǧ */

		w = screen_size_tbl[ size ].w;
		h = screen_size_tbl[ size ].h;

		switch (i) {
		case 0:		/* ꥵ (ơԲĤ) */
		    if (screen_bx == 0 && screen_by == 0) { continue; }
		    w += screen_bx * 2;
		    h += screen_by * 2;
		    status_displayable = FALSE;
		    break;

		case 1:		/* Ŭ + ơ */
		    if (spec->forbid_status) { continue; }
		    w += (0) * 2;
		    h += STATUS_HEIGHT * 2;
		    status_displayable = TRUE;
		    break;

		case 2:		/* Ŭ (ơԲ) */
		    status_displayable = FALSE;
		    break;
		}

		if (w <= spec->fullscreen_max_width &&
		    h <= spec->fullscreen_max_height) {
		    found = TRUE;
		    break;
		}
	    }
	    if (found) break;
	}

	if (found == FALSE) {		/* ɽǽ̵ʤԲ */
	    use_fullscreen = FALSE;
	}
    }


    /* ɥɽɽʲǽ礭ۤõФ */

    if (use_fullscreen == FALSE) {
	for (size = screen_size; size >= screen_size_min; size--) {

	    for (i = 0; i < 4; i++) {	/* 4ѥΥˤƳǧ */

		w = screen_size_tbl[ size ].w;
		h = screen_size_tbl[ size ].h;

		switch (i) {
		case 0:		/* ꥵ + ơ */
		    if (screen_bx == 0 && screen_by == 0) { continue; }
		    w += screen_bx * 2;
		    h += screen_by * 2 + STATUS_HEIGHT;
		    status_displayable = TRUE;
		    break;

		case 1:		/* ꥵ (ơԲ) */
		    if (screen_bx == 0 && screen_by == 0) { continue; }
		    w += screen_bx * 2;
		    h += screen_by * 2;
		    status_displayable = FALSE;
		    break;

		case 2:		/* Ŭ + ơ */
		    w += 0;
		    h += STATUS_HEIGHT;
		    status_displayable = TRUE;
		    break;

		case 3:		/* Ŭ (ơԲ) */
		    status_displayable = FALSE;
		    break;
		}

		if (w <= spec->window_max_width &&
		    h <= spec->window_max_height) {
		    found = TRUE;
		    break;
		}
	    }
	    if (found) break;
	}

	/* ơɽǽʥĤäǤ⡢
	   ơɽʤʤСʬΥ򸺤餷Ƥ */
	if (status_displayable) {
	    if (spec->forbid_status || show_status == FALSE) {
		h -= STATUS_HEIGHT;
	    }
	}
    }


    /* ޤäΤǡ褤̤ */

    if (found == FALSE) {	/* ϤꤨʤϥǰΤ */
	size = screen_size_min;
	w = screen_size_tbl[ size ].w;
	h = screen_size_tbl[ size ].h;
	status_displayable = FALSE;
    }
    now_screen_size = size;

    info = graph_setup(w, h, use_fullscreen, (float)mon_aspect);

    if (info) {

	/* ե륹꡼ǡơɽǽʥݤǤǧ */
	if ((info->fullscreen) &&
	    (info->height >= screen_size_tbl[ size ].h + STATUS_HEIGHT * 2)) {
	    status_displayable = TRUE;
	}

	/* ˥ơɽǽɤ򡢺ǽȽ */
	if (status_displayable && (spec->forbid_status == FALSE)) {
	    enable_status = TRUE;
	    /* show_status ϸͤΤޤ */
	} else {
	    enable_status = FALSE;
	    show_status   = FALSE;
	}

	/* ν׻ */
	WIDTH      = info->byte_per_line / info->byte_per_pixel;
	if (info->fullscreen) {
	    HEIGHT = info->height;
	} else {
	    HEIGHT = info->height - ((show_status) ? STATUS_HEIGHT : 0);
	}

	SCREEN_W  = screen_size_tbl[ size ].w;
	SCREEN_H  = screen_size_tbl[ size ].h;
	SCREEN_DX = (info->width  - SCREEN_W) / 2;
	SCREEN_DY = (HEIGHT       - SCREEN_H) / 2;

	if (info->fullscreen) {
	    if (enable_status) {
		HEIGHT -= STATUS_HEIGHT;
	    }
	    now_fullscreen = TRUE;
	} else {
	    now_fullscreen = FALSE;
	}

	DEPTH     = info->byte_per_pixel * 8;


	/* Ȥ뿧οå */
	if        (info->nr_color >= 144) {	/* äѤȤ */
	    enable_half_interp = TRUE;

	} else if (info->nr_color >= 24) {	/* Ⱦʬ⡼ɤο֤Ϥ */
	    enable_half_interp = FALSE;

	} else if (info->nr_color >= 16) {	/* ơɽޤޤʤ*/
	    enable_half_interp = FALSE;

	} else {				/* 󤼤󿧤­ʤ */
	    return FALSE;
	}

	/* HALFο䴰̵ͭ */
	check_half_interp();


	/* ꡼ХåեΡ賫ϰ֤ */
	screen_buf = (char *)info->buffer;
	screen_start = &screen_buf[ (WIDTH*SCREEN_DY + SCREEN_DX)
						* info->byte_per_pixel ];

	/* ơѤΥХåեʤɤ򻻽 */
	status_sx[0] = info->width / 5;
	status_sx[1] = info->width - status_sx[0]*2;
	status_sx[2] = info->width / 5;

	status_sy[0] = 
	status_sy[1] = 
	status_sy[2] = STATUS_HEIGHT - 2;

	status_buf = &screen_buf[ WIDTH * HEIGHT * info->byte_per_pixel ];

	/* ơ賫ϰ֤ϡХåե 2饤 */
	status_start[0]= status_buf + 2*(WIDTH * info->byte_per_pixel);
	status_start[1]= status_start[0] + (status_sx[0]*info->byte_per_pixel);
	status_start[2]= status_start[1] + (status_sx[1]*info->byte_per_pixel);


	/* ơѤοԥ */
	if (info->nr_color >= 24) {
	    PC88_PALETTE_T color[8];
	    unsigned long pixel[8];

	    SET_N_COLOR( STATUS_BG,    status_bg);
	    SET_N_COLOR( STATUS_FG,    status_fg);
	    SET_N_COLOR( STATUS_BLACK, 0x000000 );
	    SET_N_COLOR( STATUS_WHITE, 0xffffff );
	    SET_N_COLOR( STATUS_RED,   0xff0000 );
	    SET_N_COLOR( STATUS_GREEN, 0x00ff00 );
	    SET_N_COLOR( 6, 0x000000 );
	    SET_N_COLOR( 7, 0xffffff );

	    graph_add_color(color, 8, pixel);

	    status_pixel[STATUS_BG   ] = pixel[0];
	    status_pixel[STATUS_FG   ] = pixel[1];
	    status_pixel[STATUS_BLACK] = pixel[2];
	    status_pixel[STATUS_WHITE] = pixel[3];
	    status_pixel[STATUS_RED  ] = pixel[4];
	    status_pixel[STATUS_GREEN] = pixel[5];
	    black_pixel                = pixel[6];

	} else {
	    PC88_PALETTE_T syspal[16];
	    unsigned long black, white;

	    /* syspal[0][14] Ϲ syspal[15]  */
	    memset(&syspal[0],  0x00, sizeof(PC88_PALETTE_T) * 15);
	    memset(&syspal[15], 0xff, sizeof(PC88_PALETTE_T));

	    /* ơѤοݤǤʤΤǡȤꤢŬ˿ */
	    /* syspal[8] ϥƥȤι syspal[15] ϥƥȤ   */
	    trans_palette(syspal);

	    black = color_pixel[ 8];
	    white = color_pixel[15];

	    status_pixel[STATUS_BG   ] = black;
	    status_pixel[STATUS_FG   ] = white;
	    status_pixel[STATUS_BLACK] = black;
	    status_pixel[STATUS_WHITE] = white;
	    status_pixel[STATUS_RED  ] = white;
	    status_pixel[STATUS_GREEN] = white;

	    black_pixel                = black;
	}

	now_status = show_status;

	screen_write_only = info->write_only;

	draw_start  = info->draw_start;
	draw_finish = info->draw_finish;
	dont_frameskip = info->dont_frameskip;


	/* žɽؿΥꥹȤ */
	set_vram2screen_list();


	/* ƥΥޥɽ */
	broken_mouse = info->broken_mouse;

	screen_switch();

	/* ơ */
	status_setup(now_status);

	return TRUE;
    } else {
	return FALSE;
    }
}

/*
 * ɥκԤ exit
 */
static	void	open_window_or_exit(void)
{
    if (open_window() == FALSE) {
	fprintf(stderr,"Sorry : Graphic System Fatal Error !!!\n");

	quasi88_exit(1);
    }
}



/*----------------------------------------------------------------------
 * HALF̵֤ͭ
 *----------------------------------------------------------------------*/
static	void	check_half_interp(void)
{
    if (now_screen_size == SCREEN_SIZE_HALF &&	/*  HALF    */
	enable_half_interp  &&			/* ե륿󥰲ǽ	*/
	use_half_interp) {			/* 䴰Ƥʤ   */

	now_half_interp = TRUE;

    } else {
	now_half_interp = FALSE;
    }
}







/***********************************************************************
 * ⡼ڤؤΡƼ
 ************************************************************************/
void	screen_switch(void)
{
    char *title;

    /* ꥢν */

    screen_set_dirty_frame();		/* ΰ (==) */
    screen_set_dirty_palette();		/*  (==) */

    if (now_status) {			/* ơɽ */

	screen_set_dirty_status_show();		/* ơΰ  */

    } else {				/* ơɽ */

	if (now_fullscreen && enable_status) {	/* ̤ʤ */
	    screen_set_dirty_status_hide();	/* ơΰ õ */
	}					/* ɥʤʤ */

    }

    frameskip_counter_reset();		/*  */


    /* ޥԡȤ */

    screen_attr_setup(SETUP_START);


    /* ƥΥޥɽ۾ޤϥ˥塼ѥѤξ	*/

    if ((broken_mouse) ||
	(! quasi88_is_exec() && /*now_fullscreen &&*/ use_swcursor)) {
	now_swcursor = TRUE;
    } else {
	now_swcursor = FALSE;
    }


    /* ɥȥɽ */

    if      (quasi88_is_exec())    title = Q_TITLE " ver " Q_VERSION;
    else if (quasi88_is_menu())    title = Q_TITLE " ver " Q_VERSION;
    else if (quasi88_is_pause())   title = Q_TITLE " (PAUSE)";
    else if (quasi88_is_monitor()) title = Q_TITLE " (MONITOR)";
    else                           title = "";

    graph_set_window_title(title);


    /*
      SDL

      ե륹꡼ (Winˤȯ)
      ֥Хåեξ硢ޥɽʤ
      󥰥Хåեǥϡɥեξ硢
      ޥONˤִ֡ޥɽ٤֤˥ߤĤ롩

      
      ˥塼ܤʤΤǡեȥǤޤ
    */
}

/*-----------------------------------------------------------------------------
  ޥɽ֡ԡȤꤹ롣

			EMU		MENU/PAUSE
	ޥɽ	 ˤ	
			 ˤ	ʤ
	ԡ			

   EMU ˤ롢ޥɽ֤ϰʲΤ褦ˤʤ롣

	A  ֤ʤޥɽ
	B  ֤ʤޥɽʤ
	C  ֤	 ޥɽʤ

	D  ֤ʤޥɽϡưȽ

    ɥ
	            |ޥɽ|ޥɽʤ||ޥưɽ
	------------+--------------+----------------++--------------
	֤ʤ|       A      |        B       ||       D
	------------+--------------+----------------++--------------
	֤  |       C    |        C       ||       C

	 ֤롿ޥɽ ȹ礻̵
	   ɥüǥޥߤΤޤΩˤʤ

    ե륹꡼
	            |ޥɽ|ޥɽʤ||ޥưɽ
	------------+--------------+----------------++--------------
	֤ʤ|       A    |        C     ||       C
	------------+--------------+----------------++--------------
	֤  |       C    |        C       ||       C

	 ֤롿ޥɽ ȹ礻̵
	   üǥޥߤΤޤΩˤʤ
	 ֤ʤޥɽ ȹ礻ϡͭ
	   üǥޥߤΤWin+SDL ǥޥǥץ쥤ξ
	   ޥߤ٤Υǥץ쥤˰ư뤳Ȥ餷
	 ֤ʤޥɽʤ ȹ礻̵
	   üǥޥߤ뤬ޥɽʤΤǡ狼ˤ

-----------------------------------------------------------------------------*/

/*#define DEBUG_ALL_MOUSE_PATTERN*/  /* ǥХå(ޥȹ礻򸡾) */

#ifdef	DEBUG_ALL_MOUSE_PATTERN
int	screen_attr_mouse_debug(void) { return TRUE; }
#else
int	screen_attr_mouse_debug(void) { return FALSE; }
#endif


#define	AUTO_MOUSE_TIMEOUT	(2 * 60)

/* ޥưƤӽФ */
void	screen_attr_mouse_move(void)
{
    if (auto_mouse) {
	if (auto_mouse_timer == 0) {
	    screen_attr_setup(SETUP_MOVE);
	} else {
	    auto_mouse_timer = AUTO_MOUSE_TIMEOUT;
	}
    }
}

/* ޥΥå˸ƤӽФ */
void	screen_attr_mouse_click(void)
{
    if (auto_grab) {
	screen_attr_setup(SETUP_CLICK);
	auto_grab = FALSE;
    }
}

/* 1/60sec˸ƤӽФ */
static	void	screen_attr_update(void)
{
    if (auto_mouse) {
	if (auto_mouse_timer > 0) {
	    if (--auto_mouse_timer == 0) {
		screen_attr_setup(SETUP_TIMEUP);
	    }
	}
    }
}

/* ޥɽ֡ԡȤꤹ */
static	void	screen_attr_setup(int stat)
{
    int repeat;		/* ȥԡȤ̵ͭ	*/
    int mouse;		/* ޥɽ̵ͭ	*/
    int grab;		/* ̵֤ͭ		*/

    if (stat == SETUP_START) {
	auto_mouse = FALSE;
	auto_mouse_timer = 0;
	auto_grab  = FALSE;
    }


    if (quasi88_is_exec()) {

	repeat = FALSE;

#ifdef	DEBUG_ALL_MOUSE_PATTERN	/* ǥХå:ƤΥޥȹ礻򸡾 */
	if      (grab_mouse == UNGRAB_MOUSE){ grab = FALSE; }
	else if (grab_mouse == GRAB_MOUSE)  { grab = TRUE;  }
	else {
	    if      (stat == SETUP_START)   { grab = FALSE; auto_grab = TRUE; }
	    else if (stat == SETUP_CLICK)   { grab = TRUE;  auto_grab = FALSE;}
	    else {
		if (auto_grab)              { grab = FALSE; }
		else                        { grab = TRUE;  }
	    }
	}
	goto DEBUG;
#endif

	if (now_fullscreen) {	/* ɽξ -------- */

	    if (grab_mouse == UNGRAB_MOUSE &&
		hide_mouse == SHOW_MOUSE) {

		/* ֤ʤ && ޥ ξΤߡ̤ˤ */
		mouse = TRUE;
		grab  = FALSE;

	    } else {

		/* ֤orư || ޥʤorư ʤСʲǸ */
		mouse = FALSE;
		grab  = TRUE;

	    }

	} else {		/* ɥɽξ -------- */

	    if (grab_mouse == GRAB_MOUSE) {

		/* ֤ʤ顢ޥϾä */
		grab  = TRUE;
		mouse = FALSE;

	    } else {

		if (grab_mouse == AUTO_MOUSE &&
		    stat == SETUP_CLICK) {

		    /* ư֤ǡܥ󥯥åϡޥä */
		    grab  = TRUE;
		    mouse = FALSE;

		    /* ʲϥꥢ */
		    auto_mouse = FALSE;
		    auto_mouse_timer = 0;
		    auto_grab  = FALSE;

		} else {

		    /* ֤ʤʤ顢ޥ̵ͭˤ */
		    if (grab_mouse == AUTO_MOUSE) {
			auto_grab = TRUE;
		    }

		    grab  = FALSE;

DEBUG:
		    switch (hide_mouse) {
		    case AUTO_MOUSE:
			auto_mouse = TRUE;
			if (stat == SETUP_START ||
			    stat == SETUP_MOVE) {
			    auto_mouse_timer = AUTO_MOUSE_TIMEOUT;
			    mouse = TRUE;
			} else {
			    auto_mouse_timer = 0;
			    mouse = FALSE;
			}
			break;

		    case SHOW_MOUSE:
			mouse = TRUE;
			break;

		    case HIDE_MOUSE:
		    default:
			mouse = FALSE;
			break;
		    }
		}
	    }
	}

    } else {

	repeat = TRUE;
	mouse  = TRUE;
	grab   = FALSE;

	/* ̥⡼ɤǡեȥȤʤ顢ޥϾä */
	if (/*now_fullscreen &&*/ use_swcursor) mouse = FALSE;
    }

    graph_set_attribute(mouse, grab, repeat);
}






/***********************************************************************
 * HALFο䴰̵ͭϢδؿ
 ***********************************************************************/

/* 䴰βݤ֤ */
int	quasi88_cfg_can_interp(void) { return enable_half_interp; }

/* 䴰θ߾֤֤ */
int	quasi88_cfg_now_interp(void) { return use_half_interp; }

/* 䴰̵ͭꤹ */
void	quasi88_cfg_set_interp(int enable)
{
    use_half_interp = enable;
    check_half_interp();
    set_vram2screen_list();
    screen_set_dirty_all();		/* ᥤΰ (==) */
    frameskip_counter_reset();		/*  */
}



/***********************************************************************
 * INTERLACEϢδؿ
 ***********************************************************************/

/* ߤΥ󥿥졼֤֤ */
int	quasi88_cfg_now_interlace(void) { return use_interlace; }

/* 󥿥졼֤ꤹ */
void	quasi88_cfg_set_interlace(int interlace_mode)
{
    use_interlace = interlace_mode;
    set_vram2screen_list();
    screen_set_dirty_frame();		/* ΰ (==) */
    frameskip_counter_reset();		/*  */
}



/***********************************************************************
 * ơɽϢδؿ
 ***********************************************************************/

/* ơɽβݤ֤ */
int	quasi88_cfg_can_showstatus(void) { return enable_status; }

/* ơɽθ߾֤֤ */
int	quasi88_cfg_now_showstatus(void) { return now_status; }

/* ơɽꤹ */
void	quasi88_cfg_set_showstatus(int show)
{
    if (now_status != show) {		/* ơɽ̵ͭѤä */
	show_status = show;

	if (now_fullscreen == FALSE) {	/* ɥξ硦 */

	    open_window_or_exit();		/* ̥     */

	} else {			/* ̤ξ硦 */

	    now_status = show_status;

	    if (now_status) {
		screen_set_dirty_status_show();	/* ơΰ  */
		screen_set_dirty_status();	/* ơΰ  */
	    } else {
		screen_set_dirty_status_hide();	/* ơΰ õ */
	    }

	}

	status_setup(now_status);		/* ơѿ */
    }
}



/***********************************************************************
 * ꡦ̥Ϣδؿ
 ***********************************************************************/

/* ̤βݤ֤ */
int	quasi88_cfg_can_fullscreen(void) { return enable_fullscreen; }

/* ̤θ߾֤֤ */
int	quasi88_cfg_now_fullscreen(void) { return now_fullscreen; }

/* ̤ؤꤹ */
void	quasi88_cfg_set_fullscreen(int fullscreen)
{
    use_fullscreen = fullscreen;

    if (now_fullscreen != use_fullscreen) {
	open_window_or_exit();			/* ̥     */
    }
}

/* ̥κ֤ */
int	quasi88_cfg_max_size(void) { return screen_size_max; }

/* ̥κǾ֤ */
int	quasi88_cfg_min_size(void) { return screen_size_min; }

/* ̥θ߾֤֤ */
int	quasi88_cfg_now_size(void) { return now_screen_size; }

/* ̥ꤹ */
void	quasi88_cfg_set_size(int new_size)
{
    screen_size = new_size;

    if (now_screen_size != screen_size) {
	open_window_or_exit();			/* ̥     */
    }
}

/* ̥礭 */
void	quasi88_cfg_set_size_large(void)
{
    if (++screen_size > screen_size_max) screen_size = screen_size_min;

    open_window_or_exit();			/* ̥     */
}

/* ̥򾮤 */
void	quasi88_cfg_set_size_small(void)
{
    if (--screen_size < screen_size_min) screen_size = screen_size_max;

    open_window_or_exit();			/* ̥     */
}













/*----------------------------------------------------------------------
 * ѥå
 *----------------------------------------------------------------------*/
static	void	trans_palette(PC88_PALETTE_T syspal[])
{
    PC88_PALETTE_T color[120+16];
    int i, j, num;

    if (added_color) {
	graph_remove_color(added_color, added_pixel);
	added_color = 0;
    }

		/* 88Υѥå16ʬ */

    for (i = 0; i < 16; i++) {
	color[i].red   = syspal[i].red;
	color[i].green = syspal[i].green;
	color[i].blue  = syspal[i].blue;
    }
    num = 16;

	/* HALFե륿󥰲ǽϥե륿ѥåͤ׻ */
	/* (ե륿Ѥˤϡ120) */

    if (now_half_interp) {
	for (i = 0; i < 16; i++) {
	    for (j = i+1; j < 16; j++) {
	       color[num].red   = (color[i].red  >>1) + (color[j].red  >>1);
	       color[num].green = (color[i].green>>1) + (color[j].green>>1);
	       color[num].blue  = (color[i].blue >>1) + (color[j].blue >>1);
	       num++;
	    }
	}
    }

    graph_add_color(color, num, added_pixel);
    added_color = num;

    for (i = 0; i < 16; i++) {
	color_pixel[i] = added_pixel[i];
    }

    if (now_half_interp) {
	for (i = 0; i < 16; i++) {
	    color_half_pixel[i][i] = color_pixel[i];
	}
	num = 16;
	for (i = 0; i < 16; i++) {
	    for (j = i+1; j < 16; j++) {
		color_half_pixel[i][j] = added_pixel[num];
		color_half_pixel[j][i] = color_half_pixel[i][j];
		num++;
	    }
	}
    }
}


/*----------------------------------------------------------------------
 * GVRAM/TVRAMХåեžؿΡꥹȤ
 *	δؿϡ bpp    ե ѹ˸ƤӽФ
 *----------------------------------------------------------------------*/
static	int	(*vram2screen_list[4][4][2])(void);
static	void	(*screen_buf_init_p)(void);

static	int	(*menu2screen_p)(void);

static	void	(*status2screen_p)(int kind, byte pixmap[], int w, int h);
/*static	void	(*status_buf_init_p)(void);*/
static	void	(*status_buf_clear_p)(void);

static	void	set_vram2screen_list(void)
{
    typedef	int		(*V2S_FUNC_TYPE)(void);
    typedef	V2S_FUNC_TYPE	V2S_FUNC_LIST[4][4][2];
    V2S_FUNC_LIST *list = NULL;


    if (DEPTH <= 8) {		/* ----------------------------------------- */

#ifdef	SUPPORT_8BPP
	switch (now_screen_size) {
	case SCREEN_SIZE_FULL:
	    if      (use_interlace == 0) {
		if (screen_write_only)   { list = &vram2screen_list_F_N__8_d; }
		else                     { list = &vram2screen_list_F_N__8; }
	    }
	    else if (use_interlace >  0) { list = &vram2screen_list_F_I__8; }
	    else                         { list = &vram2screen_list_F_S__8; }
	    menu2screen_p = menu2screen_F_N__8;
	    break;
	case SCREEN_SIZE_HALF:
	    if (now_half_interp) { list = &vram2screen_list_H_P__8;
				menu2screen_p = menu2screen_H_P__8; }
	    else                 { list = &vram2screen_list_H_N__8;
				menu2screen_p = menu2screen_H_N__8; }
	    break;
#ifdef	SUPPORT_DOUBLE
	case SCREEN_SIZE_DOUBLE:
	    if (screen_write_only) {
		if      (use_interlace == 0) { list=&vram2screen_list_D_N__8_d; }
		else if (use_interlace >  0) { list=&vram2screen_list_D_I__8_d; }
		else                         { list=&vram2screen_list_D_S__8_d; }
	    } else {
		if      (use_interlace == 0) { list=&vram2screen_list_D_N__8; }
		else if (use_interlace >  0) { list=&vram2screen_list_D_I__8; }
		else                         { list=&vram2screen_list_D_S__8; }
	    }
	    menu2screen_p = menu2screen_D_N__8;
	    break;
#endif
	}
	screen_buf_init_p  = screen_buf_init__8;
	status2screen_p    = status2screen__8;
/*	status_buf_init_p  = status_buf_init__8;*/
	status_buf_clear_p = status_buf_clear__8;
#else
	fprintf(stderr, "Error! This version is not support %dbpp !\n", DEPTH);
	exit(1);
#endif

    } else if (DEPTH <= 16) {	/* ----------------------------------------- */

#ifdef	SUPPORT_16BPP
	switch (now_screen_size) {
	case SCREEN_SIZE_FULL:
	    if      (use_interlace == 0) {
		if (screen_write_only)   { list = &vram2screen_list_F_N_16_d; }
		else                     { list = &vram2screen_list_F_N_16; }
	    }
	    else if (use_interlace >  0) { list = &vram2screen_list_F_I_16; }
	    else                         { list = &vram2screen_list_F_S_16; }
	    menu2screen_p = menu2screen_F_N_16;
	    break;
	case SCREEN_SIZE_HALF:
	    if (now_half_interp) { list = &vram2screen_list_H_P_16;
				menu2screen_p = menu2screen_H_P_16; }
	    else                 { list = &vram2screen_list_H_N_16;
				menu2screen_p = menu2screen_H_N_16; }
	    break;
#ifdef	SUPPORT_DOUBLE
	case SCREEN_SIZE_DOUBLE:
	    if (screen_write_only) {
		if      (use_interlace == 0) { list=&vram2screen_list_D_N_16_d; }
		else if (use_interlace >  0) { list=&vram2screen_list_D_I_16_d; }
		else                         { list=&vram2screen_list_D_S_16_d; }
	    } else {
		if      (use_interlace == 0) { list=&vram2screen_list_D_N_16; }
		else if (use_interlace >  0) { list=&vram2screen_list_D_I_16; }
		else                         { list=&vram2screen_list_D_S_16; }
	    }
	    menu2screen_p = menu2screen_D_N_16;
	    break;
#endif
	}
	screen_buf_init_p  = screen_buf_init_16;
	status2screen_p    = status2screen_16;
/*	status_buf_init_p  = status_buf_init_16;*/
	status_buf_clear_p = status_buf_clear_16;
#else
	fprintf(stderr, "Error! This version is not support %dbpp !\n", DEPTH);
	exit(1);
#endif

    } else if (DEPTH <= 32) {	/* ----------------------------------------- */

#ifdef	SUPPORT_32BPP
	switch (now_screen_size) {
	case SCREEN_SIZE_FULL:
	    if      (use_interlace == 0) {
		if (screen_write_only)   { list = &vram2screen_list_F_N_32_d; }
		else                     { list = &vram2screen_list_F_N_32; }
	    }
	    else if (use_interlace >  0) { list = &vram2screen_list_F_I_32; }
	    else                         { list = &vram2screen_list_F_S_32; }
	    menu2screen_p = menu2screen_F_N_32;
	    break;
	case SCREEN_SIZE_HALF:
	    if (now_half_interp) { list = &vram2screen_list_H_P_32;
				menu2screen_p = menu2screen_H_P_32; }
	    else                 { list = &vram2screen_list_H_N_32;
				menu2screen_p = menu2screen_H_N_32; }
	    break;
#ifdef	SUPPORT_DOUBLE
	case SCREEN_SIZE_DOUBLE:
	    if (screen_write_only) {
		if      (use_interlace == 0) { list=&vram2screen_list_D_N_32_d; }
		else if (use_interlace >  0) { list=&vram2screen_list_D_I_32_d; }
		else                         { list=&vram2screen_list_D_S_32_d; }
	    } else {
		if      (use_interlace == 0) { list=&vram2screen_list_D_N_32; }
		else if (use_interlace >  0) { list=&vram2screen_list_D_I_32; }
		else                         { list=&vram2screen_list_D_S_32; }
	    }
	    menu2screen_p = menu2screen_D_N_32;
	    break;
#endif
	}
	screen_buf_init_p  = screen_buf_init_32;
	status2screen_p    = status2screen_32;
/*	status_buf_init_p  = status_buf_init_32;*/
	status_buf_clear_p = status_buf_clear_32;
#else
	fprintf(stderr, "Error! This version is not support %dbpp !\n", DEPTH);
	exit(1);
#endif

    }

    memcpy(vram2screen_list, list, sizeof(vram2screen_list));
}


static	void	clear_all_screen(void)
{
    if (draw_start) { (draw_start)(); }		/* ƥ¸ */

    (screen_buf_init_p)();			/* ꥢ(ܡ) */
    if (now_status) {
	(status_buf_clear_p)();			/* ơΰ õ */
    }

    if (draw_finish) { (draw_finish)(); }	/* ƥ¸ */
}



/*----------------------------------------------------------------------
 * GVRAM/TVRAM  screen_buf ž
 *
 *	int method == V_DIF  screen_dirty_flag ˴Ťʬž
 *		   == V_ALL  ̤٤Ƥž
 *
 *	     == -1     žʤ (̤Ѳʤ)
 *		   != -1     ̤ 8ӥåȤĤˡx0, y0, x1, y1 
 *			       4Ĥ unsigned ͤåȤ롣ǡ
 *				    (x0 * 8, y0 * 2) - (x1 * 8, y1 * 2)
 *			       ɽϰϤžΰȤʤ롣
 *
 *	ͽᡢ set_vram2screen_list ǴؿꥹȤƤ
 *----------------------------------------------------------------------*/
static	int	vram2screen(int method)
{
    int vram_mode, text_mode;

    if (sys_ctrl & SYS_CTRL_80) {		/* ƥȤιԡ */
	if (CRTC_SZ_LINES == 25) { text_mode = V_80x25; }
	else                     { text_mode = V_80x20; }
    } else {
	if (CRTC_SZ_LINES == 25) { text_mode = V_40x25; }
	else                     { text_mode = V_40x20; }
    }

    if (grph_ctrl & GRPH_CTRL_VDISP) {		/* VRAM ɽ */

	if (grph_ctrl & GRPH_CTRL_COLOR) {		/* 顼 */
	    vram_mode = V_COLOR;
	} else {
	    if (grph_ctrl & GRPH_CTRL_200) {		/*  */
		vram_mode = V_MONO;
	    } else {					/* 400饤 */
		vram_mode = V_HIRESO;
	    }
	}

    } else {					/* VRAM ɽʤ */

	vram_mode = V_UNDISP;
    }

#if 0
{ /*ߤɤΥ⡼ɤɽ? */
  static int vram_mode0=-1, text_mode0=-1;
  if (text_mode0 != text_mode) {
    if      (text_mode==V_80x25) printf("      80x25\n");
    else if (text_mode==V_80x20) printf("      80x20\n");
    else if (text_mode==V_40x25) printf("      40x25\n");
    else if (text_mode==V_40x20) printf("      40x20\n");
    text_mode0 = text_mode;
  }
  if (vram_mode0 != vram_mode) {
    if      (vram_mode==V_COLOR)  printf("COLOR\n");
    else if (vram_mode==V_MONO)   printf("mono \n");
    else if (vram_mode==V_HIRESO) printf("H=400\n");
    else if (vram_mode==V_UNDISP) printf("-----\n");
    vram_mode0 = vram_mode;
  }
}
#endif

    return (vram2screen_list[ vram_mode ][ text_mode ][ method ])();
}



/*----------------------------------------------------------------------
 * ɽ	ܡ()ΰ衢ᥤΰ衢ơΰƤɽ
 *----------------------------------------------------------------------*/
static	void	put_image_all(void)
{
    T_GRAPH_RECT rect[1];

    rect[0].x = 0;
    rect[0].y = 0;
    rect[0].width  = WIDTH;
    rect[0].height = HEIGHT + ((now_status || now_fullscreen) ? STATUS_HEIGHT
			       				      : 0);

    graph_update(1, &rect[0]);
}


/*----------------------------------------------------------------------
 * ɽ	ᥤΰ (x0,y0)-(x1,y1)  ꤵ줿ơΰɽ
 *----------------------------------------------------------------------*/
static	void	put_image(int x0, int y0, int x1, int y1,
			  int st0, int st1, int st2)
{
    int n = 0;
    T_GRAPH_RECT rect[4];

    if (x0 >= 0) {
	if        (now_screen_size == SCREEN_SIZE_FULL) {
	    ;
	} else if (now_screen_size == SCREEN_SIZE_HALF) {
	    x0 /= 2;  x1 /= 2;  y0 /= 2;  y1 /= 2;
	} else  /* now_screen_size == SCREEN_SIZE_DOUBLE */ {
	    x0 *= 2;  x1 *= 2;  y0 *= 2;  y1 *= 2;
	}

	rect[n].x = SCREEN_DX + x0;
	rect[n].y = SCREEN_DY + y0;
	rect[n].width  = x1 - x0;
	rect[n].height = y1 - y0;
	n ++;
    }

    if (now_status || now_fullscreen ){	/* ̻ϡơõ */
	if (st0) {
	    rect[n].x = 0;
	    rect[n].y = HEIGHT;
	    rect[n].width  = status_sx[0];
	    rect[n].height = STATUS_HEIGHT;
	    n ++;
	}
	if (st1) {
	    rect[n].x = status_sx[0];
	    rect[n].y = HEIGHT;
	    rect[n].width  = status_sx[1];
	    rect[n].height = STATUS_HEIGHT;
	    n ++;
	}
	if (st2) {
	    rect[n].x = status_sx[0] + status_sx[1];
	    rect[n].y = HEIGHT;
	    rect[n].width  = status_sx[2];
	    rect[n].height = STATUS_HEIGHT;
	    n ++;
	}
    }

    graph_update(n, &rect[0]);
}








/***********************************************************************
 * κݤ˻Ѥ롢ºݤΥѥåȾ syspal ˥åȤ
 ************************************************************************/
void	screen_get_emu_palette(PC88_PALETTE_T pal[16])
{
    int i;

	/* VRAM  顼ѥå   pal[0][7] */

    if (grph_ctrl & GRPH_CTRL_COLOR) {		/* VRAM 顼 */

	if (monitor_analog) {
	    for (i = 0; i < 8; i++) {
		pal[i].red   = vram_palette[i].red   * 73 / 2;
		pal[i].green = vram_palette[i].green * 73 / 2;
		pal[i].blue  = vram_palette[i].blue  * 73 / 2;
	    }
	} else {
	    for (i = 0; i < 8; i++) {
		pal[i].red   = vram_palette[i].red   ? 0xff : 0;
		pal[i].green = vram_palette[i].green ? 0xff : 0;
		pal[i].blue  = vram_palette[i].blue  ? 0xff : 0;
	    }
	}

    } else {					/* VRAM  */

	if (monitor_analog) {
	    pal[0].red   = vram_bg_palette.red   * 73 / 2;
	    pal[0].green = vram_bg_palette.green * 73 / 2;
	    pal[0].blue  = vram_bg_palette.blue  * 73 / 2;
	} else {
	    pal[0].red   = vram_bg_palette.red   ? 0xff : 0;
	    pal[0].green = vram_bg_palette.green ? 0xff : 0;
	    pal[0].blue  = vram_bg_palette.blue  ? 0xff : 0;
	}
	for (i = 1; i < 8; i++) {
	    pal[i].red   = 0;
	    pal[i].green = 0;
	    pal[i].blue  = 0;
	}

    }


	/* TEXT  顼ѥå   pal[8][15] */

    if (grph_ctrl & GRPH_CTRL_COLOR) {		/* VRAM 顼 */

	for (i = 8; i < 16; i++) {			/* TEXT ξ */
	    pal[i].red   = (i & 0x02) ? 0xff : 0;	/* =[8],=[15]  */
	    pal[i].green = (i & 0x04) ? 0xff : 0;	/* ȤΤʤ  */
	    pal[i].blue  = (i & 0x01) ? 0xff : 0;
	}

    } else {					/* VRAM    */

	if (misc_ctrl & MISC_CTRL_ANALOG) {		/* ʥѥåȻ*/

	    if (monitor_analog) {
		for (i = 8; i < 16; i++) {
		    pal[i].red   = vram_palette[i & 0x7].red   * 73 / 2;
		    pal[i].green = vram_palette[i & 0x7].green * 73 / 2;
		    pal[i].blue  = vram_palette[i & 0x7].blue  * 73 / 2;
		}
	    } else {
		for (i = 8; i < 16; i++) {
		    pal[i].red   = vram_palette[i & 0x7].red   ? 0xff : 0;
		    pal[i].green = vram_palette[i & 0x7].green ? 0xff : 0;
		    pal[i].blue  = vram_palette[i & 0x7].blue  ? 0xff : 0;
		}
	    }

	} else {					/* ǥѥåȻ*/
	    for (i = 8; i < 16; i++) {
		pal[i].red   = (i & 0x02) ? 0xff : 0;
		pal[i].green = (i & 0x04) ? 0xff : 0;
		pal[i].blue  = (i & 0x01) ? 0xff : 0;
	    }
	}

    }
}



/***********************************************************************
 * ᡼ž (ɽ)
 *
 *	δؿϡɽߥ ( 1/60) ˸ƤӽФ롣
 ************************************************************************/
void	screen_update(void)
{
    int i;
    int skip = FALSE;
    int all_area  = FALSE;	/* ꥢžե饰	*/
    int rect = -1;		/* žե饰	*/
    int flag = 0;		/* ơžե饰	*/
    PC88_PALETTE_T syspal[16];
    int is_exec = (quasi88_is_exec()) ? TRUE : FALSE;


    screen_attr_update();	/* ޥưǱĸƤӽФ꤬ޤ */


    if (is_exec) {
	profiler_lapse( PROF_LAPSE_BLIT );
    }

    status_update();		/* ơΰβǡ򹹿 */


    /* ᥤΰϡ򥹥åפ礬ΤǡʲȽ */
    /* (˥塼ʤɤϡ frame_counter==0 ʤΤǡ)   */

    if ((frame_counter % frameskip_rate) == 0) { /* λ褿       */
						 /* ʲΤ줫ʤ */
	if (no_wait ||				   /* Ȥʤ     */
	    use_auto_skip == FALSE || 		   /* ưåפʤ */
	    do_skip_draw  == FALSE) {		   /* 󥹥åоݤǤʤ */

	    skip = FALSE;

	} else {				 /* ʳϥå */

	    skip = TRUE;

	    /* 西ߥ󥰤ʤΤ˥åפϡΤȤФƤ */
	    already_skip_draw = TRUE;
	}

	/* ǤΥ */
	if (is_exec) {
	    if (--blink_ctrl_counter == 0) {
		blink_ctrl_counter = blink_ctrl_cycle;
		blink_counter ++;
	    }
	}
    } else {
	skip = TRUE;
    }


    /* ᥤΰ褹 (åפʤ) ν */

    if (skip == FALSE) {

	/* ž */

	if (screen_dirty_palette) {		/* 򥷥ƥž */
	    if (quasi88_is_menu()) {
		screen_get_menu_palette(syspal);
	    } else {
		screen_get_emu_palette(syspal);
	    }
	    trans_palette(syspal);
	}

	/* ɬפ˱ơե饰򥻥å */

	if (screen_dirty_frame) {
	    screen_set_dirty_all();
	    screen_set_dirty_status();
	    all_area = TRUE;
	}

	if (screen_dirty_palette) {
	    screen_set_dirty_all();
	    screen_dirty_palette = FALSE; 
	}

	/* ե饰˱ơ */

	if (draw_start) { (draw_start)(); }	/* ƥ¸ */

	if (screen_dirty_frame) {
	    (screen_buf_init_p)();		/* ꥢ(ܡ) */
	    screen_dirty_frame = FALSE;
	    /* ܡϹꡣѹĤȤʤ顢˿žɬס */
	}

	/* VRAMž */

	if (quasi88_is_menu()) {

	    if (screen_dirty_all ||
		screen_dirty_flag[0]) {

		if (screen_dirty_all) {
		    /* ΢̤򥯥ꥢǺʬˤʤ */
		    memset(&menu_screen[menu_screen_current^1],
			   0,
			   sizeof(menu_screen[0]));
		}

		rect = (menu2screen_p)();

		/* ɽ̤΢̤פƤʤȤʤ */
		memcpy(&menu_screen[menu_screen_current^1],
		       &menu_screen[menu_screen_current],
		       sizeof(menu_screen[0]));

		menu_screen_current ^= 1;
		screen_dirty_flag[0] = 0;
		screen_dirty_all = FALSE;
	    }

	} else {

	    /* VRAMե饰 screen_dirty_flag 㳰		     */
	    /*		VRAMɽξ硢ե饰ϰ̵̣Τǥꥢ */
	    /*		400饤ξ硢ե饰̲Ⱦʬˤĥ  */

	    if (screen_dirty_all == FALSE) {
		if (! (grph_ctrl & GRPH_CTRL_VDISP)) {
		    /* ɽ */
		    memset(screen_dirty_flag, 0, sizeof(screen_dirty_flag) / 2);
		}
		if (! (grph_ctrl & (GRPH_CTRL_COLOR|GRPH_CTRL_200))) {
		    /* 400饤 */
		    memcpy(&screen_dirty_flag[80*200], screen_dirty_flag, 80*200);
		}
	    }

	    crtc_make_text_attr();	/* TVRAM  °	  */
					/* VRAM/TEXT  screen_buf ž	  */
	    rect = vram2screen(screen_dirty_all ? V_ALL : V_DIF);

	    text_attr_flipflop ^= 1;
	    memset(screen_dirty_flag, 0, sizeof(screen_dirty_flag));
	    screen_dirty_all = FALSE;
	}

	if (draw_finish) { (draw_finish)(); }	/* ƥ¸ */
    }


    /* ơꥢν (ơϡɽ¤ꥹåפʤ) */

    if (draw_start) { (draw_start)(); }		/* ƥ¸ */

    if (screen_dirty_status_hide) {
	(status_buf_clear_p)();			/* ơΰ õ */
	screen_dirty_status_hide = FALSE;
	all_area = TRUE;
    }

    if (screen_dirty_status_show) {
	(status_buf_clear_p)();			/* ơΰ  */
	screen_dirty_status_show = FALSE;
	all_area = TRUE;
    }

    if (now_status) {
	if (screen_dirty_status) {
	    flag = screen_dirty_status;
	    for (i = 0; i < 3; i++) {
		if (flag & (1 << i)) {
		    (status2screen_p)(i, status_info[i].pixmap,
				      status_info[i].w, status_info[i].h);
		}
	    }
	    screen_dirty_status = 0;
	}
    }

    if (draw_finish) { (draw_finish)(); }	/* ƥ¸ */

    if (is_exec) {
	profiler_video_output(((frame_counter % frameskip_rate) == 0),
			      skip, (all_area || rect != -1));
    }


    if ((is_exec) && (dont_frameskip == FALSE)) {
	++ frame_counter;
    } else {	/* menu,pause,monitor */
	frame_counter = 0;
    }

    if (is_exec) {
	profiler_lapse( PROF_LAPSE_VIDEO );
    }

    if (all_area) {

	put_image_all();
	drawn_count ++;

    } else {
	if (rect != -1) {
	    put_image(((rect >> 24)       ) * 8, ((rect >> 16) & 0xff) * 2,
		      ((rect >>  8) & 0xff) * 8, ((rect      ) & 0xff) * 2,
		      (flag & 1), (flag & 2), (flag & 4));
	    drawn_count ++;
	}
	else if (flag) {
	    put_image(-1, -1, -1, -1,
		      (flag & 1), (flag & 2), (flag & 4));
	}
    }
}

void	screen_update_immidiate(void)
{
    screen_set_dirty_frame();		/* ΰ  */
    frameskip_counter_reset();		/*  */

    screen_update();			/*  */
}

int	quasi88_info_draw_count(void)
{
    return drawn_count;
}













/***********************************************************************
 * ƥ।٥Ƚ EXPOSE / FOCUS-IN / FOCUS-OUT
 ***********************************************************************/

/*======================================================================
 *
 *======================================================================*/
void	quasi88_expose(void)
{
    screen_set_dirty_frame();		/* ΰ  */

    frameskip_counter_reset();		/*  */
}


/*======================================================================
 *
 *======================================================================*/
void	quasi88_focus_in(void)
{
    if (quasi88_is_pause()) {

	pause_event_focus_in_when_pause();

    }
}

void	quasi88_focus_out(void)
{
    if (quasi88_is_exec()) {

	pause_event_focus_out_when_exec();

    }
}













/***********************************************************************
 * ƥ (뤪ӡʸ°) Υ
 *	CRTC  frameskip_rate, blink_cycle ѹ뤿Ӥ˸ƤӽФ
 ************************************************************************/
void	frameskip_blink_reset(void)
{
    int wk;

    wk = blink_cycle / frameskip_rate;

    if (wk == 0 ||
	! (blink_cycle-wk*frameskip_rate < (wk+1)*frameskip_rate-blink_cycle))
	wk++;
  
    blink_ctrl_cycle = wk;
    blink_ctrl_counter = blink_ctrl_cycle;
}



/***********************************************************************
 * ե졼५󥿽
 *	ե졼ϡɬɽ롣(åפʤ)
 ************************************************************************/
void	frameskip_counter_reset(void)
{
    frame_counter = 0;
    do_skip_draw = FALSE;
    already_skip_draw = FALSE;
}



/***********************************************************************
 * ưե졼ॹå׽		( by floi, thanks ! )
 ************************************************************************/
void	frameskip_check(int on_time)
{
    if (use_auto_skip) {

	if (on_time) {			/* ˽Ǥ */

	    skip_counter = 0;
	    do_skip_draw = FALSE;	    /* Ȥ */

	    if (already_skip_draw) {	    /* åפƤ */
		frameskip_counter_reset();	/* VSYNCǶ */
	    }

	} else {			/* ˽ǤƤʤ */

	    do_skip_draw = TRUE;	    /* 襹å */

	    skip_counter++;		    /* âåפʤ */
	    if (skip_counter >= skip_count_max) {
		frameskip_counter_reset();	/* VSYNCǶ */
	    }
	}
    }
}



/***********************************************************************
 * ե졼ॹåץ졼Ȥμ
 ************************************************************************/
int	quasi88_cfg_now_frameskip_rate(void)
{
    return frameskip_rate;
}
void	quasi88_cfg_set_frameskip_rate(int rate)
{
    char str[32];

    if (rate <= 0) rate = 1;

    if (rate != frameskip_rate) {
	frameskip_rate = rate;

	frameskip_blink_reset();
	frameskip_counter_reset();

	sprintf(str, "FRAME RATE = %2d/sec", 60/rate);
	status_message(1, STATUS_INFO_TIME, str);
	/* ѹϡФ餯̤˥ե졼졼Ȥɽ */
    }
}





/***********************************************************************
 * ơȥɡơȥ
 ************************************************************************/

#define	SID	"SCRN"

static	T_SUSPEND_W	suspend_screen_work[]=
{
    { TYPE_CHAR,	&vram_bg_palette.blue,	},
    { TYPE_CHAR,	&vram_bg_palette.red,	},
    { TYPE_CHAR,	&vram_bg_palette.green,	},

    { TYPE_CHAR,	&vram_palette[0].blue,	},
    { TYPE_CHAR,	&vram_palette[0].red,	},
    { TYPE_CHAR,	&vram_palette[0].green,	},
    { TYPE_CHAR,	&vram_palette[1].blue,	},
    { TYPE_CHAR,	&vram_palette[1].red,	},
    { TYPE_CHAR,	&vram_palette[1].green,	},
    { TYPE_CHAR,	&vram_palette[2].blue,	},
    { TYPE_CHAR,	&vram_palette[2].red,	},
    { TYPE_CHAR,	&vram_palette[2].green,	},
    { TYPE_CHAR,	&vram_palette[3].blue,	},
    { TYPE_CHAR,	&vram_palette[3].red,	},
    { TYPE_CHAR,	&vram_palette[3].green,	},
    { TYPE_CHAR,	&vram_palette[4].blue,	},
    { TYPE_CHAR,	&vram_palette[4].red,	},
    { TYPE_CHAR,	&vram_palette[4].green,	},
    { TYPE_CHAR,	&vram_palette[5].blue,	},
    { TYPE_CHAR,	&vram_palette[5].red,	},
    { TYPE_CHAR,	&vram_palette[5].green,	},
    { TYPE_CHAR,	&vram_palette[6].blue,	},
    { TYPE_CHAR,	&vram_palette[6].red,	},
    { TYPE_CHAR,	&vram_palette[6].green,	},
    { TYPE_CHAR,	&vram_palette[7].blue,	},
    { TYPE_CHAR,	&vram_palette[7].red,	},
    { TYPE_CHAR,	&vram_palette[7].green,	},

    { TYPE_BYTE,	&sys_ctrl,		},
    { TYPE_BYTE,	&grph_ctrl,		},
    { TYPE_BYTE,	&grph_pile,		},

    { TYPE_INT,		&frameskip_rate,	},
    { TYPE_INT,		&monitor_analog,	},
    { TYPE_INT,		&use_auto_skip,		},
/*  { TYPE_INT,		&frame_counter,		}, ͤǤʤ */
/*  { TYPE_INT,		&blink_ctrl_cycle,	}, ͤǤʤ */
/*  { TYPE_INT,		&blink_ctrl_counter,	}, ͤǤʤ */

    { TYPE_INT,		&use_interlace,		},
    { TYPE_INT,		&use_half_interp,	},

    { TYPE_END,		0			},
};


int	statesave_screen(void)
{
    if (statesave_table(SID, suspend_screen_work) == STATE_OK) return TRUE;
    else                                                       return FALSE;
}

int	stateload_screen(void)
{
    if (stateload_table(SID, suspend_screen_work) == STATE_OK) return TRUE;
    else                                                       return FALSE;
}
























/* ǥХåѤδؿ */
void attr_misc(int line)
{
int i;

  text_attr_flipflop ^= 1;    
  for(i=0;i<80;i++){
    printf("%02X[%02X] ",
    text_attr_buf[text_attr_flipflop][line*80+i]>>8,
    text_attr_buf[text_attr_flipflop][line*80+i]&0xff );
  }
return;
  for(i=0;i<80;i++){
    printf("%c[%02X] ",
    text_attr_buf[text_attr_flipflop][9*80+i]>>8,
    text_attr_buf[text_attr_flipflop][9*80+i]&0xff );
  }
  for(i=0;i<80;i++){
    printf("%c[%02X] ",
    text_attr_buf[text_attr_flipflop][10*80+i]>>8,
    text_attr_buf[text_attr_flipflop][10*80+i]&0xff );
  }
  for(i=0;i<80;i++){
    printf("%c[%02X] ",
    text_attr_buf[text_attr_flipflop][11*80+i]>>8,
    text_attr_buf[text_attr_flipflop][11*80+i]&0xff );
  }
  printf("\n");
  for(i=0;i<80;i++){
    printf("%c[%02X] ",
    text_attr_buf[text_attr_flipflop][12*80+i]>>8,
    text_attr_buf[text_attr_flipflop][12*80+i]&0xff );
  }
  printf("\n");
  for(i=0;i<80;i++){
    printf("%c[%02X] ",
    text_attr_buf[text_attr_flipflop][13*80+i]>>8,
    text_attr_buf[text_attr_flipflop][13*80+i]&0xff );
  }
  printf("\n");
  for(i=0;i<80;i++){
    printf("%c[%02X] ",
    text_attr_buf[text_attr_flipflop][14*80+i]>>8,
    text_attr_buf[text_attr_flipflop][14*80+i]&0xff );
  }
#if 0
  for(i=0;i<80;i++){
    printf("%c[%02X] ",
    text_attr_buf[0][15*80+i]>>8,
    text_attr_buf[0][15*80+i]&0xff );
  }
  printf("\n");
  for(i=0;i<80;i++){
    printf("%c[%02X] ",
    text_attr_buf[0][16*80+i]>>8,
    text_attr_buf[0][16*80+i]&0xff );
  }
  printf("\n");
  for(i=0;i<80;i++){
    printf("%c[%02X] ",
    text_attr_buf[0][17*80+i]>>8,
    text_attr_buf[0][17*80+i]&0xff );
  }
  printf("\n");
  for(i=0;i<80;i++){
    printf("%c[%02X] ",
    text_attr_buf[0][18*80+i]>>8,
    text_attr_buf[0][18*80+i]&0xff );
  }
  printf("\n");
  for(i=0;i<80;i++){
    printf("%c[%02X] ",
    text_attr_buf[0][19*80+i]>>8,
    text_attr_buf[0][19*80+i]&0xff );
  }
  printf("\n");
#endif
}
