#ifndef GRAPH_H_INCLUDED
#define GRAPH_H_INCLUDED


/***********************************************************************
 * եå (ƥ¸)
 ************************************************************************/

#include "screen.h"	/* PC88_PALETTE_T */


/***********************************************************************
 * ̤˴ؤ롢ܾޤȤ᤿¤
 ************************************************************************/
typedef struct {

    int		window_max_width;	/* ɥɽǽʡ	     */
    int		window_max_height;	/* Ƚĥ (ԥ)   */
					/*	ɥɽ */
					/*	̵ϡŬ礭ͤ */
					/*	åȤƤ(640ʾ)    */

    int		fullscreen_max_width;	/* ե륹꡼ɽǽʡ  */
    int		fullscreen_max_height;	/* Ƚĥ (ԥ)   */
					/*	ե륹꡼ɽǤʤ */
					/*	 0 򥻥åȤƤ      */

    int		forbid_status;		/* ơɽػߤʤ顢  */

    int		forbid_half;		/* Ⱦʬɽػߤʤ顢  */

} T_GRAPH_SPEC;


/***********************************************************************
 *  QUASI88 оݤȤʤ̤ΡޤȤ᤿¤
 *
 *
 *		<--- byte_per_line --->		(*) width ϡºݤɽ
 *		<-- width (*) -->		륨ꥢΥԥ
 *     buffer =>@---------------+-----+ -	ХȿǤϡ
 *		|               |/////| ^	width * byte_per_pixel Х
 *		|               |/////| |	Ȥʤ롣
 *		|               |/////| | height
 *		|               |/////| |
 *		|               |/////| v
 *		+---------------+/////| -
 *		|/////////////////////|
 *		+---------------------+
 *
 * () byte_per_pixel == 2 λ̥ХåեΥԥ (X,Y) ˤϡ
 *	((unsigned short *) buffer) + (Y * byte_per_line / byte_per_pixel) + X
 *	Ȥơǽ
 *
 *	Ūˤϡ graph_add_color() ˤƼ pixel ͤ򤳤
 *	饤Ȥ뤳Ȥˤʤ롣
 *
 ************************************************************************/
typedef struct {

    int		fullscreen;	/* ̥⡼ɤʤ鿿ɥʤ鵶 */

    int		width;		/* ݤ̤Ρǽꥢ	*/
    int		height;		/* ݤ̤Ρǽꥢ⤵	*/

    int		byte_per_pixel;	/* ݤ̤Υԥ뤢Хȿ	*/
				/*	1, 2, 4 Τ줫		*/

    int		byte_per_line;	/* ݤ̤1饤󤢤Хȿ	*/
				/*	(width * byte_per_line) ʾ	*/

    void	*buffer;	/* ݤ̤ΥХåե		*/
				/*	byte_per_pixel 		*/
				/*		1 ʤ顢 unsigned char	*/
				/*		2 ʤ顢 unsigned short	*/
				/*		4 ʤ顢 unsigned int	*/
				/*	ǡǤݥ	*/

    int		nr_color;	/* ݤ̤ˤơѲǽʿο	*/
				/*	ƱѤǤ뿧ο	*/
				/*	硢οο֤	*/
				/*	ʲΤ줫Ȥ롣	*/
				/*		16, 24, 144, 255	*/
				/*	ο󤬤ʤϡ	*/
				/*		255 ʾ		*/

    int		write_only;	/* ̤ΥХåեɽԲĤξ硢	*/
				/*	ľܥե졼Хåեݤ	*/
				/*	ʤɤϡˤƤ	*/

    int		broken_mouse;	/* ޥɽꤢʤ顢	*/
				/*	ޥɽ꤬	*/
				/*	ƥब褦		*/
				/*	   X11-DGA:ޥϴ	*/
				/*	           Ūˡɽʤ	*/
				/*	   SDL-DGA:ޥɽ	*/
				/*	           ȡ̤˥	*/
				/*	           Ĥ礬롣	*/
				/*	ΥƥǤϡ˥塼	*/
				/*	̤ȼΥԤ	*/
				/*	Τǡ TRUE 򥻥åȤƤ	*/
				/*	̤ΥƥǤϡϤʤ	*/
				/*	ȻפΤǡ FALSE 򥻥åȤ	*/
				/*	ȡ			*/

    void	(*draw_start)(void);
    void	(*draw_finish)(void);
				/* ̤ΥХåե˥ݤˡ	*/
				/* ˸ƤӽФؿ		*/
				/*	buffer Υ饤Ȥ˺ݤơɬפ	*/
				/*	硢򵭽	*/
				/*	ؿ򤳤ꤷƤ	*/
				/*	äɬפʤС NULL 	*/
				/*	ꤷƤ			*/

    int		dont_frameskip;	/* ե졼ॹåפػߤʤ顢	*/
				/*	ʤСե졼ɬ 	*/
				/*	graph_update ƤӽФ롣	*/
				/*	򥹥åפϡ	*/
				/*	graph_update ˤȼ	*/
				/*	å׽Ȥ߹ळȡ	*/

} T_GRAPH_INFO;



/****************************************************************************
 * եåνλ
 *
 * const T_GRAPH_SPEC	*graph_init(void)
 *
 *	ƥ¸ΥեåνԤ
 *	顢̤˴ؤܾ T_GRAPH_SPEC ѿؤ
 *	ݥ󥿤ˤ֤˼Ԥϡ NULL ֤
 *
 *	o QUASI88 ϡư 1δؿƤӽФ
 *	  ̥⡼ɤǽ̥ڤؤϲǽʤɤȽǤ롣
 *
 * void	graph_exit(void)
 *
 *	ƥ¸ΥեåθԤ
 *	δؿϡλ 1ƤӽФ롣
 *
 *****************************************************************************/
const T_GRAPH_SPEC	*graph_init(void);
void			graph_exit(void);



/****************************************************************************
 * եå
 *
 * const T_GRAPH_INFO	*graph_setup(int width, int height,
 *				     int fullscreen, double aspect)
 *
 *	ɥꥵ롣ޤ̥⡼ɤڤؤ롣
 *	width, height ϡɥʤ̥⡼ɤΥ
 *	ɬ width  8ܿ height  2ܿåȤ롣
 *	fullscreen ʤ顢̥⡼ɤˤ롣
 *	aspect ϡ˥Υڥ (Ĳ)
 *	4:3ʤ 1.3333 16:9ʤ 1.7778ʤʤ 0.0 Ȥʤ롣
 *	fullscreen ǡ aspect > 0.0 ʤ饢ڥθ̥⡼
 *	ˤȤ줷⡣(ΰ̵뤷Ƥ⡢³Ϥʤ)
 *
 *	ɬ⡢̤ˤʤʤƤ褤
 *	̥⡼ɤڤؤ˼Ԥ顢ɥɽƤ褤
 *	ꥵ̥⡼ɤ̵ʤ顢礭ʡ̥⡼ɤ
 *	Ƥ褤(⾮ʥˤƤϤʤ)
 *
 *	ǽŪˤɤΤ褦ʽ̤ˤʤä T_GRAPH_INFO ѿؤΥݥ
 *	ˤ֤˼Ԥ³ǽȤʤäϡ NULL ֤
 *
 *	o QUASI88 ϡ graph_init() ˡδؿƤӽФ
 *	  ̥䡢̥⡼ؤκݤˤ⡢δؿƤӽФ
 *	  QUASI88 ϥɥ1ĤȤʤΤǡ2ܰʹߤθƤӽФϡ
 *	  Υɥ俧ʤɤΡ٤Ƥξ˴롣
 *
 *		<QUASI88 β̥ڤؤν>
 *
 *		  
 *		graph_setup();
 *		graph_add_color(Ƥο);
 *		graph_update(ΰ);
 *		  
 *
 ****************************************************************************/
const T_GRAPH_INFO	*graph_setup(int width, int height,
				     int fullscreen, double aspect);


/****************************************************************************
 * γݤ˴
 *
 * void	graph_add_color(const PC88_PALETTE_T color[],
 *			int nr_color, unsigned long pixel[])
 *
 *	color ϺѤǡ nr_color Ĥ
 *	 color бԥͤ nr_color Ĥ pixel ֤
 *
 *	㤨С(T_GRAPH_INFO *)->byte_per_pixel  2 Ǥ硢QUASI88 
 *	pixel ˤ֤줿ԥͤ unsigned short ˥㥹Ȥơ
 *	(T_GRAPH_INFO *)->buffer ľܥ饤Ȥ뤳Ȥˤʤ롣
 *
 *	o TrueColor δĶǤϡ color  RGBͤ򤽤ΤޤޥԥեޥåȤ
 *	  Ѵơpixel[] ˥åȤФ褤Ϥ
 *
 *
 * void	graph_remove_color(int nr_pixel, unsigned long pixel[])
 *
 *	pixel ϡѤʤʤäǡ nr_pixel Ĥ
 *	graph_add_color() ˤƼ pixel ͤåȤƤ롣
 *
 *	o TrueColor δĶǤϡä˲ɬפϤʤϥ
 *
 *	o ѤǤ뿧ƥˤä¤Ƥ硢δɬ
 *	  ˤʤ뤳Ȥ롣 (X11  PseudoColor Ƕͭ顼Ȥʤ)
 * 
 *	  QUASI88  graph_remove_color ƤӽФ硢ΰ pixel ϡ
 *	  ľ graph_add_color() ˤƳݤ nr_color Ĥ pixel 
 *	  ƱȤʤ褦ˤƤ롣 (ĤޤꡢLIFO)
 *
 *		  
 *		graph_add_color(8);		ơѤ8ݤ
 *		  
 *		graph_add_color(16);		ᥤѤ16ݤ
 *		  
 *		graph_remove_color(16);	ľ16˴
 *		  
 *		graph_remove_color(8);	ˤ8˴
 *		  
 *
 *	  ΤȤȤơ graph_add_color(), graph_remove_color() 
 *	  ɬפ롣
 *
 *****************************************************************************/
void	graph_add_color(const PC88_PALETTE_T color[],
			int nr_color, unsigned long pixel[]);
void	graph_remove_color(int nr_pixel, unsigned long pixel[]);



/***********************************************************************
 * ̤ι
 *
 * void	graph_update(int nr_rect, T_SCREEN_RECT rect[])
 *	ǡºݤ褹롣
 *	褷ꥢT_SCREEN_RECT  rect[]  nr_rect ʬ
 *	åȤƤΤǡΥꥢ褹롣
 *
 *	o QUASI88 ϡɽκݤ˰ʲν˽롣
 *
 *	    if (ե졼ॹåפʤ?) {		1
 *		if (ѥåѲ?) {
 *		    graph_remove_color(ΥѥåȤǻȤä);
 *		    graph_add_color(ΥѥåȤǻȤ);
 *		    ѲȤ
 *		}
 *		if (Ѳ?) {
 *		    if (draw_start != NULL) {		2
 *			(*draw_start)();
 *		    }
 *		    buffer 
 *		    if (draw_finish != NULL) {		2
 *			(*draw_finish)();
 *		    }
 *		    graph_update(̾Ρ줿ΰ);
 *	    }
 *
 *		1 graph_setup() ˤơ dont_frameskip Ǥä硢
 *		    ե졼ॹåפʤ
 *		2 graph_setup() ˤơ draw_start / draw_finish 
 *		    ؿݥ󥿤ꤵ줿ΤߡƤӽФ
 *
 ************************************************************************/
typedef struct {
    int x, y;
    int width, height;
} T_GRAPH_RECT;

void	graph_update(int nr_rect, T_GRAPH_RECT rect[]);



/***********************************************************************
 * °
 *	ϼʤƤ⡢餯ߥưˤϱƶϤʤ
 *	ƥबݡȤƤܤСФ褤
 *
 * void	graph_set_window_title(const char *title)
 *	ɥΥȥꤹ롣
 *	title ʸǡ 255ʸ ASCII
 *
 * void	graph_set_attribute(int mouse_show, int grab, int keyrepeat_on)
 *	ޤޤ°ꤹ롣
 *	mouse_show ʤ顢ޥɽ롣ʤõ롣
 *	grab  ʤ顢ޥϤ򥰥֤롣ʤ餷ʤ
 *	keyrepeat_on ʤ顢ԡȤ򥪥ˤ롣ʤ饪դˤ롣
 *
 ************************************************************************/
void	graph_set_window_title(const char *title);
void	graph_set_attribute(int mouse_show, int grab, int keyrepeat_on);



#endif	/* GRAPH_H_INCLUDED */
