/***********************************************************************
 * Ĵ (ƥ¸)
 *
 *	ܺ٤ϡ wait.h 
 ************************************************************************/

#include <stdio.h>
#include <SDL.h>

#include "quasi88.h"
#include "initval.h"
#include "wait.h"



/*---------------------------------------------------------------------------*/
static	int	wait_do_sleep;			/* idle sleep        */

static	int	wait_counter = 0;		/* Ϣ³֥С*/
static	int	wait_count_max = 10;		/* ʾϢ³С
						   ö,Ĵ */

/* Ȥ˻Ѥ֤ɽϡ usñ̤Ȥ롣 (ms٤㤤Τ) 

   SDL λؿ SDL_GetTicks()  ms ñ̤ǡ unsigned long ֤
    1000ܤ (usѴ) Ѥȡ71ʬǷ夢դ줷ƤޤΤǡ
   ɽ long long ˤ褦

   ʤ SDL_GetTicks  49ܤä(wrap)ޤΤǡɽ⤳νִ֤
   ʤΤˤʤ (Ȼ֤Ѥˤʤ) ˤʤȤˤ롣 */

#ifdef SDL_HAS_64BIT_TYPE
typedef	Sint64		T_WAIT_TICK;
#else
typedef	long		T_WAIT_TICK;
#endif

static	T_WAIT_TICK	next_time;		/* ե졼λ */
static	T_WAIT_TICK	delta_time;		/* 1 ե졼λ */



/* ---- ߻ (usecñ) ---- */

#define	GET_TICK()	((T_WAIT_TICK)SDL_GetTicks() * 1000)





/****************************************************************************
 * Ĵνλ
 *****************************************************************************/
int	wait_vsync_init(void)
{
    if (! SDL_WasInit(SDL_INIT_TIMER)) {
	if (SDL_InitSubSystem(SDL_INIT_TIMER) != 0) {
	    if (verbose_wait) printf("Error Wait (SDL)\n");
	    return FALSE;
	}
    }

    return TRUE;
}

void	wait_vsync_exit(void)
{
}



/****************************************************************************
 * Ĵ
 *****************************************************************************/
void	wait_vsync_setup(long vsync_cycle_us, int do_sleep)
{
    wait_counter = 0;


    delta_time = (T_WAIT_TICK) vsync_cycle_us;		/* 1ե졼 */
    next_time  = GET_TICK() + delta_time;		/* ե졼 */

    wait_do_sleep = do_sleep;				/* Sleep ̵ͭ */
}



/****************************************************************************
 * Ƚ
 *****************************************************************************/
int	wait_vsync_update(void)
{
    int slept   = FALSE;
    int on_time = FALSE;
    T_WAIT_TICK diff_ms;


    diff_ms = (next_time - GET_TICK()) / 1000;

    if (diff_ms > 0) {			/* ٤Ƥʤ(֤;äƤ)ʤ */
					/* diff_ms ߥáȤ     */

	if (wait_do_sleep) {		/* ֤ޤ sleep  */

#if 1	    /* ˡ (1) */
	    SDL_Delay((Uint32) diff_ms);	/* diff_ms ߥáǥ쥤 */
	    slept = TRUE;

#else	    /* ˡ (2) */
	    if (diff_ms < 10) {			/* 10ms̤ʤӥ*/
		while (GET_TICK() <= next_time)
		    ;
	    } else {				/* 10msʾʤǥ쥤      */
		SDL_Delay((Uint32) diff_ms);
		slept = TRUE;
	    }
#endif

	} else {			/* ֤ޤTickƻ뤹 */

	    while (GET_TICK() <= next_time)
		;				/* ӥ */
	}

	on_time = TRUE;
    }

    if (slept == FALSE) {	/* ٤ SDL_Delay ʤä */
	SDL_Delay(1);			/* for AUDIO thread ?? */
    }


    /* ե졼򻻽 */
    next_time += delta_time;


    if (on_time) {			/* ˽Ǥ */
	wait_counter = 0;
    } else {				/* ˽ǤƤʤ */
	wait_counter ++;
	if (wait_counter >= wait_count_max) {	/* ٤줬Ҥɤ */
	    wait_vsync_setup((long) delta_time,	/* Ȥ   */
			     wait_do_sleep);
	}
    }

#if 0
    {
	static int x = 0, y = 0;
	if (++x == 55) {
	    y++;
	    x = 0;
	    printf("wait %d\n", y);
	    fflush(stdout);
	}
    }
#endif

    if (on_time) return WAIT_JUST;
    else         return WAIT_OVER;
}
