/***********************************************************************
 * ɽϽ (ƥ¸)
 *
 *      ܺ٤ϡ snddrv.h / mame-quasi88.h 
 ************************************************************************/

#include "quasi88.h"
#include "device.h"

#include "snddrv.h"

#ifdef	USE_SOUND

#include "mame-quasi88.h"

/*===========================================================================*/
/*              QUASI88 ƤӽФ롢MAME νؿ                    */
/*===========================================================================*/

/******************************************************************************
 * ɷϥץνλؿ
 *
 * int xmame_config_init(void)
 *      config_init() ꡢץβϤ򳫻Ϥ˸ƤӽФ롣
 *      MAME¸νʤɤɬפʾϡǹԤ
 *
 * void xmame_config_exit(void)
 *      config_exit() ꡢκǸ˸ƤӽФ롣
 *      xmame_config_init() νθդɬפʤ顢ǹԤ
 *
 *****************************************************************************/
int	xmame_config_init(void)
{
    return 0;		/*OSD_OK;*/
}
void	xmame_config_exit(void)
{
}


/******************************************************************************
 * ɷϥץΥץơ֥
 *
 * const T_CONFIG_TABLE *xmame_config_get_opt_tbl(void)
 *      config_init() ꡢ xmame_config_init() θ˸ƤӽФ롣
 *
 *      ɷϥץβϽˤơ QUASI88 Υץơ֥
 *      T_CONFIG_TABLE Ѥ硢Υݥ󥿤֤
 *      ȼǲϤϡ NULL ֤
 *****************************************************************************/

/* ʲϡɸŪʥץΥơ֥ */

static	const	T_CONFIG_TABLE xmame_options[] =
{
  /* 350399: ɰ¸ץ */

  { 351, "sound",        X_FIX,  &use_sound,       TRUE,                  0,0, OPT_SAVE },
  { 351, "nosound",      X_FIX,  &use_sound,       FALSE,                 0,0, OPT_SAVE },

  { 353, "fmgen",        X_FIX,  &use_fmgen,       TRUE,                  0,0, OPT_SAVE },
  { 353, "nofmgen",      X_FIX,  &use_fmgen,       FALSE,                 0,0, OPT_SAVE },

/*{ 354, "volume",       X_INT,  &attenuation,     -32, 0,                  0, OPT_SAVE },*/

  { 355, "fmvol",        X_INT,  &fmvol,           0, 100,                  0, OPT_SAVE },
  { 356, "psgvol",       X_INT,  &psgvol,          0, 100,                  0, OPT_SAVE },
  { 357, "beepvol",      X_INT,  &beepvol,         0, 100,                  0, OPT_SAVE },
  { 358, "rhythmvol",    X_INT,  &rhythmvol,       0, 200,                  0, OPT_SAVE },
  { 359, "adpcmvol",     X_INT,  &adpcmvol,        0, 200,                  0, OPT_SAVE },
  { 360, "fmgenvol",     X_INT,  &fmgenvol,        0, 100,                  0, OPT_SAVE },
  { 361, "samplevol",    X_INT,  &samplevol,       0, 100,                  0, OPT_SAVE },

  { 362, "samplefreq",   X_INT,  &options.samplerate, 8000, 48000,          0, OPT_SAVE },

  { 363, "samples",      X_FIX,  &options.use_samples, 1,                 0,0, OPT_SAVE },
  { 363, "nosamples",    X_FIX,  &options.use_samples, 0,                 0,0, OPT_SAVE },

  /* ü */
  {   0, NULL,           X_INV,                                       0,0,0,0, 0        },
};

const T_CONFIG_TABLE *xmame_config_get_opt_tbl(void)
{
    return xmame_options;
}


/******************************************************************************
 * ɷϥץΥإץåɽ
 *
 * void xmame_config_show_option(void)
 *      config_init() ꡢץ -help νκݤ˸ƤӽФ롣
 *      ɸϤ˥إץåɽ롣
 *****************************************************************************/
#ifdef	XMAME_SNDDRV_071
#define	XMAME_VER "0.71.1"
#else	/* ver 0.106 */
#define	XMAME_VER " 0.106"
#endif

void	xmame_config_show_option(void)
{
  fprintf(stdout,
  "\n"
  "==========================================\n"
  "== SOUND OPTIONS ( dependent on XMAME ) ==\n"
  "==                     [ XMAME " XMAME_VER " ] ==\n"
  "==========================================\n"
  "    -[no]sound              Enable/disable sound (if available) [-sound]\n"
  "    -[no]fmgen              Use/don't use cisc's fmgen library\n"
  "                                               (if compiled in)  [-nofmgen]\n"
/*"    -volume <n>             Set volume to <n> db, (-32 (soft) - 0(loud)) [0]\n"*/
  "    -fmvol <level>          Set FM     level to <level> %%, (0 - 100) [100]\n"
  "    -psgvol <level>         Set PSG    level to <level> %%, (0 - 100) [20]\n"
  "    -beepvol <level>        Set BEEP   level to <level> %%, (0 - 100) [60]\n"
  "    -rhythmvol <level>      Set RHYTHM level to <level> %%, (0 - 100) [100]\n"
  "    -adpcmvol <level>       Set ADPCM  level to <level> %%, (0 - 100) [100]\n"
  "    -fmgenvol <level>       Set fmgen  level to <level> %%, (0 - 100) [100]\n"
  "    -samplevol <level>      Set SAMPLE level to <level> %%, (0 - 100) [100]\n"
  "    -samplefreq <rate>      Set the playback sample-frequency/rate [44100]\n"
  "    -[no]samples            Use/don't use samples (if available) [-nosamples]\n"
/*"    -[no]close              Close/no close sound device in MENU mode [-noclose]\n"*/
  );
}


/******************************************************************************
 * ɷϥץβϽ
 *
 * int xmame_config_check_option(char *opt1, char *opt2, int priority)
 *      config_init() ꡢեβϤԤʤݤˡ
 *      ΥץΤˤפʤ硢δؿƤӽФ롣
 *
 *              opt1      ǽΰ(ʸ)
 *              opt2      Τΰ(ʸ ʤ NULL)
 *              priority  ͥ (ͤ礭ۤͥ٤⤤)
 *
 *        1   1 (opt1 Τ߽ opt2 ̤)
 *              2   2 (opt1  opt2 )
 *              0   opt1 ̤ΤΰΤᡢ opt1 opt2 Ȥ̤
 *              -1  ̿Ūʰ۾郎ȯ
 *
 *      ΰ۾ (λͤϰϳʤ) 䡢ͥ٤ˤå
 *      줿褦ʾϡǤƱͤˡ 1  2 ֤
 *
 *       δؿϡȼǥץϤ뤿δؿʤΤǡ
 *         ץơ֥ T_CONFIG_TABLE ѤϡߡǤ褤
 *****************************************************************************/
int	xmame_config_check_option(char *opt1, char *opt2, int priority)
{
    return 0;
}


/******************************************************************************
 * ɷϥץ¸뤿δؿ
 *
 * int  xmame_config_save_option(void (*real_write)
 *                                 (const char *opt_name, const char *opt_arg))
 *
 *      ե¸κݤˡƤӽФ롣
 *              opt_name ˥ץ opt_arg ˥ץ
 *                åȤreal_write ƤӽФ
 *              Ȥư¸ץФƷ֤Ԥʤ
 *
 *              () "-sound" ե¸
 *                      (real_write)("sound", NULL) ƤӽФ
 *              () "-fmvol 80" ե¸
 *                      (real_write)("fmvol", "80") ƤӽФ
 *
 *         0 ֤
 *
 *       δؿϡȼǥץϤ뤿δؿʤΤǡ
 *         ץơ֥ T_CONFIG_TABLE ѤϡߡǤ褤
 *****************************************************************************/
int	xmame_config_save_option(void (*real_write)
				   (const char *opt_name, const char *opt_arg))
{
    return 0;
}


/******************************************************************************
 * ɷϥץ˥塼ѹ뤿Υơ֥ؿ
 *
 * T_SNDDRV_CONFIG *xmame_config_get_sndopt_tbl(void)
 *
 *      ˥塼⡼ɤγϻ˸ƤӽФ롣
 *              ѹǽʥɷϥץξT_SNDDRV_CONFIG 
 *              ȤѰդƬݥ󥿤֤
 *              Ϻ5ĤޤǡˤϽüǡ򥻥åȤƤ
 *
 *              äѹǤΤ̵ NULL ֤
 *****************************************************************************/
T_SNDDRV_CONFIG *xmame_config_get_sndopt_tbl(void)
{
    return NULL;
}


/******************************************************************************
 * ɵǽξؿ
 *
 * int xmame_has_audiodevice(void)
 *      ɥǥХϤβݤ֤
 *      ʤǥХϲġʤԲġ
 *
 * int xmame_has_mastervolume(void)
 *      ɥǥХβ̤ѹǽɤ֤
 *      ʤѹǽʤԲġ
 *
 *****************************************************************************/
int	xmame_has_audiodevice(void)
{
    return FALSE;
}

int	xmame_has_mastervolume(void)
{
    return FALSE;
}


/*===========================================================================*/
/*              MAME νؿƤӽФ롢ƥ¸ؿ        */
/*===========================================================================*/

/******************************************************************************
 * ɥǥХ
 *      δؿϡХѿ use_sound ξϡƤӽФʤ
 *
 * int osd_start_audio_stream(int stereo)
 *      ɥǥХ롣
 *          stereo ʤ饹ƥ쥪ϡʤΥϤǽ롣
 *          (ΥϤϡŤС MAME/XMAME  YM2203 
 *           ΤߡѤƤ롣ʳϤ٤ƥƥ쥪ϤѤ롣)
 *      δؿϡߥ졼γϻ˸ƤӽФ롣
 *          ϡ1ե졼ढΥץ֤
 *          Իϡ0 ֤
 *               0 ֤ QUASI88 λƤޤΤǡ
 *              ɥǥХν˼ԤǤ⡢ɽϤʤ
 *              ʤ᤿Ȥ硢ȤˤŬ֤ͤɬפ롣
 *
 * int osd_update_audio_stream(INT16 *buffer)
 *      ɥǥХ˽Ϥ롣
 *      δؿϡ1ե졼˸ƤӽФ롣buffer ˤ1ե졼ʬ
 *      (Machine->sample_rate / Machine->drv->frames_per_second) Υ
 *      ǡǼƤ롣ǡ 16bitդǡƥ쥪ξ
 *      ȱΥץ뤬ߤ¤Ǥ롣
 *
 *      ºݤˤδؿƤӽФ줿ߥ󥰤ǥǥХ˽Ϥ뤫뤤
 *      ǥХåե󥰤ӽϤ뤫ϡǤ롣
 *
 *      ͤϡ osd_start_audio_stream() Ʊ
 *
 * void osd_stop_audio_stream(void)
 *      ɥǥХλ롣
 *      δؿϡߥ졼νλ˸ƤӽФ롣
 *      ʹߡ osd_update_audio_stream() ʤɤϸƤӽФʤߥ졼
 *      Ƴϡ osd_start_audio_stream() ƤӽФ롣
 *
 * void osd_update_video_and_audio(void)
 *      ɥǥХνϤΣ
 *      ߥŪˤϡ osd_update_audio_stream() ľ˸ƤӽФ롣
 *      XMAME 0.106 ˹碌Ƥ뤬 osd_update_audio_stream() 
 *      ȼǤ줤СδؿϥߡǤ褤
 *
 * void osd_sound_enable(int enable)
 *      ɥǥХؤνϤꡦʤꤹ롣
 *          enable ʤϤꡢʤϤʤ
 *      δؿϡХѿ close_device ξΤߡƤӽФ롣
 *          ˥塼⡼ɤäݤˡ򵶤ȤƸƤӽФ
 *          ˥塼⡼ɤФݤˡ򿿤ȤƸƤӽФ
 *      δؿϡξˡɥǥХ (close) 
 *      ξ˳ (open) 褦ʼԤƤ뤬ɥǥХ
 *      ݤޤޤˤ褦ʼǤСߡδؿǤ褤
 *      ʤɥǥХؤνϤʤξ osd_update_audio_stream() 
 *      ʤɤδؿϸƤӽФ롣
 *
 *****************************************************************************/
int	osd_start_audio_stream(int stereo)
{
    return 44100 / DEFAULT_VSYNC_FREQ_HZ;
}

int	osd_update_audio_stream(INT16 *buffer)
{
    return 44100 / DEFAULT_VSYNC_FREQ_HZ;
}

void	osd_stop_audio_stream(void)
{
}

void	osd_update_video_and_audio(void)
{
}

void	osd_sound_enable(int enable)
{
}


/******************************************************************************
 * 
 *
 * void osd_set_mastervolume(int attenuation)
 *      ɥǥХβ̤ꤹ롣 attenuation  ̤ǡ -320 
 *      (ñ̤ db) ѹΤǤʤǥХǤСߡǤ褤
 *
 * int osd_get_mastervolume(void)
 *      ߤΥɥǥХβ̤롣 ͤ -320 (ñ̤ db)
 *      ѹΤǤʤǥХǤСߡǤ褤
 *
 *****************************************************************************/
void	osd_set_mastervolume(int attenuation)
{
}

int	osd_get_mastervolume(void)
{
    return VOL_MIN;
}

#endif	/* USE_SOUND */
