/***********************************************************************
 * ɽϽ (ƥ¸)
 *
 *      ܺ٤ϡ snddrv.h / mame-quasi88.h 
 ************************************************************************/

/*----------------------------------------------------------------------*
 * ClassicСΥɤʬϡ                          *
 * Koichi NISHIDA  Classic iP6 PC-6001/mk2/6601 emulator Υ *
 * ͤˤƤޤ                                         *
 *                                                   (c) Koichi NISHIDA *
 *                                       based on MESS/MAME source code *
 *----------------------------------------------------------------------*/


#include <OSUtils.h>
#include <Sound.h>
#include <Timer.h>
#include <QuickTime.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#ifdef	USE_SOUND

#include "mame-quasi88.h"

#include "snddrv.h"
static	int use_audiodevice = 1;	/* use audio-devide for audio output */


static Boolean InitializeSound(void);
static void TearDownSound(void);
static void PauseSound(Boolean inPause);
static Boolean isFullSoundStream(int dataNum);
static Boolean isLessSoundStream(int dataNum, long tick);


static Boolean alreadyInit = false;

#define	REFRESH_RATE	60.0
#define	CHANNELS		sNumOfChannles

/*----------------------------------------------------------------------*/
int		attenuation = 0;		/* ܥ塼 -320 [db] */

/*===========================================================================*/
/*              QUASI88 ƤӽФ롢MAME νؿ                    */
/*===========================================================================*/

/******************************************************************************
 * ɷϥץνλؿ
 *
 * int xmame_config_init(void)
 *      config_init() ꡢץβϤ򳫻Ϥ˸ƤӽФ롣
 *      MAME¸νʤɤɬפʾϡǹԤ
 *
 * void xmame_config_exit(void)
 *      config_exit() ꡢκǸ˸ƤӽФ롣
 *      xmame_config_init() νθդɬפʤ顢ǹԤ
 *
 *****************************************************************************/
int		xmame_config_init(void)
{
	return 0;		/*OSD_OK;*/
}
void	xmame_config_exit(void)
{
}


/******************************************************************************
 * ɷϥץΥץơ֥
 *
 * const T_CONFIG_TABLE *xmame_config_get_opt_tbl(void)
 *      config_init() ꡢ xmame_config_init() θ˸ƤӽФ롣
 *
 *      ɷϥץβϽˤơ QUASI88 Υץơ֥
 *      T_CONFIG_TABLE Ѥ硢Υݥ󥿤֤
 *      ȼǲϤϡ NULL ֤
 *****************************************************************************/
static	int	invalid_arg;			/* ̵ʥץѤΥߡѿ */
static	const	T_CONFIG_TABLE xmame_options[] =
{
  /* 350399: ɰ¸ץ */

  { 351, "sound",        X_FIX,  &use_sound,       TRUE,                  0,0, OPT_SAVE },
  { 351, "nosound",      X_FIX,  &use_sound,       FALSE,                 0,0, OPT_SAVE },

  { 352, "audio",        X_FIX,  &use_audiodevice, TRUE,                  0,0, OPT_SAVE },
  { 352, "noaudio",      X_FIX,  &use_audiodevice, FALSE,                 0,0, OPT_SAVE },

  { 353, "fmgen",        X_FIX,  &use_fmgen,       TRUE,                  0,0, OPT_SAVE },
  { 353, "nofmgen",      X_FIX,  &use_fmgen,       FALSE,                 0,0, OPT_SAVE },

  { 354, "volume",       X_INT,  &attenuation,     -32, 0,                  0, OPT_SAVE },

  { 355, "fmvol",        X_INT,  &fmvol,           0, 100,                  0, OPT_SAVE },
  { 356, "psgvol",       X_INT,  &psgvol,          0, 100,                  0, OPT_SAVE },
  { 357, "beepvol",      X_INT,  &beepvol,         0, 100,                  0, OPT_SAVE },
  { 358, "rhythmvol",    X_INT,  &rhythmvol,       0, 200,                  0, OPT_SAVE },
  { 359, "adpcmvol",     X_INT,  &adpcmvol,        0, 200,                  0, OPT_SAVE },
  { 360, "fmgenvol",     X_INT,  &fmgenvol,        0, 100,                  0, OPT_SAVE },
  { 361, "samplevol",    X_INT,  &samplevol,       0, 100,                  0, OPT_SAVE },

  { 362, "samplefreq",   X_INT,  &options.samplerate, 8000, 44100,          0, OPT_SAVE },

  { 363, "samples",      X_FIX,  &options.use_samples, 1,                 0,0, OPT_SAVE },
  { 363, "nosamples",    X_FIX,  &options.use_samples, 0,                 0,0, OPT_SAVE },

  /* ü */
  {   0, NULL,           X_INV,                                       0,0,0,0, 0        },
};

const T_CONFIG_TABLE *xmame_config_get_opt_tbl(void)
{
	return xmame_options;
}


/******************************************************************************
 * ɷϥץΥإץåɽ
 *
 * void xmame_config_show_option(void)
 *      config_init() ꡢץ -help νκݤ˸ƤӽФ롣
 *      ɸϤ˥إץåɽ롣
 *****************************************************************************/
#ifdef	XMAME_SNDDRV_071
#define	XMAME_VER "0.71.1"
#else	/* ver 0.106 */
#define	XMAME_VER " 0.106"
#endif

void	xmame_config_show_option(void)
{
  fprintf(stdout,
  "\n"
  "==========================================\n"
  "== SOUND OPTIONS ( dependent on XMAME ) ==\n"
  "==                     [ XMAME " XMAME_VER " ] ==\n"
  "==========================================\n"
  "    -[no]sound              Enable/disable sound (if available) [-sound]\n"
  "    -[no]fmgen              Use/don't use cisc's fmgen library\n"
  "                                               (if compiled in)  [-nofmgen]\n"
  "    -volume <n>             Set volume to <n> db, (-32 (soft) - 0(loud)) [0]\n"
  "    -fmvol <level>          Set FM     level to <level> %%, (0 - 100) [100]\n"
  "    -psgvol <level>         Set PSG    level to <level> %%, (0 - 100) [20]\n"
  "    -beepvol <level>        Set BEEP   level to <level> %%, (0 - 100) [60]\n"
  "    -rhythmvol <level>      Set RHYTHM level to <level> %%, (0 - 100) [100]\n"
  "    -adpcmvol <level>       Set ADPCM  level to <level> %%, (0 - 100) [100]\n"
  "    -fmgenvol <level>       Set fmgen  level to <level> %%, (0 - 100) [100]\n"
  "    -samplevol <level>      Set SAMPLE level to <level> %%, (0 - 100) [100]\n"
  "    -samplefreq <rate>      Set the playback sample-frequency/rate [44100]\n"
  "    -[no]samples            Use/don't use samples (if available) [-nosamples]\n"
  );
}


/******************************************************************************
 * ɷϥץβϽ
 *
 * int xmame_config_check_option(char *opt1, char *opt2, int priority)
 *      config_init() ꡢեβϤԤʤݤˡ
 *      ΥץΤˤפʤ硢δؿƤӽФ롣
 *
 *              opt1      ǽΰ(ʸ)
 *              opt2      Τΰ(ʸ ʤ NULL)
 *              priority  ͥ (ͤ礭ۤͥ٤⤤)
 *
 *        1   1 (opt1 Τ߽ opt2 ̤)
 *              2   2 (opt1  opt2 )
 *              0   opt1 ̤ΤΰΤᡢ opt1 opt2 Ȥ̤
 *              -1  ̿Ūʰ۾郎ȯ
 *
 *      ΰ۾ (λͤϰϳʤ) 䡢ͥ٤ˤå
 *      줿褦ʾϡǤƱͤˡ 1  2 ֤
 *
 *       δؿϡȼǥץϤ뤿δؿʤΤǡ
 *         ץơ֥ T_CONFIG_TABLE ѤϡߡǤ褤
 *****************************************************************************/
int		xmame_config_check_option(char *opt1, char *opt2, int priority)
{
	return 0;
}


/******************************************************************************
 * ɷϥץ¸뤿δؿ
 *
 * int  xmame_config_save_option(void (*real_write)
 *                                 (const char *opt_name, const char *opt_arg))
 *
 *      ե¸κݤˡƤӽФ롣
 *              opt_name ˥ץ opt_arg ˥ץ
 *                åȤreal_write ƤӽФ
 *              Ȥư¸ץФƷ֤Ԥʤ
 *
 *              () "-sound" ե¸
 *                      (real_write)("sound", NULL) ƤӽФ
 *              () "-fmvol 80" ե¸
 *                      (real_write)("fmvol", "80") ƤӽФ
 *
 *         0 ֤
 *
 *       δؿϡȼǥץϤ뤿δؿʤΤǡ
 *         ץơ֥ T_CONFIG_TABLE ѤϡߡǤ褤
 *****************************************************************************/
int		xmame_config_save_option(void (*real_write)
								   (const char *opt_name, const char *opt_arg))
{
	return 0;
}


/******************************************************************************
 * ɷϥץ˥塼ѹ뤿Υơ֥ؿ
 *
 * T_SNDDRV_CONFIG *xmame_config_get_sndopt_tbl(void)
 *
 *      ˥塼⡼ɤγϻ˸ƤӽФ롣
 *              ѹǽʥɷϥץξT_SNDDRV_CONFIG 
 *              ȤѰդƬݥ󥿤֤
 *              Ϻ5ĤޤǡˤϽüǡ򥻥åȤƤ
 *
 *              äѹǤΤ̵ NULL ֤
 *****************************************************************************/
T_SNDDRV_CONFIG *xmame_config_get_sndopt_tbl(void)
{
	return NULL;
}


/******************************************************************************
 * ɵǽξؿ
 *
 * int xmame_has_audiodevice(void)
 *      ɥǥХϤβݤ֤
 *      ʤǥХϲġʤԲġ
 *
 * int xmame_has_mastervolume(void)
 *      ɥǥХβ̤ѹǽɤ֤
 *      ʤѹǽʤԲġ
 *
 *****************************************************************************/
int		xmame_has_audiodevice(void)
{
    if (use_audiodevice) return TRUE;
    else                 return FALSE;
}

int		xmame_has_mastervolume(void)
{
	return TRUE;
}


/*===========================================================================*/
/*              MAME νؿƤӽФ롢ƥ¸ؿ        */
/*===========================================================================*/

/******************************************************************************
 * ɥǥХ
 *      δؿϡХѿ use_sound ξϡƤӽФʤ
 *
 * int osd_start_audio_stream(int stereo)
 *      ɥǥХ롣
 *          stereo ʤ饹ƥ쥪ϡʤΥϤǽ롣
 *          (ΥϤϡŤС MAME/XMAME  YM2203 
 *           ΤߡѤƤ롣ʳϤ٤ƥƥ쥪ϤѤ롣)
 *      δؿϡߥ졼γϻ˸ƤӽФ롣
 *          ϡ1ե졼ढΥץ֤
 *          Իϡ0 ֤
 *               0 ֤ QUASI88 λƤޤΤǡ
 *              ɥǥХν˼ԤǤ⡢ɽϤʤ
 *              ʤ᤿Ȥ硢ȤˤŬ֤ͤɬפ롣
 *
 * int osd_update_audio_stream(INT16 *buffer)
 *      ɥǥХ˽Ϥ롣
 *      δؿϡ1ե졼˸ƤӽФ롣buffer ˤ1ե졼ʬ
 *      (Machine->sample_rate / Machine->drv->frames_per_second) Υ
 *      ǡǼƤ롣ǡ 16bitդǡƥ쥪ξ
 *      ȱΥץ뤬ߤ¤Ǥ롣
 *
 *      ºݤˤδؿƤӽФ줿ߥ󥰤ǥǥХ˽Ϥ뤫뤤
 *      ǥХåե󥰤ӽϤ뤫ϡǤ롣
 *
 *      ͤϡ osd_start_audio_stream() Ʊ
 *
 * void osd_stop_audio_stream(void)
 *      ɥǥХλ롣
 *      δؿϡߥ졼νλ˸ƤӽФ롣
 *      ʹߡ osd_update_audio_stream() ʤɤϸƤӽФʤߥ졼
 *      Ƴϡ osd_start_audio_stream() ƤӽФ롣
 *
 * void osd_update_video_and_audio(void)
 *      ɥǥХνϤΣ
 *      ߥŪˤϡ osd_update_audio_stream() ľ˸ƤӽФ롣
 *      XMAME 0.106 ˹碌Ƥ뤬 osd_update_audio_stream() 
 *      ȼǤ줤СδؿϥߡǤ褤
 *
 * void osd_sound_enable(int enable)
 *      ɥǥХؤνϤꡦʤꤹ롣
 *          enable ʤϤꡢʤϤʤ
 *      δؿϡХѿ close_device ξΤߡƤӽФ롣
 *          ˥塼⡼ɤäݤˡ򵶤ȤƸƤӽФ
 *          ˥塼⡼ɤФݤˡ򿿤ȤƸƤӽФ
 *      δؿϡξˡɥǥХ (close) 
 *      ξ˳ (open) 褦ʼԤƤ뤬ɥǥХ
 *      ݤޤޤˤ褦ʼǤСߡδؿǤ褤
 *      ʤɥǥХؤνϤʤξ osd_update_audio_stream() 
 *      ʤɤδؿϸƤӽФ롣
 *
 *****************************************************************************/

/******************************************************************************
 * 
 *
 * void osd_set_mastervolume(int attenuation)
 *      ɥǥХβ̤ꤹ롣 attenuation  ̤ǡ -320 
 *      (ñ̤ db) ѹΤǤʤǥХǤСߡǤ褤
 *
 * int osd_get_mastervolume(void)
 *      ߤΥɥǥХβ̤롣 ͤ -320 (ñ̤ db)
 *      ѹΤǤʤǥХǤСߡǤ褤
 *
 *****************************************************************************/

static int sound_samples_per_frame = 0;


// C string <> Pascal string conversion
static void CopyCStringToPascal(const char *src, unsigned char *dst)
{
	int num = 0;
	int i;
	const char *srcBak = src;

	while (*(src++) != '\0') {
		num++;
	}
	src = srcBak;
	dst[0] = num;
	for (i=0; i<num; i++) {
		dst[i+1]=*(src++);
	}
}
static void CopyPascalStringToC(const unsigned char *src, char *dst)
{
	int i;
	for (i=0; i < src[0]; i++) {
		*(dst++) = src[i+1];
	}
	*(dst) = '\0';
}



// constants
enum
{
	kSoundStreamFramesAt44kHz	= 12288*1,
	kTotalSoundBuffers			= 2,
	kQueuedSoundBuffers			= 2
};

// our buffered data
static SInt16	sSoundStream[kSoundStreamFramesAt44kHz * 2];
static UInt32	sSoundStreamFrames;
static UInt32	sSoundIn;
static UInt32	sSoundOut;

// the sound channel
static SndChannelPtr sSoundChannel;

// sound timing
ComponentInstance 	gSoundClock;

// sound buffer parameters
static UInt32			sSoundBufferFrames;
static UInt32			sSoundBufferBytes;
static Boolean			sSoundIsPaused;

// sound buffers
static SndCallBackUPP	sSoundCallback;
static ExtSoundHeader	*sSoundBuffer[kTotalSoundBuffers];
static SndCommand		sSoundBufferCmd[kTotalSoundBuffers];
static SndCommand		sSoundCallbackCmd[kTotalSoundBuffers];

static int				sNumOfChannles = 2;

// function prototypes
static pascal void SoundCallback(SndChannelPtr inChannel, SndCommand *inCommand);
static void FillSoundBuffer(SInt16 *inBuffer);
static Boolean InitializeSoundChannel(void);
static Boolean InitializeSoundBuffers(void);
static void FreeSoundBuffers(void);

//#pragma segment SegMain

static void memcpyW(register void *dst, register void *src, register unsigned long num)
{
	register int i;
	if (num&1) {
		for (i = 0; i < num; i++)
			*(((short *)dst)++) = *(((short *)src)++);
	} else {
		for (i = 0; i < num>>1; i++)
			*(((long *)dst)++) = *(((long *)src)++);
	}
}

// examine whether the sSoundStreamFrames is full or not
static Boolean isFullSoundStream(int dataNum)
{
	UInt32		soundIn = sSoundIn;
	Boolean		updateOk = false;

	// check	
	if (soundIn < sSoundOut) {
		if ((soundIn + dataNum) <= sSoundOut) updateOk = true;
	} else if ((soundIn + dataNum) > sSoundStreamFrames) {
		if ((soundIn + dataNum - sSoundStreamFrames) <= sSoundOut) updateOk = true;
	} else updateOk = true;
	if (!updateOk) return true;
	else return false;
}

// examine whether the sSoundStreamFrames will be empty soon or not
static Boolean isLessSoundStream(int dataNum, long tick)
{
	Boolean		updateOk = false;

	// check	
	if (sSoundOut < sSoundIn) {
		return sSoundIn - sSoundOut <= dataNum*tick;
	} else if (sSoundIn < sSoundOut) {
		return sSoundIn - (sSoundOut - sSoundStreamFrames) <= dataNum*tick;
	} else return true;
}

//#pragma segment SegInit

// start the audio system going
int osd_start_audio_stream(int stereo)
{
	CHANNELS = (stereo) ? 2 : 1;

	if (Machine->sample_rate < 8000) {
		Machine->sample_rate = 8000;
	} else if (Machine->sample_rate > 44100) {
		Machine->sample_rate = 44100;
	}

#ifdef	XMAME_SNDDRV_071

#if 0
	sound_samples_per_frame = (int)(Machine->sample_rate /
         Machine->drv->frames_per_second);
#else
	sound_samples_per_frame = (int)(Machine->sample_rate / REFRESH_RATE);
#endif

#else	/* ver 0.106 */

#if 0
	sound_samples_per_frame = Machine->sample_rate / Machine->refresh_rate;
#else
	sound_samples_per_frame = (int)(Machine->sample_rate / REFRESH_RATE);
#endif

#endif


	if (use_audiodevice == FALSE) { return sound_samples_per_frame; }

	if (alreadyInit) return sound_samples_per_frame;
	alreadyInit = true;

	InitializeSound();

	////////
	sSoundIsPaused = false;
	
	// reset the sound buffer
	sSoundIn = sSoundOut = 0;
	sSoundStreamFrames = kSoundStreamFramesAt44kHz * CHANNELS * Machine->sample_rate / 44100;

	// pick the appropriate sound buffer size
	sSoundBufferFrames = 512 * Machine->sample_rate / 44100;
	sSoundBufferBytes = sSoundBufferFrames << CHANNELS;
	
	// allocate the sound channel and initialize the buffering
	if (!InitializeSoundBuffers())
	{
		return 0;
	}
	
	// set the initial volume (-0 dB)
	osd_set_mastervolume(attenuation);
	////////

	osd_sound_enable(1);

	return sound_samples_per_frame;
}

//#pragma segment SegMain

// pushes data into the audio stream
int osd_update_audio_stream(INT16 *buffer)
{
	register UInt32	soundIn = sSoundIn;
	register UInt32	framesToCopy;
	int dataNum;
	INT16 *bufferX;

	static long prevTick = 0;
	register int times;

	if (use_audiodevice == FALSE) { return sound_samples_per_frame; }

#if 1
	{
		register long tick = TickCount() - prevTick;
		if (tick > 4) tick = 4;
		prevTick = TickCount();

		if (isFullSoundStream(sound_samples_per_frame * CHANNELS)) return sound_samples_per_frame;
		times = isLessSoundStream(sound_samples_per_frame * CHANNELS, tick+1) ? (tick+1) : 1;
	}
#else
	times = 1;
#endif

	for (; times; times--) {

		bufferX = buffer;
		dataNum = sound_samples_per_frame * CHANNELS;

		// copy up to the end of the stream buffer
		while (dataNum > 0)
		{
			// determine how many frames we can copy
			framesToCopy = sSoundStreamFrames - soundIn;
			if (framesToCopy > dataNum)
				framesToCopy = dataNum;

			// copy and count the samples
			memcpyW(&sSoundStream[soundIn], bufferX, framesToCopy);
			dataNum -= framesToCopy;
			bufferX += framesToCopy;

			// adjust the output pointer
			soundIn += framesToCopy;
			if (soundIn >= sSoundStreamFrames)
				soundIn -= sSoundStreamFrames;
		}
	}
	sSoundIn = soundIn;

	/* return the samples to play this next frame */
	return sound_samples_per_frame;
}

void osd_stop_audio_stream(void)
{
	if (use_audiodevice == FALSE) { return; }

	if (!alreadyInit) return;
	alreadyInit = false;

	osd_sound_enable(0);
	TearDownSound();
}

void osd_update_video_and_audio(void)
{
	/* nothing */
}

void osd_sound_enable(int enable_it)
{
	if (use_audiodevice == FALSE) { return; }

	PauseSound(!enable_it);
}

//#pragma segment SegInit

//	sets the main volume ( -Attenuation dB )
static int now_attenuation = 0;
void osd_set_mastervolume(int attenuation)
{
	float multiplier = 1.0;
	UInt32 volume;

	if (use_audiodevice == FALSE) { return; }

	now_attenuation = attenuation;

	// compute a multiplier from the original volume
	while (attenuation++ < 0)
		multiplier *= 1.0 / 1.122018454;	// = (10 ^ (1/20)) = 1dB

	// apply it
	volume = (UInt32)(multiplier * 0x100);
	if (volume > 0x100) volume = 0x100;

	{
		SndCommand mySndCmd;
		//OSErr myErr;

		mySndCmd.cmd = volumeCmd;
		mySndCmd.param1 = 0;		// unused with volumeCmd
		mySndCmd.param2 = (volume << 16) | volume;
		SndDoCommand(sSoundChannel, &mySndCmd, false);
	}
}

int osd_get_mastervolume (void)
{
	if (use_audiodevice == FALSE) { return -32; }

	return now_attenuation;
}

// allocates a sound channel and starts it running
// first this must be called ?
static Boolean InitializeSound(void)
{
	SndCommand 		command;
	OSErr			err;
	
	// attempt to initialize the sound buffers
	if (!InitializeSoundChannel()) return false;

	// nuke any existing clock references
	gSoundClock = NULL;

	// first turn on the clock
	command.cmd = clockComponentCmd;
	command.param1 = true;
	err = SndDoImmediate(sSoundChannel, &command);
	if (err != noErr)
		return false;
		
	// then get a component instance
	command.cmd = getClockComponentCmd;
	command.param2 = (SInt32)&gSoundClock;
	err = SndDoImmediate(sSoundChannel, &command);
	if (err != noErr)
	{
		sSoundChannel = NULL;
		return false;
	}
	return true;
}

// tearDownSound
static void TearDownSound(void)
{
	// free the channel
	if (sSoundChannel != NULL)
		SndDisposeChannel(sSoundChannel, true);
	sSoundChannel = NULL;

	// attempt to free the sound buffers
	FreeSoundBuffers();
}

// pauses/resumes sound output
static void PauseSound(Boolean inPause)
{
	sSoundIsPaused = inPause;
}

//#pragma segment SegMain

// common code to fill a sound buffer.
// called from call back
static void FillSoundBuffer(register SInt16 *inBuffer)
{
	register SInt32		framesAvailable;
	register UInt32		framesToCopy;

	if (sSoundIsPaused) {
		memset(inBuffer, 0, sSoundBufferFrames << CHANNELS);
		return;
	}
	
#if 1
	{
		static UInt16 skipCounter = 0;

		if (sSoundIn == sSoundOut) {
			if (skipCounter > 20) {
				memset(inBuffer, 0, sSoundBufferFrames << CHANNELS);
				return;
			}
			skipCounter ++;
		} else {
			skipCounter = 0;
		}
	}
#endif

	framesAvailable = sSoundIn - sSoundOut;

	// account for the circular buffer
	if (framesAvailable < 0)
		framesAvailable += sSoundStreamFrames;

	// if we have more than enough data, clip to the maximum per buffer
	if (framesAvailable >= sSoundBufferFrames * CHANNELS)
		framesAvailable = sSoundBufferFrames * CHANNELS;

	// copy up to the end of the stream buffer
	while (framesAvailable > 0)
	{
		// determine how many frames we can copy
		framesToCopy = sSoundStreamFrames - sSoundOut;
		if (framesToCopy > framesAvailable)
			framesToCopy = framesAvailable;

		// copy and count the samples
		memcpyW(inBuffer, &sSoundStream[sSoundOut], framesToCopy);
		
		framesAvailable -= framesToCopy;
		inBuffer += framesToCopy;

		// adjust the output pointer
		sSoundOut += framesToCopy;

		// wrap the output pointer
		if (sSoundOut >= sSoundStreamFrames)
			sSoundOut -= sSoundStreamFrames;
	}
}

//#pragma segment SegInit

// initialize the sound channel and any other one-shot data
static Boolean InitializeSoundChannel(void)
{
	OSErr err;
	long initOptions;

	// allocate a UPP callback
	sSoundCallback = NewSndCallBackUPP(SoundCallback);
	
	// now allocate the channel
	sSoundChannel = NULL;

    if (CHANNELS == 1) {
		initOptions = initMono   + initNoInterp + initNoDrop;
	} else {
		initOptions = initStereo + initNoInterp + initNoDrop;
	}
	err = SndNewChannel(&sSoundChannel, sampledSynth, initOptions, sSoundCallback);
	return (err == noErr);
}

// initialize the sound buffers and create the sound channel
static Boolean InitializeSoundBuffers(void)
{
	extended80 extFreq;
	int i;
	OSErr err;
	Handle itlHandle;               // The 'itl4' resource handle
	long offset, length;            // Offset-length of parts table
	NumFormatStringRec myFormatRec; // Canonical format record
	Str15 pRate;
	char cRate[16];
	
	sprintf(cRate, "%5d", Machine->sample_rate); 
	CopyCStringToPascal(cRate, pRate);
	GetIntlResourceTable (smCurrentScript, smNumberPartsTable, &itlHandle, &offset, &length);
	StringToFormatRec ("\p#####", (NumberParts *)(*itlHandle + offset), &myFormatRec);
	StringToExtended (pRate, &myFormatRec, (NumberParts *)(*itlHandle + offset), &extFreq);

	for (i = 0; i < kTotalSoundBuffers; i++)
	{
		// allocate and clear the sound buffer
		sSoundBuffer[i] = malloc(sizeof(ExtSoundHeader) + sSoundBufferBytes);
		// R. Nabet 0001212 : added error handling
		if (sSoundBuffer[i] == NULL)
		{
			while (--i >= 0)
				free(sSoundBuffer[i]);
			return false;
		}
		memset(sSoundBuffer[i], 0, sizeof(ExtSoundHeader) + sSoundBufferBytes);
		
		// intialize the buffer structures
		sSoundBuffer[i]->numChannels 	= CHANNELS;
		sSoundBuffer[i]->sampleRate 	= (UInt32)Machine->sample_rate << 16;
		sSoundBuffer[i]->encode 		= extSH;
		sSoundBuffer[i]->numFrames 		= sSoundBufferFrames;
		sSoundBuffer[i]->AIFFSampleRate = extFreq;
		sSoundBuffer[i]->sampleSize 	= 16;
		
		// initialize the sound commands
		sSoundBufferCmd[i].cmd 			= bufferCmd;
		sSoundBufferCmd[i].param2 		= (SInt32)sSoundBuffer[i];
		sSoundCallbackCmd[i].cmd 		= callBackCmd;
		sSoundCallbackCmd[i].param1 	= (i + kQueuedSoundBuffers) % kTotalSoundBuffers;
	}
	
	// start stuff playing
	for (i = 0; i < kQueuedSoundBuffers; i++)
	{
		err = SndDoCommand(sSoundChannel, &sSoundBufferCmd[i], true);
		if (err != noErr)
			return false;
		err = SndDoCommand(sSoundChannel, &sSoundCallbackCmd[i], true);
		if (err != noErr)
			return false;
	}
	return true;
}

// free the sound buffers and the sound channel
static void FreeSoundBuffers(void)
{
	UInt32 i;
	
	// free the buffers
	for (i = 0; i < kTotalSoundBuffers; i++)
	{
		if (sSoundBuffer[i] != NULL)
			free(sSoundBuffer[i]);
		sSoundBuffer[i] = NULL;
	}
}

//#pragma segment SegMain

// Callback command to stream data
static pascal void SoundCallback(SndChannelPtr inChannel, SndCommand *inCommand)
{
	UInt32		bufferIndex = inCommand->param1;

	// fill the sound buffer
	FillSoundBuffer((SInt16 *)sSoundBuffer[bufferIndex]->sampleArea);

	// queue up the commands

	SndDoCommand(sSoundChannel, &sSoundBufferCmd[bufferIndex], true);
	SndDoCommand(sSoundChannel, &sSoundCallbackCmd[bufferIndex], true);
}

#endif		/* USE_SOUND */
