// Utility program that tests some aspects of this game's code.

#include "util.h"

#include "Enemy.h"

#include <iomanip>

using namespace flatzebra;
using namespace std;


static bool
test_segmentIntersection()
{
    RCouple intersection;
    if (!segmentIntersection(RCouple(0, 0), RCouple(2, 0),
                             RCouple(1, -1), RCouple(1, 1),
                             intersection))
    {
        cout << "ERROR: no intersection found\n";
        return false;
    }
    cout << "intersection: " << intersection << endl;
    if (intersection != RCouple(1, 0))
    {
        cout << "ERROR: wrong intersection found: " << intersection << "\n";
        return false;
    }

    return true;
}


static bool
test_Enemy_chooseRandomly()
{
    size_t countByType[Enemy::NUM_ENEMY_TYPES];
    memset(countByType, '\0', sizeof(countByType));

    enum { N = 25000 };
    for (int i = 0; i < N; ++i)
    {
        Enemy::Type t = Enemy::chooseRandomly();
        ++countByType[int(t)];
    }

    unsigned short sum = 0;
    for (int i = 0; i < Enemy::NUM_ENEMY_TYPES; ++i)
        sum += Enemy::typeDistribution0[i];

    for (int t = 0; t < Enemy::NUM_ENEMY_TYPES; ++t)
    {
        double actualFreq = countByType[t] / double(N);
        double expectedFreq = Enemy::typeDistribution0[t] / double(sum);
        double ratio = actualFreq / expectedFreq;
        cout << "Type " << t
             << ": " << setw(5) << countByType[t]
             << " (" << actualFreq
             << ", expecting " <<  expectedFreq
             << ", ratio " << ratio
             << ")\n";

        if (ratio < 0.95 || ratio > 1.05)
        {
            cout << "ERROR: actual frequency differs too much from expected for type " << t << endl;
            return false;
        }
    }
    cout << endl;

    return true;
}


static bool success = true;


static void
runTestFunc(bool (*testFunc)())
{
    if (! (*testFunc)())
        success = false;
}


int
main(int /*argc*/, char *argv[])
{
    cout << "This is " << argv[0] << endl;

    runTestFunc(test_segmentIntersection);
    runTestFunc(test_Enemy_chooseRandomly);

    return success ? EXIT_SUCCESS : EXIT_FAILURE;
}
