# TRY_LINK_SDL_GFX
# Checks for the -lSDL_gfx library.
# Assumes that the AM_PATH_FLATZEBRA macro has already succeeded.
#
AC_DEFUN([TRY_LINK_SDL_GFX],
[
	# The flatzebra check checks for the SDL library.
	# Check also for the SDL_gfx library:
	#
	AC_MSG_CHECKING([for SDL_gfx])
	old_CXXFLAGS="$CXXFLAGS"
	old_LIBS="$LIBS"
	CXXFLAGS="$FLATZEBRA_FLAGS"
	LIBS="$FLATZEBRA_LIBS -lSDL_gfx"
	AC_TRY_LINK(
		[
			#include <SDL/SDL_gfxPrimitives.h>
		],
		[
			(void) filledCircleColor((SDL_Surface *) 0, 0, 0, 0, 0);
			return 0;
		],
		[
			AC_MSG_RESULT([found])
		],
		[
			AC_MSG_ERROR([SDL_gfx library not found])
		]
	)
	CXXFLAGS="$old_CXXFLAGS"
	LIBS="$old_LIBS"
])
