#include <unistd.h>
#include "buffer.h"
#include "strerr.h"
#include "uint16.h"
#include "byte.h"
#include "str.h"
#include "fmt.h"
#include "dns.h"
#include "ip4.h"
#include "stralloc.h"
#include "error.h"
#include "ipalloc.h"
#include "curveresolve.h"
#include "dns_mxip.h"

#define FATAL "showdnsmx: fatal: "

void nomem(void){strerr_die2x(111,FATAL,"out of memory");}

static char seed[128];

static stralloc fqdn;
char strnum[FMT_ULONG];
char str[IP4_FMT];

static ipalloc ip = {0};

int main(int argc,char **argv)
{
  long long i;

  dns_random_init(seed);

  if (*argv) ++argv;

  while (*argv) {
    if (!stralloc_copys(&fqdn,*argv)) nomem();
    if (dns_mxip(&ip,&fqdn,0) == -1)
      strerr_die4sys(111,FATAL,"unable to find MX records for ",*argv,": ");

    if (ip.len <= 0) {
        buffer_put(buffer_1,fqdn.s, fqdn.len);
        buffer_puts(buffer_1,": not exist\n");
    }
    else {

        for(i = 0; i < ip.len; ++i) {
            buffer_put(buffer_1,fqdn.s, fqdn.len);
            buffer_puts(buffer_1,": ");
            buffer_put(buffer_1,strnum,fmt_ulong(strnum,ip.ix[i].pref));
            buffer_puts(buffer_1," ");
            buffer_puts(buffer_1, ip.ix[i].name);
            buffer_puts(buffer_1," ");
            buffer_put(buffer_1,str,ip4_fmt(str,ip.ix[i].ip));
            if (ip.ix[i].haskey) {
                buffer_puts(buffer_1," ");
                buffer_puts(buffer_1, ip.ix[i].key);
                buffer_puts(buffer_1," ");
                buffer_puts(buffer_1, ip.ix[i].ext);
            }
            buffer_puts(buffer_1,"\n");
        }
    }
    ++argv;
  }
  buffer_flush(buffer_1);
  _exit(0);
}
