#!/usr/bin/python3.1

import socket, ssl, os, smtplib, errno, signal, sys, re, signal


def get_tb():
        """
        Format python traceback to string
        """

        from traceback  import extract_tb

        s = "Traceback (most recent call last):\n"

        type, value, tb = sys.exc_info()
        lines = extract_tb(tb)

        for line in lines:
                s = "%s  File \"%s\", line %d, in %s\n    %s\n" % (s, line[0], line[1], line[2], line[3])
        s = "%s%s: %s" % (s, type, value)

        return s




class QmailRemote:
        """
        """

        def __init__(self):
                """
                """

                timeout = os.getenv("TIMEOUT");
                if (not timeout):
                        self.timeout = 3600;
                else:
                        self.timeout = int(timeout)
                if (self.timeout > 3600):
                         self.timeout = 3600;
                if (self.timeout < 1):
                         self.timeout = 1;


                self.rfile = os.fdopen(6, "rb", 1024)
                self.wfile = os.fdopen(7, "wb", 1024)
                self.ifile = os.fdopen(0, "rb", 1024)
                self.sock  = None
                self.flagstarttls = False

                self.smtptext = []
                self.smtpline = []
                self.debug = True

                self.ehlo_size = False
                self.ehlo_starttls = False
                self.tlscipher = ""

                self.helohost = os.getenv("HELOHOST")
                if not self.helohost:
                        self.helohost = ""

                self.remoteip = os.getenv("REMOTEIP")
                if not self.remoteip:
                        self.remoteip = "0"

                signal.signal(signal.SIGPIPE, signal.SIG_IGN);
                signal.signal(signal.SIGALRM, self.sighandler)

                if (self._smtpcode() != 220):
                        self.error("ZConnected to %s but greeting failed" % (self.remoteip));

        def sighandler(self, signum, frame):
                """
                """

                self.die_dropped()

        def die_dropped(self):
                """
                """

                sys.stdout.write("ZConnected to %s but connection died. (#4.4.2)\n\0" % self.remoteip)
                sys.stdout.flush()
                sys.exit(0)

        def die_partialline(self):
                sys.stdout.write("DSMTP cannot transfer messages with partial final lines. (#5.6.2)\n\0")
                sys.stdout.flush()
                sys.exit(0)

        def die_read(self):
                sys.stdout.write("ZUnable to read message (#4.3.0)\n\0")
                sys.stdout.flush()
                sys.exit(0)

        def die_tls(self, e):
                sys.stdout.write("ZConnected to %s but TLS handhake failed: %s\n\0" % (self.remoteip, e));
                sys.stdout.flush()
                sys.exit(0)

        def _gettext(self):
                """
                """

                x = []

                for t in self.smtptext:
                        if t == ord("\n"):
                                x.append(ord("\\"))
                                t = ord("n")
                        if t == ord('\r'):
                                x.append(ord("\\"))
                                t = ord("r")
                        x.append(t)

                return bytes(x).decode()


        def _getch(self):
                """
                """

                while True:
                        c = b""
                        signal.alarm(self.timeout)
                        try:
                                c = self.rfile.read(1)
                        except IOError as e:
                                if e == errno.EINTR:
                                        continue
                        except Exception:
                                pass
                        signal.alarm(0)

                        if len(c) != 1:
                                self.die_dropped()

                        cc = ord(c)
                        if len(self.smtptext) < 5000:
                                self.smtptext.append(cc)
                        if len(self.smtpline) < 5000:
                                self.smtpline.append(cc)
                        return cc

        def _put(self, text = ""):
                """
                """

                if type(text) == type(""):
                        text = bytes(text, "ascii")

                signal.alarm(self.timeout)
                try:
                        self.wfile.write(text)
                except:
                        self.die_dropped()
                if not self.flagstarttls:
                        self.wfile.flush()
                signal.alarm(0)

                if self.debug:
                        sys.stderr.write("sent:     %s\n" % text)

        def _parseehlo(self):
                """
                """

                text = bytes(self.smtpline).decode("ascii")

                if text.find("SIZE ") != -1:
                        self.ehlo_size = True
                if text.find("STARTTLS") != -1:
                        self.ehlo_starttls = True


        def _smtpcode(self, p = False):
                """
                """

                self.smtptext = []
                self.smtpline = []
                code = 0

                ch = self._getch(); code = code * 10 + (ch - ord("0"))
                ch = self._getch(); code = code * 10 + (ch - ord("0"))
                ch = self._getch(); code = code * 10 + (ch - ord("0"))
                while True:
                        ch = self._getch()
                        if ch != ord("-"):
                                break;
                        if (p):
                                self.smtpline = []
                        while ch != ord("\n"):
                                ch = self._getch()
                        if (p):
                                self._parseehlo()
                        ch = self._getch()
                        ch = self._getch()
                        ch = self._getch()
                if (p):
                        self.smtpline = []
                while ch != ord("\n"):
                        ch = self._getch()
                if (p):
                        self._parseehlo()

                if self.debug:
                        sys.stderr.write("received: %s\n" % (self._gettext()))

                return code

        def quit(self):
                self._put("QUIT\r\n");
                if self.debug:
                        self._smtpcode()
                sys.stdout.write("K%s accepted message%s.\n%s\0" % (self.remoteip, self.tlscipher, bytes(self.smtptext).decode("ascii")));
                sys.stdout.flush()
                sys.exit(0)

        def error(self, s = ""):
                self._put("QUIT\r\n");
                sys.stdout.write(s)
                sys.stdout.write(".\n")
                sys.stdout.write(bytes(self.smtptext).decode("ascii"))
                sys.stdout.write("\0")
                sys.stdout.flush()
                sys.exit(0)

        def helo(self):
                """
                """

                self._put("EHLO %s\r\n" % self.helohost)
                if (self._smtpcode(True) != 250):
                        self._put("HELO %s\r\n" % self.helohost)
                        if (self._smtpcode() != 250):
                                self.error("ZConnected to %s but my name was rejected" % (self.remoteip));


        def starttls(self):
                """
                """

                if not self.ehlo_starttls:
                        return False


                self._put("STARTTLS\r\n")
                if (self._smtpcode() == 220):
                        signal.alarm(self.timeout)
                        os.dup2(7,6)
                        fd = socket.fromfd(6, socket.AF_INET, socket.SOCK_STREAM)
                        try:
                                #sock = ssl.wrap_socket(fd, keyfile=None, certfile=None, cert_reqs=ssl.CERT_REQUIRED, ca_certs="/etc/ssl/certs/ca-certificates.crt", ssl_version = ssl.PROTOCOL_TLSv1)
                                sock = ssl.wrap_socket(fd, keyfile=None, certfile=None, cert_reqs=ssl.CERT_NONE, ssl_version = ssl.PROTOCOL_TLSv1)
                        except (ssl.SSLError, CertificateError) as e:
                                self.die_tls(e)

                        try:
                                self.tlscipher = " using TLS %s" % sock.cipher()[0]
                        except:
                                self.tlscipher = " using TLS"

                        self.flagstarttls = True
                        self.rfile = sock
                        self.wfile = sock
                        signal.alarm(0)
                        return True
                return False

        def mailfrom(self, text = ""):
                """
                """

                size = None
                if self.ehlo_size:
                        try:
                                size = os.fstat(0).st_size
                        except:
                                pass

                if size:
                        self._put("MAIL FROM:<%s> SIZE=%d\r\n" % (text, size))
                else:
                        self._put("MAIL FROM:<%s>\r\n" % text)
                code = self._smtpcode();
                if (code >= 500):
                        self.error("DConnected to %s but sender was rejected" % (self.remoteip));
                if (code >= 400):
                        self.error("ZConnected to %s but sender was rejected" % (self.remoteip));

        def rcptto(self, tolist = []):
                """
                """

                flagbother = False
                for to in tolist:
                        self._put("RCPT TO:<%s>\r\n" % to)
                        code = self._smtpcode();
                        if (code >= 500):
                                sys.stdout.write("h%s does not like recipient.\n%s\0" % (self.remoteip, bytes(self.smtptext).decode("ascii")))
                        elif (code >= 400):
                                sys.stdout.write("s%s does not like recipient.\n%s\0" % (self.remoteip, bytes(self.smtptext).decode("ascii")))
                        else:
                                sys.stdout.write("r\0")
                                flagbother = True
                        sys.stdout.flush()
                if (not flagbother):
                        self.error("DGiving up on %s" % (self.remoteip));


        def _blast(self):
                """
                """

                dd = []

                while True:
                        try:
                                c = self.ifile.read(1)
                        except:
                                self.die_read()
                        if len(c) == 0:
                                break
                        cc = ord(c)

                        if cc == ord("."):
                                dd.append(ord("."))

                        while cc != ord("\n"):
                                dd.append(cc)
                                try:
                                        c = self.ifile.read(1)
                                except:
                                        self.die_read()
                                if len(c) == 0:
                                        self.die_partialline()
                                cc = ord(c)
                        dd.append(ord("\r"))
                        dd.append(ord("\n"))
                dd.append(ord("."))
                dd.append(ord("\r"))
                dd.append(ord("\n"))
                self._put(bytes(dd))
                                


        def data(self):
                """
                """

                self._put("DATA\r\n")
                code = self._smtpcode();
                if (code >= 500):
                        self.error("D%s failed on DATA command" % (self.remoteip));
                if (code >= 400):
                        self.error("Z%s failed on DATA command" % (self.remoteip));

                self._blast()
                code = self._smtpcode();
                if (code >= 500):
                        self.error("D%s failed after I sent the message" % (self.remoteip));
                if (code >= 400):
                        self.error("Z%s failed after I sent the message" % (self.remoteip));



if __name__ == '__main__':

        if len(sys.argv) < 3:
                sys.stdout.write("DI (qmail-rsmtp) was invoked improperly. (#5.3.5)\n\0")
                sys.stdout.flush()
                sys.exit(0)

        try:
                q = QmailRemote()
                q.helo()
                if q.starttls():
                        q.helo()
                q.mailfrom(sys.argv[1])
                q.rcptto(sys.argv[2:])
                q.data()
                q.quit()

        except Exception as e:
                sys.stdout.write("Zfailed unexpectedly\n%s\0" % (get_tb()));
                sys.stdout.flush()
                sys.exit(0)
        sys.exit(0)

