/* Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* $Id: bsd-waitpid.h,v 1.2 2001/02/09 01:55:36 djm Exp $ */

#ifndef _BSD_WAITPID_H
#define _BSD_WAITPID_H

#ifndef HAVE_WAITPID
/* Clean out any potental issues */
#undef WIFEXITED
#undef WIFSTOPPED
#undef WIFSIGNALED

/* Define required functions to mimic a POSIX look and feel */
#define _W_INT(w)       (*(int*)&(w))   /* convert union wait to int */
#define WIFEXITED(w)    (!((_W_INT(w)) & 0377))
#define WIFSTOPPED(w)   ((_W_INT(w)) & 0100)
#define WIFSIGNALED(w)  (!WIFEXITED(w) && !WIFSTOPPED(w))
#define WEXITSTATUS(w)  (int)(WIFEXITED(w) ? ((_W_INT(w) >> 8) & 0377) : -1)
#define WTERMSIG(w)     (int)(WIFSIGNALED(w) ? (_W_INT(w) & 0177) : -1)
#define WCOREFLAG       0x80
#define WCOREDUMP(w)    ((_W_INT(w)) & WCOREFLAG)

/* Prototype */
pid_t waitpid(int pid, int *stat_loc, int options);

#endif /* !HAVE_WAITPID */
#endif /* _BSD_WAITPID_H */



