#!/bin/sh
# This file is automatically generated by fs-package

set -e

DIR=$1
BUNDLE_NAME=$2
EXECUTABLE=$3
BUNDLE_ID=$4

TEMP_BUNDLE=fsbuild/_build/temp.app

echo "Creating temporary framework at $TEMP_BUNDLE"
rm -Rf $TEMP_BUNDLE
mkdir -p $TEMP_BUNDLE
echo "Move $DIR/$EXECUTABLE.dylib -> $TEMP_BUNDLE/$BUNDLE_NAME"
mv $DIR/$EXECUTABLE.dylib $TEMP_BUNDLE/$BUNDLE_NAME

echo "Writing Info.plist"
mkdir -p $TEMP_BUNDLE/Resources
P=$TEMP_BUNDLE/Resources/Info.plist
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" >> $P
echo "<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">" >> $P
echo "<plist version=\"1.0\">" >> $P
echo "<dict>" >> $P
echo "<key>CFBundleDevelopmentRegion</key>" >> $P
echo "<string>English</string>" >> $P
echo "<key>CFBundleExecutable</key>" >> $P
echo "<string>$BUNDLE_NAME</string>" >> $P
echo "<key>CFBundleIdentifier</key>" >> $P
echo "<string>$BUNDLE_ID</string>" >> $P
echo "<key>CFBundleInfoDictionaryVersion</key>" >> $P
echo "<string>6.0</string>" >> $P
echo "<key>CFBundleName</key>" >> $P
echo "<string>$BUNDLE_NAME</string>" >> $P
echo "<key>CFBundlePackageType</key>" >> $P
echo "<string>FMWK</string>" >> $P
echo "<key>CFBundleShortVersionString</key>" >> $P
echo "<string>1.0.0</string>" >> $P
echo "<key>CFBundleSignature</key>" >> $P
echo "<string>????</string>" >> $P
echo "<key>CFBundleVersion</key>" >> $P
echo "<string>1.0.0</string>" >> $P
echo "</dict>" >> $P
echo "</plist>" >> $P

echo "Moving $TEMP_BUNDLE -> $DIR/$BUNDLE_NAME.framework"
mv $TEMP_BUNDLE $DIR/$BUNDLE_NAME.framework
