import CoreServices
from PyObjCTools.TestSupport import TestCase


class TestMachineExceptions(TestCase):
    def assert_not_wrapped(self, name):
        self.assertTrue(
            not hasattr(CoreServices, name), f"{name!r} exposed in bindings"
        )

    def test_not_wrapped(self):
        self.assert_not_wrapped("AreaID")
        self.assert_not_wrapped("MachineInformationPowerPC")
        self.assert_not_wrapped("RegisterInformationPowerPC")
        self.assert_not_wrapped("FPUInformationPowerPC")
        self.assert_not_wrapped("Vector128")
        self.assert_not_wrapped("VectorInformationPowerPC")
        self.assert_not_wrapped("kWriteReference")
        self.assert_not_wrapped("kReadReference")
        self.assert_not_wrapped("kFetchReference")
        self.assert_not_wrapped("writeReference")
        self.assert_not_wrapped("readReference")
        self.assert_not_wrapped("fetchReference")
        self.assert_not_wrapped("MemoryExceptionInformation")
        self.assert_not_wrapped("kUnknownException")
        self.assert_not_wrapped("kIllegalInstructionException")
        self.assert_not_wrapped("kTrapException")
        self.assert_not_wrapped("kAccessException")
        self.assert_not_wrapped("kUnmappedMemoryException")
        self.assert_not_wrapped("kExcludedMemoryException")
        self.assert_not_wrapped("kReadOnlyMemoryException")
        self.assert_not_wrapped("kUnresolvablePageFaultException")
        self.assert_not_wrapped("kPrivilegeViolationException")
        self.assert_not_wrapped("kTraceException")
        self.assert_not_wrapped("kInstructionBreakpointException")
        self.assert_not_wrapped("kDataBreakpointException")
        self.assert_not_wrapped("kIntegerException")
        self.assert_not_wrapped("kFloatingPointException")
        self.assert_not_wrapped("kStackOverflowException")
        self.assert_not_wrapped("kTaskTerminationException")
        self.assert_not_wrapped("kTaskCreationException")
        self.assert_not_wrapped("kDataAlignmentException")
        self.assert_not_wrapped("unknownException")
        self.assert_not_wrapped("illegalInstructionException")
        self.assert_not_wrapped("trapException")
        self.assert_not_wrapped("accessException")
        self.assert_not_wrapped("unmappedMemoryException")
        self.assert_not_wrapped("excludedMemoryException")
        self.assert_not_wrapped("readOnlyMemoryException")
        self.assert_not_wrapped("unresolvablePageFaultException")
        self.assert_not_wrapped("privilegeViolationException")
        self.assert_not_wrapped("traceException")
        self.assert_not_wrapped("instructionBreakpointException")
        self.assert_not_wrapped("dataBreakpointException")
        self.assert_not_wrapped("integerException")
        self.assert_not_wrapped("floatingPointException")
        self.assert_not_wrapped("stackOverflowException")
        self.assert_not_wrapped("terminationException")
        self.assert_not_wrapped("kTerminationException")
        self.assert_not_wrapped("ExceptionInfo")
        self.assert_not_wrapped("ExceptionInformationPowerPC")
        self.assert_not_wrapped("ExceptionInformation")
        self.assert_not_wrapped("MachineInformation")
        self.assert_not_wrapped("RegisterInformation")
        self.assert_not_wrapped("FPUInformation")
        self.assert_not_wrapped("VectorInformation")
        self.assert_not_wrapped("Vector128Intel")
        self.assert_not_wrapped("MachineInformationIntel")
        self.assert_not_wrapped("RegisterInformationIntel")
        self.assert_not_wrapped("FPUInformationIntel")
        self.assert_not_wrapped("VectorInformationIntel")
        self.assert_not_wrapped("MachineInformation")
        self.assert_not_wrapped("RegisterInformation")
        self.assert_not_wrapped("FPUInformation")
        self.assert_not_wrapped("VectorInformation")
        self.assert_not_wrapped("MachineInformationIntel64")
        self.assert_not_wrapped("RegisterInformationIntel64")
        self.assert_not_wrapped("FPUInformationIntel64")
        self.assert_not_wrapped("VectorInformationIntel64")
        self.assert_not_wrapped("MachineInformation")
        self.assert_not_wrapped("RegisterInformation")
        self.assert_not_wrapped("FPUInformation")
        self.assert_not_wrapped("VectorInformation")
        self.assert_not_wrapped("ExceptionInformation")
        self.assert_not_wrapped("NewExceptionHandlerUPP")
        self.assert_not_wrapped("DisposeExceptionHandlerUPP")
        self.assert_not_wrapped("InvokeExceptionHandlerUPP")
        self.assert_not_wrapped("NewExceptionHandlerUPP")
        self.assert_not_wrapped("DisposeExceptionHandlerUPP")
        self.assert_not_wrapped("InvokeExceptionHandlerUPP")
        self.assert_not_wrapped("InstallExceptionHandler")
