# CHANGELOG


## Unreleased

### Unknown

* Delete duplicate CODEOWNERS (#156)

we have a codeowners file in root already ([`b64cdde`](https://github.com/madpah/serializable/commit/b64cdde6d4561355f7b92416dfcb36a8ff770be5))



## v2.0.0-alpha.1 (2025-01-16)

### Breaking

* refactor!: rename installable `serializable` -&gt; `py_serializable`

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`39bfc1a`](https://github.com/madpah/serializable/commit/39bfc1a3f20efdb75be3b14e9bfa845dc1f62142))

### Chore

* chore: Create CODEOWNERS ([`960331a`](https://github.com/madpah/serializable/commit/960331ad5181b64afa140d1fd0d2d59b687d782b))

* chore(deps-dev): update mypy requirement from 1.13.0 to 1.14.1 (#154)

Updates the requirements on [mypy](https://github.com/python/mypy) to permit the latest version.
- [Changelog](https://github.com/python/mypy/blob/master/CHANGELOG.md)
- [Commits](https://github.com/python/mypy/compare/v1.13.0...v1.14.1)

---
updated-dependencies:
- dependency-name: mypy
  dependency-type: direct:development
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt;
Co-authored-by: dependabot[bot] &lt;49699333+dependabot[bot]@users.noreply.github.com&gt; ([`afe70c8`](https://github.com/madpah/serializable/commit/afe70c81e20ac678bfeaedd2588083d5ba4ab4d5))

* chore(deps-dev): update flake8-bugbear requirement (#150)

Updates the requirements on [flake8-bugbear](https://github.com/PyCQA/flake8-bugbear) to permit the latest version.
- [Release notes](https://github.com/PyCQA/flake8-bugbear/releases)
- [Commits](https://github.com/PyCQA/flake8-bugbear/compare/24.10.31...24.12.12)

---
updated-dependencies:
- dependency-name: flake8-bugbear
  dependency-type: direct:development
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt;
Co-authored-by: dependabot[bot] &lt;49699333+dependabot[bot]@users.noreply.github.com&gt; ([`cb8a91b`](https://github.com/madpah/serializable/commit/cb8a91b6c5a42f5a46379adc272ec8fa4cc2cc37))

* chore(deps-dev): update flake8-bugbear requirement (#146)

Updates the requirements on [flake8-bugbear](https://github.com/PyCQA/flake8-bugbear) to permit the latest version.
- [Release notes](https://github.com/PyCQA/flake8-bugbear/releases)
- [Commits](https://github.com/PyCQA/flake8-bugbear/compare/24.8.19...24.10.31)

---
updated-dependencies:
- dependency-name: flake8-bugbear
  dependency-type: direct:development
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt;
Co-authored-by: dependabot[bot] &lt;49699333+dependabot[bot]@users.noreply.github.com&gt; ([`f6574e7`](https://github.com/madpah/serializable/commit/f6574e757695a4afc6922138a5e3cc8bdade2142))

* chore(deps-dev): update mypy requirement from 1.12.0 to 1.13.0 (#145)

Updates the requirements on [mypy](https://github.com/python/mypy) to permit the latest version.
- [Changelog](https://github.com/python/mypy/blob/master/CHANGELOG.md)
- [Commits](https://github.com/python/mypy/compare/v1.12.0...v1.13.0)

---
updated-dependencies:
- dependency-name: mypy
  dependency-type: direct:development
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt;
Co-authored-by: dependabot[bot] &lt;49699333+dependabot[bot]@users.noreply.github.com&gt; ([`c5117ba`](https://github.com/madpah/serializable/commit/c5117ba0ef716b8cc7a3f1d639df585bba36f5e3))

* chore(deps-dev): update mypy requirement from 1.11.2 to 1.12.0 (#143)

Updates the requirements on [mypy](https://github.com/python/mypy) to permit the latest version.
- [Changelog](https://github.com/python/mypy/blob/master/CHANGELOG.md)
- [Commits](https://github.com/python/mypy/compare/v1.11.2...v1.12.0)

---
updated-dependencies:
- dependency-name: mypy
  dependency-type: direct:development
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt;
Co-authored-by: dependabot[bot] &lt;49699333+dependabot[bot]@users.noreply.github.com&gt; ([`6c354e2`](https://github.com/madpah/serializable/commit/6c354e2ef3ec276d624553e29adb705c9d9f33ec))

### Unknown

* Merge branch &#39;main&#39; into refactor/rename-installable-py_serializable ([`5b62208`](https://github.com/madpah/serializable/commit/5b622084eb016765096679451ce15801c45d707d))

* Delete duplicate CODEOWNERS (#156)

we have a codeowners file in root already ([`b64cdde`](https://github.com/madpah/serializable/commit/b64cdde6d4561355f7b92416dfcb36a8ff770be5))

* docs

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`e3708ec`](https://github.com/madpah/serializable/commit/e3708ec0fbd23a3705a5fe49c8a31293bbf7446f))

* docs

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`225b614`](https://github.com/madpah/serializable/commit/225b614346f89a04cce759fc617a42d647f8a4a9))

* docs

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`a581861`](https://github.com/madpah/serializable/commit/a58186100361e48135b630a42bc5b5929af3dd15))

* docs

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`2df3e21`](https://github.com/madpah/serializable/commit/2df3e21012fc9499bf47236fb85925394b3bfc2d))

* style

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`42cf87b`](https://github.com/madpah/serializable/commit/42cf87bb30c4cf2d19eba4a86c20fa198ff48208))


## v1.1.2 (2024-10-01)

### Fix

* fix: date/time deserialization with fractional seconds (#138)

fix multiple where fractional seconds were not properly deserialized or deserialization caused unexpected crashes in py&lt;3.11

---------

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt;
Co-authored-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`f4b1c27`](https://github.com/madpah/serializable/commit/f4b1c27110d1becc76771efffd8dc0a96d629cb5))


## v1.1.1 (2024-09-16)

### Fix

* fix: serializer omit `None` values as expected (#136)



Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`1a0e14b`](https://github.com/madpah/serializable/commit/1a0e14b8ee0866621a388a09e41c7f173e874e25))


## v1.1.0 (2024-07-08)

### Documentation

* docs: fix links (#122)

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`aabb5e9`](https://github.com/madpah/serializable/commit/aabb5e925b5630a02f99dcf07064ddfb65c9064e))

### Feature

* feat: XML string formats for `normalizedString` and `token` (#119)

fixes #114 
fixes #115 

---------

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`3a1728d`](https://github.com/madpah/serializable/commit/3a1728d43a13e57ecad2b3feebadf1d9fdc132c3))


## v1.0.3 (2024-04-04)

### Fix

* fix: support deserialization of XML flat arrays where `child_name` does not conform to current formatter #89 (#90)

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`ade5bd7`](https://github.com/madpah/serializable/commit/ade5bd76cf945b7380dbeac5e6233417da2d26c6))


## v1.0.2 (2024-03-01)

### Build

* build: use poetry v1.8.1 (#81)

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`46a8d9e`](https://github.com/madpah/serializable/commit/46a8d9e629ac502864a99acaa9418d1c5cd32388))


## v1.0.1 (2024-02-13)

### Fix

* fix: serialization of `datetime` without timezone with local time offset (#76)



Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`06776ba`](https://github.com/madpah/serializable/commit/06776baef2cc4b893550320c474128317f6276c1))


## v1.0.0 (2024-01-22)

### Breaking

* feat!: v1.0.0 (#55)

  **Release of first major version 🎉**

  ## BREAKING Changes
  * Dropped support for python &lt;3.8

---------

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`2cee4d5`](https://github.com/madpah/serializable/commit/2cee4d5f48d59a737f4fc7b0e3d26fbce33c2392))

### Documentation

* docs: fix conda link/url

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`5645ca6`](https://github.com/madpah/serializable/commit/5645ca65763198a166c348172cc29147881ad6f2))


## v0.17.1 (2024-01-07)

### Documentation

* docs: add &#34;documentation&#34; url to project meta

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`bf864d7`](https://github.com/madpah/serializable/commit/bf864d75d8a12426d4c71ae9ea1f533e730bd54e))

* docs: add &#34;documentation&#34; url to project meta

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`d3bcc42`](https://github.com/madpah/serializable/commit/d3bcc4258ab8cdf6c9e09b47985997cafdc19e9a))

### Fix

* fix: log placeholder (#60) ([`3cc6cad`](https://github.com/madpah/serializable/commit/3cc6cadad27a86b46ca576540f89a15f0f8fc1cd))

### Unknown

* 0.17.1

chore(release): 0.17.1

Automatically generated by python-semantic-release ([`3b50104`](https://github.com/madpah/serializable/commit/3b501047671da16b6543abc4208d11e61c87b3d9))

* Create SECURITY.md ([`9cdc0b1`](https://github.com/madpah/serializable/commit/9cdc0b1a176b432fd12adbf0379e61a257d3e3ba))


## v0.17.0 (2024-01-06)

### Documentation

* docs: modernixe read-the-docs

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`7ae6aad`](https://github.com/madpah/serializable/commit/7ae6aad3b5939508238d1502c116866ef79949cb))

* docs: homepage (#48)

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`de206d6`](https://github.com/madpah/serializable/commit/de206d6083be643a58f08554b61518367f67cda1))

* docs: condaforge (#46)

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`c0074ce`](https://github.com/madpah/serializable/commit/c0074ce911f66bc6de0a451b8922f80f1ffa6270))

### Feature

* feat: logger (#47)

Reworked the way this library does  logging/warning. It utilizes the logger named `serializable` for everything, now.

---------

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt;
Co-authored-by: Kyle Roeschley &lt;kyle.roeschley@ni.com&gt; ([`9269b0e`](https://github.com/madpah/serializable/commit/9269b0e681665abaef3f110925cd098b2438880f))

### Unknown

* 0.17.0

chore(release): 0.17.0

Automatically generated by python-semantic-release ([`a6fc788`](https://github.com/madpah/serializable/commit/a6fc78853e13a3c7e922c7e95ef7cbbaa4bf3b1d))


## v0.16.0 (2023-11-29)

### Feature

* feat: more controll over XML attribute serialization (#34)

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`38f42d6`](https://github.com/madpah/serializable/commit/38f42d64e556a85206faa50459a9ce3e889bd3ae))

### Unknown

* 0.16.0

chore(release): 0.16.0

Automatically generated by python-semantic-release ([`b444fd7`](https://github.com/madpah/serializable/commit/b444fd721102caaa51d0854fc6f6408e919a77d5))


## v0.15.0 (2023-10-10)

### Feature

* feat: allow custom (de)normalization (#32)


Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`aeecd6b`](https://github.com/madpah/serializable/commit/aeecd6b2e8c4e8febc84ebfa24fe7ec96fd9cb10))

### Unknown

* 0.15.0

chore(release): 0.15.0

Automatically generated by python-semantic-release ([`e80c514`](https://github.com/madpah/serializable/commit/e80c5146621e9ed1bfbe2118e36c269aa4cacdb8))


## v0.14.1 (2023-10-08)

### Fix

* fix: JSON deserialize `Decimal` (#31)



Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`b6dc66a`](https://github.com/madpah/serializable/commit/b6dc66acfb7fdc82b3dd18caf4ad79ec0e87eef0))

### Unknown

* 0.14.1

chore(release): 0.14.1

Automatically generated by python-semantic-release ([`0183a17`](https://github.com/madpah/serializable/commit/0183a174b5b9e402f20e3e240e565b124f2b008b))


## v0.14.0 (2023-10-06)

### Feature

* feat: enhanced typehints and typing (#27)

Even tough some structures are refactored, no public API is changed.
No runtime is changed.
TypeCheckers might behave differently, which is intentional due to bug fixes. This is considered a non-breaking change, as it does not affect runtime. 

---------

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`410372a`](https://github.com/madpah/serializable/commit/410372a0fa2713c5a36d790f08d2d4b52a6a187c))

### Unknown

* 0.14.0

chore(release): 0.14.0

Automatically generated by python-semantic-release ([`7bb0d1b`](https://github.com/madpah/serializable/commit/7bb0d1b0fcf5b63770c214ec6e784f1f6ba94f58))


## v0.13.1 (2023-10-06)

### Documentation

* docs: add examples to docs (#28)

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`4eddb24`](https://github.com/madpah/serializable/commit/4eddb242e51194694474748acdecd38b317b791e))

* docs: remove unnecessary type-ignores

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`26c561d`](https://github.com/madpah/serializable/commit/26c561dc0bf9f5755899a8fa0d0a37aba6275074))

* docs: remove unnecessary type-ignores

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`11b5896`](https://github.com/madpah/serializable/commit/11b5896057fd61838804ea5b52dc3bd0810f6c88))

### Fix

* fix: protect default value for `serialization_types` from unintended downstream modifications (#30)

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`0e814f5`](https://github.com/madpah/serializable/commit/0e814f5248176e02a7f96480e54320dde781f8b2))

### Unknown

* 0.13.1

chore(release): 0.13.1

Automatically generated by python-semantic-release ([`bd604c8`](https://github.com/madpah/serializable/commit/bd604c800e1a9ab6101ee8b7b810e92e6288de8b))


## v0.13.0 (2023-10-01)

### Feature

* feat: format specific (de)serialize (#25)

Added functionality to implement custom (de)serialization specific for XML or JSON ([#13](https://github.com/madpah/serializable/issues/13)).


Changed
-------------
* Class `BaseHelper` is no longer abstract.  
  This class does not provide any functionality, it is more like a Protocol with some fallback implementations.
* Method `BaseHelper.serialize()` is no longer abstract.
  Will raise `NotImplementedError` per default. 
* Method `BaseHelper.deserialize()` is no longer abstract.
  Will raise `NotImplementedError` per default. 

Added
----------
* New method `BaseHelper.json_serialize()` predefined.  
  Will call `cls.serialize()` per default. 
* New method `BaseHelper.json_deserialize()` predefined.  
  Will call `cls.deserialize()` per default. 



----


Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`dc998df`](https://github.com/madpah/serializable/commit/dc998df37a2ba37fa43d10c8a1ce044a5b9f5b1e))

### Unknown

* 0.13.0

chore(release): 0.13.0

Automatically generated by python-semantic-release ([`c1670d6`](https://github.com/madpah/serializable/commit/c1670d60e7f7adb0fd0f6be2f7cac89fff9315d9))


## v0.12.1 (2023-10-01)

### Build

* build: semantic-release sets library version everywhere (#16)

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`296ef19`](https://github.com/madpah/serializable/commit/296ef196e8801b244843814d2d510f1e7d2044d4))

### Documentation

* docs: render only public API (#19)

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`fcc5d8e`](https://github.com/madpah/serializable/commit/fcc5d8e6c49e8b8c199cb55f855d09e4259a075a))

* docs: set codeblock language and caption (#15)



Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`5d5cf7b`](https://github.com/madpah/serializable/commit/5d5cf7bc29ed70f4024c714b2326012a9db54cea))

### Fix

* fix: xml defaultNamespace serialization and detection (#20)

* fixes:  serialization with defaultNS fails [#12](https://github.com/madpah/serializable/issues/12)
* fixes: defaultNamespace detection fails on XML-attributes when deserializing [#11](https://github.com/madpah/serializable/issues/11)

---------

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`59eaa5f`](https://github.com/madpah/serializable/commit/59eaa5f28eb2969e9d497669ef0436eb87b7525d))

### Unknown

* 0.12.1

chore(release): 0.12.1

Automatically generated by python-semantic-release ([`9a2798d`](https://github.com/madpah/serializable/commit/9a2798d23de90ed36a4aecb4ec955cbe037a4089))

* bump to python-semantic-release/python-semantic-release@v7.34.6

Signed-off-by: Jan Kowalleck &lt;jan.kowalleck@gmail.com&gt; ([`68d229e`](https://github.com/madpah/serializable/commit/68d229e62d049713ade8e08487f491683b0bb0f9))

* Merge pull request #7 from claui/fix-top-level-license

Keep `LICENSE` in `.dist-info` when building wheel ([`9bc4abc`](https://github.com/madpah/serializable/commit/9bc4abccc9cabed5f9808101a8d25717b86f01b4))

* Keep `LICENSE` in `.dist-info` when building wheel

Poetry automatically detects and includes `LICENSE` files in
`….dist-info/` when it builds a wheel.

If `LICENSE` is also declared as a pattern in Poetry’s `include` list in
`pyproject.toml`, then the file will appear in the root directory of the
wheel, too:

```plain
Path = /var/lib/aurbuild/x86_64/claudia/build/python-py-serializable/src/serializable-0.12.0/dist/py_serializable-0.12.0-py3-none-any.whl
Type = zip
Physical Size = 22557

   Date      Time    Attr         Size   Compressed  Name
------------------- ----- ------------ ------------  ------------------------
1980-01-01 00:00:00 .....        11357         3948  LICENSE
1980-01-01 00:00:00 .....        52795         9275  serializable/__init__.py
1980-01-01 00:00:00 .....         3382          923  serializable/formatters.py
1980-01-01 00:00:00 .....         3690         1180  serializable/helpers.py
1980-01-01 00:00:00 .....          153          117  serializable/py.typed
1980-01-01 00:00:00 .....        11357         3948  py_serializable-0.12.0.dist-info/LICENSE
1980-01-01 00:00:00 .....         3845         1449  py_serializable-0.12.0.dist-info/METADATA
1980-01-01 00:00:00 .....           88           85  py_serializable-0.12.0.dist-info/WHEEL
2016-01-01 00:00:00 .....          718          408  py_serializable-0.12.0.dist-info/RECORD
------------------- ----- ------------ ------------  ------------------------
2016-01-01 00:00:00              87385        21333  9 files
```

Note how the wheel contains two identical copies of your `LICENSE` file:
one copy in the `….dist-info/` directory, picked up automatically by
Poetry, and a second copy in the root directory of the wheel.

Including a generically-named file directly in a wheel’s root directory
may cause problems:

1. The `LICENSE` file is going to turn up at the top level of
   `site-packages` directly. That’s misleading, because anyone who’d
   browse `site-packages` might conclude that the license be valid for
   all packages, not just `serializable`, which is incorrect.

2. Having generic files at the top level of `site-packages` causes
   conflicts with other wheels that happen to include the same file.
   For example, I’ve had `LICENSE` files coming from two different
   wheels, excluding `serializable`, sitting at the top level of my
   `site-packages` directory so I could install only one of them.

The fix is to remove the `LICENSE` pattern from the `include` list.
Poetry automatically picks up files named `LICENSE`, and drops them
either into an sdist’s root directory (when building an sdist)  or into
`py_serializable-[version].dist-info/` (when building a wheel).

Signed-off-by: Claudia &lt;claui@users.noreply.github.com&gt; ([`31e4003`](https://github.com/madpah/serializable/commit/31e4003e949b73a4cd7c18aac458200888c1a0f2))

* Merge branch &#39;main&#39; of github.com:madpah/serializable ([`c1e8fd8`](https://github.com/madpah/serializable/commit/c1e8fd840b9e89c36f36304342cc6f9be8cc7d26))


## v0.12.0 (2023-03-07)

### Feature

* feat: bump dev dependencies to latest (including `mypy` fixes)

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`06dcaa2`](https://github.com/madpah/serializable/commit/06dcaa28bfebb4505ddc67b287dc6f416822ffb6))

* feat: bump dev dependencies to latest (including `mypy` fixes)

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`6d70287`](https://github.com/madpah/serializable/commit/6d70287640c411d33823e9188b0baa81fba80c24))

### Unknown

* 0.12.0

Automatically generated by python-semantic-release ([`fa9f9b3`](https://github.com/madpah/serializable/commit/fa9f9b39a13120a0b8d47b4fdb9469c2aa642cb6))

* Merge pull request #6 from madpah/fix/dep-updates

feat: bump dev dependencies to latest (including `mypy` fixes) ([`08b4825`](https://github.com/madpah/serializable/commit/08b48253bacc62f8a0db54510bf6fe49df68a19f))


## v0.11.1 (2023-03-03)

### Fix

* fix: use `defusedxml` whenever we load XML to prevent XEE attacks ([`ae3d76c`](https://github.com/madpah/serializable/commit/ae3d76c31ab8af81d20acaaba45fd4bb9aad9305))

* fix: use `defusedxml` whenever we load XML to prevent XEE attacks

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`32fd5a6`](https://github.com/madpah/serializable/commit/32fd5a698b41b489b4643bcbe795e24a1e0db423))

* fix: use `defusedxml` whenever we load XML to prevent XEE attacks

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`72e0127`](https://github.com/madpah/serializable/commit/72e01279274246313170e5e7c9d32afec16edf7c))

* fix: use `defusedxml` whenever we load XML to prevent XEE attacks

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`de61deb`](https://github.com/madpah/serializable/commit/de61deb5c2447a656ca6a111194b2b0ceeab9278))

* fix: use `defusedxml` whenever we load XML to prevent XEE attacks

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`de26dc3`](https://github.com/madpah/serializable/commit/de26dc3d0eaab533dac9b1db40f0add56dd67754))

### Unknown

* 0.11.1

Automatically generated by python-semantic-release ([`0bdccc4`](https://github.com/madpah/serializable/commit/0bdccc4a1a4b7fb74f2ea54898e5c08d133f6490))


## v0.11.0 (2023-03-03)

### Feature

* feat: disabled handling to avoid class attributes that clash with `keywords` and `builtins`

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`4439227`](https://github.com/madpah/serializable/commit/44392274628ddec4aaaeae89a8387d435e3cf002))

### Unknown

* 0.11.0

Automatically generated by python-semantic-release ([`90de3b8`](https://github.com/madpah/serializable/commit/90de3b89974aafd39b6b386e0647989c65845e67))

* define `commit_author`?

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`4fad001`](https://github.com/madpah/serializable/commit/4fad001f6c631e23af911bd78469ad1a1ed8d2f6))

* Merge branch &#39;main&#39; of github.com:madpah/serializable ([`fb46f04`](https://github.com/madpah/serializable/commit/fb46f0438ea81c62adc8bc360bee4b8a24816011))

* enable debug for release

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`2f4d626`](https://github.com/madpah/serializable/commit/2f4d6262a4038b7f3e4da3b0ffe10b6293bd2227))

* Merge pull request #4 from madpah/feat/allow-python-keywords

feat: disabled handling to avoid class attributes that clash with `keywords` and `builtins` ([`2a33bc6`](https://github.com/madpah/serializable/commit/2a33bc606e95995ae812e62c9018481c3353962f))

* cleanup

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`0ff402e`](https://github.com/madpah/serializable/commit/0ff402eb99e0073fa03ae0e19b881e352fbca2c7))


## v0.10.1 (2023-03-02)

### Fix

* fix: handle empty XML elements during deserialization

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`f806f35`](https://github.com/madpah/serializable/commit/f806f3521f0afd8978f94f5ec355f47d9a538b91))

### Unknown

* 0.10.1

Automatically generated by python-semantic-release ([`69e5866`](https://github.com/madpah/serializable/commit/69e586630931c088381bfd687a00b83b55d360f8))


## v0.10.0 (2023-02-21)

### Feature

* feat: ability for custom `type_mapping` to take lower priority than `xml_array`

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`fc0bb22`](https://github.com/madpah/serializable/commit/fc0bb22f395498be42394af5f70addb9f63f0b3a))

### Unknown

* 0.10.0

Automatically generated by python-semantic-release ([`58d42ad`](https://github.com/madpah/serializable/commit/58d42ad0455495ad5998694cbd487866d682fed3))

* Merge pull request #3 from madpah/feat/recursive-parsing-differing-schemas

feat: `xml_array` has higher priority than `type_mapping`

feat: handle `ForwardRef` types ([`664f947`](https://github.com/madpah/serializable/commit/664f947add279dad90ac9cf447a59059ab10d2cc))

* work to handle `ForwardRef` when we have cyclic references in models

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`a66e700`](https://github.com/madpah/serializable/commit/a66e700eeb5a80447522b8112ecdeff0345f0608))

* remove comment

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`6898b40`](https://github.com/madpah/serializable/commit/6898b40b6d55c70ade6e87de4a3cd4b8ce10a028))

* added test to prove https://github.com/CycloneDX/specification/issues/146 for https://github.com/CycloneDX/cyclonedx-python-lib/pull/290

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`2cfc44d`](https://github.com/madpah/serializable/commit/2cfc44ddc22d3ec5dc860d21297ab76b50102a74))


## v0.9.3 (2023-01-27)

### Fix

* fix: deserializing JSON with custom JSON name was incorrect

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`7d4aefc`](https://github.com/madpah/serializable/commit/7d4aefc98dfe39ae614227601369e9fd25c12faa))

### Unknown

* 0.9.3

Automatically generated by python-semantic-release ([`ccd610f`](https://github.com/madpah/serializable/commit/ccd610f7897e78478da7855095cf02580617340e))

* better logging for deserialization errors

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`a77452d`](https://github.com/madpah/serializable/commit/a77452d38e416aca59ef212379710c044885c383))

* added more logging

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`1f80c4b`](https://github.com/madpah/serializable/commit/1f80c4bb2390cbc5ebef87a8f32cc925f28bbde8))

* code style

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`8ca9e44`](https://github.com/madpah/serializable/commit/8ca9e44c479b35f0e599296b5e462dc87d9bf366))


## v0.9.2 (2023-01-27)

### Fix

* fix: nested array of Enum values in `from_json()` failed

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`ea4d76a`](https://github.com/madpah/serializable/commit/ea4d76a64c8c97f7cb0b16687f300c362dfe7623))

* fix: output better errors when deserializing JSON and we hit errors

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`1699c5b`](https://github.com/madpah/serializable/commit/1699c5b96bb6a8d4f034b29a6fe0521e3d650d53))

### Unknown

* 0.9.2

Automatically generated by python-semantic-release ([`435126c`](https://github.com/madpah/serializable/commit/435126c92032548944fe59243aa5935312ca7bfa))


## v0.9.1 (2023-01-26)

### Fix

* fix: nested array of Enum values in `from_xml()` failed

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`393a425`](https://github.com/madpah/serializable/commit/393a4256abb69228a9e6c2fc76b508e370a39d93))

### Unknown

* 0.9.1

Automatically generated by python-semantic-release ([`f4e018b`](https://github.com/madpah/serializable/commit/f4e018bf109c597ea70ce3a53a9d139aad926d2c))

* doc: added to docs to cover latest features and Views

fix: aligned View definition in unit tests with proper practice
Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`c7c66f7`](https://github.com/madpah/serializable/commit/c7c66f719b93a9fc2c3929db67d0f7ae0665be7a))


## v0.9.0 (2023-01-24)

### Feature

* feat: bring library to BETA state

feat: add support for Python 3.11
Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`c6c36d9`](https://github.com/madpah/serializable/commit/c6c36d911ae401af477bcc98633f10a87140d0a4))

### Unknown

* 0.9.0

Automatically generated by python-semantic-release ([`f5cb856`](https://github.com/madpah/serializable/commit/f5cb85629d6398956a4a1379e44bbd9a1f67d079))

* Merge pull request #2 from madpah/feat/support-py311

feat: bring library to BETA state &amp; add support Python 3.11 ([`33c6756`](https://github.com/madpah/serializable/commit/33c6756d145a15c9d62216acc11568838bf0d1a0))


## v0.8.2 (2023-01-23)

### Fix

* fix: typing for `@serializable.view` was incorrect

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`756032b`](https://github.com/madpah/serializable/commit/756032b543a2fedac1bb61f57796eea438c0f9a7))

* fix: typing for `@serializable.serializable_enum` decorator was incorrect

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`84e7826`](https://github.com/madpah/serializable/commit/84e78262276833f507d4e8a1ce11d4a82733f395))

### Unknown

* 0.8.2

Automatically generated by python-semantic-release ([`3332ed9`](https://github.com/madpah/serializable/commit/3332ed98ae9c9bfae40df743ad4c0ea83eac038b))

* Merge pull request #1 from madpah/fix/typing

fix: typing only ([`1860d4d`](https://github.com/madpah/serializable/commit/1860d4df369c8cf9cea917c025bb191fcd242f29))

* spacing

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`fdd5c8a`](https://github.com/madpah/serializable/commit/fdd5c8a344c3ace70170c91272074cbf6d0ebd01))


## v0.8.1 (2023-01-23)

### Fix

* fix: Specific None value per View - support for XML was missing

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`5742861`](https://github.com/madpah/serializable/commit/5742861728d1b371bc0a819fed0b12e9da5829e1))

### Unknown

* 0.8.1

Automatically generated by python-semantic-release ([`c6d9db8`](https://github.com/madpah/serializable/commit/c6d9db8665e8d2c368004d3167d450c5f2f93c28))


## v0.8.0 (2023-01-20)

### Feature

* feat: support for specific None values for Properties by View

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`a80ee35`](https://github.com/madpah/serializable/commit/a80ee3551c5e23f9c0491f48c3f98022317ddd99))

### Fix

* fix: minor typing and styling

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`b728c4c`](https://github.com/madpah/serializable/commit/b728c4c995076cd18317c878c6f5900c6b266425))

* fix: minor typing and styling

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`b2ebcfb`](https://github.com/madpah/serializable/commit/b2ebcfb53cd640eb70a51a9f637db24e0d7b367e))

### Unknown

* 0.8.0

Automatically generated by python-semantic-release ([`4ccdfc9`](https://github.com/madpah/serializable/commit/4ccdfc98b2275efc744de0188152fcdcc560e00f))


## v0.7.3 (2022-09-22)

### Fix

* fix: None value for JSON is now `None` (`null`)
fix: typing and coding standards

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`8b7f973`](https://github.com/madpah/serializable/commit/8b7f973cd96c861c4490c50553c880e88ebf33dc))

### Unknown

* 0.7.3

Automatically generated by python-semantic-release ([`8060db3`](https://github.com/madpah/serializable/commit/8060db392f47868bd61bcc333fad51cefd9d2e9f))

* Merge branch &#39;main&#39; of github.com:madpah/serializable ([`84f957b`](https://github.com/madpah/serializable/commit/84f957b815b2c641218bf7a5d422fa66e787b343))


## v0.7.2 (2022-09-22)

### Fix

* fix: missing namespace for empty XML elements

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`f3659ab`](https://github.com/madpah/serializable/commit/f3659ab9ea651dcd65168aa22fa838d35ee189d5))

### Unknown

* 0.7.2

Automatically generated by python-semantic-release ([`08698d1`](https://github.com/madpah/serializable/commit/08698d10b9b0350458fb079b1ee38e5c118588d7))


## v0.7.1 (2022-09-15)

### Fix

* fix: support forced inclusion of array properties by using `@serializable.include_none`

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`7ad0ecf`](https://github.com/madpah/serializable/commit/7ad0ecf08c5f56de4584f4f081bfc0f667d2f477))

* fix: support for deserializing to objects from a primitive value

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`12f9f97`](https://github.com/madpah/serializable/commit/12f9f9711a5fd924898a0afb50a24c8d360ab3ff))

### Unknown

* 0.7.1

Automatically generated by python-semantic-release ([`01743f2`](https://github.com/madpah/serializable/commit/01743f27db48bb6e896531f1708d11a53571284a))

* Merge branch &#39;main&#39; of github.com:madpah/serializable ([`eb82dbc`](https://github.com/madpah/serializable/commit/eb82dbc20d558a242620649a6ea8ea8df912283a))


## v0.7.0 (2022-09-14)

### Feature

* feat: support for including `None` values, restricted to certain Views as required

fix: tests, imports and formatting
Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`614068a`](https://github.com/madpah/serializable/commit/614068a4955f99d8fce5da341a1fd74a6772b775))

### Unknown

* 0.7.0

Automatically generated by python-semantic-release ([`4a007c0`](https://github.com/madpah/serializable/commit/4a007c0b3b2f22c4d26851267390909a01e8adf5))


## v0.6.0 (2022-09-14)

### Feature

* feat: implement views for serialization to JSON and XML

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`db57ef1`](https://github.com/madpah/serializable/commit/db57ef13fa89cc47db074bd9be4b48232842df07))

### Fix

* fix: support for `Decimal` in JSON serialization

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`cc2c20f`](https://github.com/madpah/serializable/commit/cc2c20fe8bce46e4854cb0eecc6702459cd2f99a))

* fix: better serialization to JSON

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`e8b37f2`](https://github.com/madpah/serializable/commit/e8b37f2ee4246794c6c0e295bcdf32cd58d5e52d))

### Unknown

* 0.6.0

Automatically generated by python-semantic-release ([`da20686`](https://github.com/madpah/serializable/commit/da20686207f0ca95f7da29cb07f27ecc018b5134))

* Merge branch &#39;main&#39; of github.com:madpah/serializable ([`86492e1`](https://github.com/madpah/serializable/commit/86492e1ff51f6ecd5dde28faf054777db13fe5b1))


## v0.5.0 (2022-09-12)

### Feature

* feat: support for string formatting of values

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`99b8f3e`](https://github.com/madpah/serializable/commit/99b8f3e7ab84f087a87b330928fc598c96a0e682))

* feat: support string formatting for values

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`3fefe22`](https://github.com/madpah/serializable/commit/3fefe2294130b80f05e219bd655514a0956f7f93))

* feat: support for custom Enum implementations

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`c3622fc`](https://github.com/madpah/serializable/commit/c3622fcb0019de794b1cbd3ad6333b6044d8392a))

### Unknown

* 0.5.0

Automatically generated by python-semantic-release ([`0ede79d`](https://github.com/madpah/serializable/commit/0ede79daabcf3ce3c6364e8abc27f321db654a90))

* Merge branch &#39;main&#39; of github.com:madpah/serializable ([`5a896c4`](https://github.com/madpah/serializable/commit/5a896c4f3162569e4e938cb4dd1e69275078f8ee))

* import order

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`a2a2ef8`](https://github.com/madpah/serializable/commit/a2a2ef86e2c9fe860453f755201507266c36daed))


## v0.4.0 (2022-09-06)

### Feature

* feat: add support for defining XML element ordering with `@serializable.xml_sequence()` decorator

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`c1442ae`](https://github.com/madpah/serializable/commit/c1442aeb1776243922fbaa6b5174db5a54f71920))

### Fix

* fix: removed unused dependencies

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`448a3c9`](https://github.com/madpah/serializable/commit/448a3c9f0de897cf1ee6d7c46af377c2f389730d))

* fix: handle python builtins and keywords during `as_xml()` for element names

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`3bbfb1b`](https://github.com/madpah/serializable/commit/3bbfb1b4a7808f4cedd3b2b15f31aaaf8e35d60a))

* fix: handle python builtins and keywords during `as_xml()` for attributes

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`8d6a96b`](https://github.com/madpah/serializable/commit/8d6a96b0850d4993c96cbc7d532d848ba9c5e8b3))

### Unknown

* 0.4.0

Automatically generated by python-semantic-release ([`3034bd1`](https://github.com/madpah/serializable/commit/3034bd1f817e2cc24c10da4c7d0a1d68120f1fee))

* python &lt; 3.8 typing

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`339e53c`](https://github.com/madpah/serializable/commit/339e53cbec9a441ef9ef6ecea9f037c9085b6855))

* removed unused import

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`8462634`](https://github.com/madpah/serializable/commit/84626342df1dd5d9aea8d4c469431a0b19cf0bb3))

* updated release CI

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`f4cf0fa`](https://github.com/madpah/serializable/commit/f4cf0fa4d6a9f3349647caeb94d18b97bc836606))

* typing

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`0f9cf68`](https://github.com/madpah/serializable/commit/0f9cf68db3e676a9e16124c371359ec60e2fc304))

* cleanup

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`95a864a`](https://github.com/madpah/serializable/commit/95a864a1f9c67ec073308fdc3e97b82ce81b5392))

* test alternative poetry installation in CI

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`8eb8704`](https://github.com/madpah/serializable/commit/8eb8704f7b14767897093183020b71f6672f86c4))

* test alternative poetry installation in CI

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`8705180`](https://github.com/madpah/serializable/commit/87051801d6718c2eb4dd380e91bc30b9684a6386))

* test alternative poetry installation in CI

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`fe3f56a`](https://github.com/madpah/serializable/commit/fe3f56a26a20be4f6ccd3ae100300c947bdecf70))

* test alternative poetry installation in CI

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`4e7a19f`](https://github.com/madpah/serializable/commit/4e7a19fc54c2e51f6b963a4e9d758d0d8824413c))

* test alternative poetry installation in CI

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`7d268db`](https://github.com/madpah/serializable/commit/7d268dbad701604946877ef8e3947f8b14210f7e))

* test alternative poetry installation in CI

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`02caa9e`](https://github.com/madpah/serializable/commit/02caa9e35d3ac3a3b961b09cb9665e9f27ab1371))

* test alternative poetry installation in CI

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`210d41d`](https://github.com/madpah/serializable/commit/210d41d39418cd58af62b2672233e743dbd4372f))

* force poetry cache clear

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`731d7ae`](https://github.com/madpah/serializable/commit/731d7ae51ac7bd1225af7d3c757042cac9f3ac9c))

* bump poetry to 1.1.12

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`90b8a92`](https://github.com/madpah/serializable/commit/90b8a92327741c5b8b91a7fb1ef1356febe53944))

* typing

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`3427f4b`](https://github.com/madpah/serializable/commit/3427f4b5b136183b524cda871fb49f9ab78a20a7))

* doc: added docs for `xml_sequence()` decorator

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`d2211c9`](https://github.com/madpah/serializable/commit/d2211c90b65e27510711d90daf1b001f3e7c81e2))

* Merge branch &#39;main&#39; of github.com:madpah/serializable ([`6520862`](https://github.com/madpah/serializable/commit/652086249f399f8592fc89ee6fcb33ebdbe6973d))

* namespacing for XML output

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`2e32f08`](https://github.com/madpah/serializable/commit/2e32f084552bee69ad815466741d66fee96ff2e1))


## v0.3.9 (2022-08-24)

### Fix

* fix: support declaration of XML NS in `as_xml()` call

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`19b2b70`](https://github.com/madpah/serializable/commit/19b2b7048fdd7048d62f618987c13f2d3a457726))

### Unknown

* 0.3.9

Automatically generated by python-semantic-release ([`3269921`](https://github.com/madpah/serializable/commit/32699214554b0ec5d4b592f2ab70d6ae923c9e9c))


## v0.3.8 (2022-08-24)

### Fix

* fix: deserialization of XML boolean values

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`799d477`](https://github.com/madpah/serializable/commit/799d4773d858fdf8597bef905302a373ca150db8))

### Unknown

* 0.3.8

Automatically generated by python-semantic-release ([`dbf545c`](https://github.com/madpah/serializable/commit/dbf545cb4a51a10125a4104771ecca11e484ac53))


## v0.3.7 (2022-08-23)

### Fix

* fix: fixed deferred parsing for Properties

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`833e29b`](https://github.com/madpah/serializable/commit/833e29b8391c85931b12c98f87a2faf3a68d388e))

### Unknown

* 0.3.7

Automatically generated by python-semantic-release ([`1628f28`](https://github.com/madpah/serializable/commit/1628f2870c8de2643c74550cbe34c09d84b419d7))


## v0.3.6 (2022-08-23)

### Fix

* fix: support for cyclic dependencies

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`911626c`](https://github.com/madpah/serializable/commit/911626c88fb260049fdf2931f6ea1b0b05d7166a))

### Unknown

* 0.3.6

Automatically generated by python-semantic-release ([`54607f1`](https://github.com/madpah/serializable/commit/54607f1ac9e64e7cd8762699fd7f1567ac9c8d83))

* Merge branch &#39;main&#39; of github.com:madpah/serializable ([`a54d5cf`](https://github.com/madpah/serializable/commit/a54d5cf3a68959f006340e88fc2f095558a70b1a))


## v0.3.5 (2022-08-22)

### Fix

* fix: support for non-primitive types when XmlSerializationType == FLAT

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`7eff15b`](https://github.com/madpah/serializable/commit/7eff15bbb8d20760418071c005d65d2623b44eab))

### Unknown

* 0.3.5

Automatically generated by python-semantic-release ([`d7e03d1`](https://github.com/madpah/serializable/commit/d7e03d13522d983ab79e4fa114f5deb4d43a7db9))

* Merge branch &#39;main&#39; of github.com:madpah/serializable ([`6ec8c38`](https://github.com/madpah/serializable/commit/6ec8c38219e392ecab25d9eee7b67b05cc3b85f2))


## v0.3.4 (2022-08-22)

### Fix

* fix: support ENUM in XML Attributes

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`f2f0922`](https://github.com/madpah/serializable/commit/f2f0922f2d0280185f6fc7f96408d6647588c8d2))

### Unknown

* 0.3.4

Automatically generated by python-semantic-release ([`adae34c`](https://github.com/madpah/serializable/commit/adae34c2c7be2ab920335d038cc4f9a80dbb128f))

* Merge branch &#39;main&#39; of github.com:madpah/serializable ([`8995505`](https://github.com/madpah/serializable/commit/899550591954f4236bbeb53191d6ad47cdf8779d))

* code styling

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`7ec0197`](https://github.com/madpah/serializable/commit/7ec01978b2b581b0fbeb610b0707d4d6aa42ec1a))


## v0.3.3 (2022-08-19)

### Fix

* fix: handle Array types where the concrete type is quoted in its definition

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`b6db879`](https://github.com/madpah/serializable/commit/b6db879d72822ada74a41362594b009f09349da9))

### Unknown

* 0.3.3

Automatically generated by python-semantic-release ([`f0c463b`](https://github.com/madpah/serializable/commit/f0c463b45061b05e060df526185c3b374f49fda2))

* Merge branch &#39;main&#39; of github.com:madpah/serializable ([`ea0aa86`](https://github.com/madpah/serializable/commit/ea0aa86cbba7b8504e52dcabc8f781af81326d82))


## v0.3.2 (2022-08-19)

### Fix

* fix: work to support `sortedcontainers` as a return type for Properties

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`805a3f7`](https://github.com/madpah/serializable/commit/805a3f7a10e41f63b132ac0bb234497d5d39fe2b))

### Unknown

* 0.3.2

Automatically generated by python-semantic-release ([`f86da94`](https://github.com/madpah/serializable/commit/f86da944467b0d8ff571f3ca2e924b50e388bb4c))

* Merge branch &#39;main&#39; of github.com:madpah/serializable ([`cf9234e`](https://github.com/madpah/serializable/commit/cf9234e65c55b3d1814c36c7b3c2dcfb9b4ae1d5))


## v0.3.1 (2022-08-19)

### Fix

* fix: better support for Properties that have a Class type that is not a Serializable Class (e.g. UUID)

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`95d407b`](https://github.com/madpah/serializable/commit/95d407b4456d8f106cf54ceb650cbde1aab69457))

### Unknown

* 0.3.1

Automatically generated by python-semantic-release ([`53d96bd`](https://github.com/madpah/serializable/commit/53d96bd515bf4bafa1216bc6041e25b8f7ddecb7))


## v0.3.0 (2022-08-19)

### Feature

* feat: support ignoring elements/properties during deserialization

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`6319d1f`](https://github.com/madpah/serializable/commit/6319d1f9e632a941b1d79a63083c1ecb194105be))

### Unknown

* 0.3.0

Automatically generated by python-semantic-release ([`a286b88`](https://github.com/madpah/serializable/commit/a286b88a5a9cb17eaa4f04c94f9c0c148e9e7052))


## v0.2.3 (2022-08-19)

### Fix

* fix: update `helpers` to be properly typed

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`d924dc2`](https://github.com/madpah/serializable/commit/d924dc2d3b5f02c61ff6ac36fa10fa6adaac7022))

### Unknown

* 0.2.3

Automatically generated by python-semantic-release ([`f632d2f`](https://github.com/madpah/serializable/commit/f632d2f10b7b5fb6cbdad038eaacaf73c2c9bbb7))

* Merge branch &#39;main&#39; of github.com:madpah/serializable ([`5d6564d`](https://github.com/madpah/serializable/commit/5d6564d787f8b269b86f3a5c4f055c62c38fd676))


## v0.2.2 (2022-08-19)

### Fix

* fix: change to helpers to address typing issues

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`1c32ba1`](https://github.com/madpah/serializable/commit/1c32ba143504a605a77df4908422a95d0bd07edf))

* fix: remove `/` from method signature so we work on Python &lt; 3.8

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`c45864c`](https://github.com/madpah/serializable/commit/c45864cd6c90ed38d8cedd944adcfe43b32326b2))

### Unknown

* 0.2.2

Automatically generated by python-semantic-release ([`60045d8`](https://github.com/madpah/serializable/commit/60045d8342357b0a3ffe6b2a22abc9068f0d140c))


## v0.2.1 (2022-08-18)

### Fix

* fix: update to work on python &lt; 3.10

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`91df8cb`](https://github.com/madpah/serializable/commit/91df8cbb718db15ea182888aa796db32b8015004))

### Unknown

* 0.2.1

Automatically generated by python-semantic-release ([`4afc403`](https://github.com/madpah/serializable/commit/4afc4035f5dda5e6387963abb8d1332aa90dbd2c))

* Merge branch &#39;main&#39; of github.com:madpah/serializable ([`dbc5039`](https://github.com/madpah/serializable/commit/dbc50397638e4a738443c6a3b5b809d64d962ddf))


## v0.2.0 (2022-08-18)

### Feature

* feat: library re-write to utilise decorators

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`957fca7`](https://github.com/madpah/serializable/commit/957fca757d89dc1b8ef9b13357a5a9380dbe94ff))

### Unknown

* 0.2.0

Automatically generated by python-semantic-release ([`5bff0a8`](https://github.com/madpah/serializable/commit/5bff0a88ecc4c135ec60eafcc592f55157e1b103))

* Merge branch &#39;main&#39; of github.com:madpah/serializable ([`b14e2c9`](https://github.com/madpah/serializable/commit/b14e2c9f8da270318fe1fddf242c82570027729d))

* doc changes to reflect move to use of decorators

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`9f1b4ca`](https://github.com/madpah/serializable/commit/9f1b4ca17ee57f8a55ae211d78daed29c0068584))

* typing

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`d3633ed`](https://github.com/madpah/serializable/commit/d3633ed1fc09b72ea222a51b4a852dd7db52a0bf))

* typing

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`3480d71`](https://github.com/madpah/serializable/commit/3480d7126e063cef5746522479b381eba8cca818))

* removed `print()` calls - added logger

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`1deee5e`](https://github.com/madpah/serializable/commit/1deee5ec611a3c31f63a66be762caac70625472f))

* removed dead code

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`375b367`](https://github.com/madpah/serializable/commit/375b367e8705b5b6d0b5e4ac0c506776eb9da001))

* wip: all unit tests passing for JSON and XML after migrating to use of decorators

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`d4ab8f4`](https://github.com/madpah/serializable/commit/d4ab8f413b1f2bbf79e5a66ea353407f9dc15944))

* wip - JSON serialization and deserialization unit tests passing using decorators

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`291b37d`](https://github.com/madpah/serializable/commit/291b37da7d3f414750d555797f24378158eae4c4))

* wip - move to using Decorators to annotate classes to affect serialization/deserialization

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`05d6e5a`](https://github.com/madpah/serializable/commit/05d6e5a68630e4af09e81a02d5aca4a55391871a))


## v0.1.7 (2022-08-15)

### Fix

* fix: support for Objects that when represented in XML may just be simple elements with attributes

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`1369d7d`](https://github.com/madpah/serializable/commit/1369d7d755d9e50273b72e2fdd7d2967442e5bde))

### Unknown

* 0.1.7

Automatically generated by python-semantic-release ([`291a2b3`](https://github.com/madpah/serializable/commit/291a2b3822e2f5c0e4b1ed7c90b3205147f74704))

* Merge branch &#39;main&#39; of github.com:madpah/serializable ([`9c34c2f`](https://github.com/madpah/serializable/commit/9c34c2fe5d4dd96e04b54949b2b3bbd088ac9ca1))


## v0.1.6 (2022-08-15)

### Fix

* fix: temporarilty add `Any` as part of `AnySerializable` type

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`d3e9beb`](https://github.com/madpah/serializable/commit/d3e9bebd7b8dc78d4eb36447ad0b1ee46e2745e0))

### Unknown

* 0.1.6

Automatically generated by python-semantic-release ([`77cc49b`](https://github.com/madpah/serializable/commit/77cc49bd1ad9fae4bed17eaf47659d584a3cec3f))


## v0.1.5 (2022-08-13)

### Fix

* fix: direct support for Python `Enum`

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`50148cc`](https://github.com/madpah/serializable/commit/50148cc98a26e4e51479b491acb58451ea5b42b6))

### Unknown

* 0.1.5

Automatically generated by python-semantic-release ([`532d0d1`](https://github.com/madpah/serializable/commit/532d0d1eb613d0c62e881cd898e5f5195a506b17))


## v0.1.4 (2022-08-13)

### Fix

* fix: added missing `py.typed` marker

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`ee3169f`](https://github.com/madpah/serializable/commit/ee3169f466353a88922174b40f5b29cb98998be9))

### Unknown

* 0.1.4

Automatically generated by python-semantic-release ([`02c2c30`](https://github.com/madpah/serializable/commit/02c2c3019de4939138c92d070ffdadb86d9dc7f4))

* Merge branch &#39;main&#39; of github.com:madpah/serializable ([`5219023`](https://github.com/madpah/serializable/commit/5219023246373e5e98663d46736c2299fc77b548))


## v0.1.3 (2022-08-12)

### Fix

* fix: added helpers for serializing XML dates and times (xsd:date, xsd:datetime)

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`c309834`](https://github.com/madpah/serializable/commit/c3098346abf445876d99ecb768d7a4a08b12a291))

### Unknown

* 0.1.3

Automatically generated by python-semantic-release ([`9c6de39`](https://github.com/madpah/serializable/commit/9c6de399dd9ea70b2136a8aa0797a3bd3ffbc881))

* Merge branch &#39;main&#39; of github.com:madpah/serializable ([`986286f`](https://github.com/madpah/serializable/commit/986286f9723b9a2154b0e3d9d5d7d14f64f65c8a))


## v0.1.2 (2022-08-12)

### Fix

* fix: support for properties whose value is an `Type[SerializableObject]` but are not `List` or `Set`

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`bf6773c`](https://github.com/madpah/serializable/commit/bf6773c40f3f45dbe2821fdbe785b369f0b3b71c))

### Unknown

* 0.1.2

Automatically generated by python-semantic-release ([`7ca1b6f`](https://github.com/madpah/serializable/commit/7ca1b6f92061c8cd73d8554c764dc4b39c2b6364))

* Merge branch &#39;main&#39; of github.com:madpah/serializable ([`bdb75e0`](https://github.com/madpah/serializable/commit/bdb75e0961cc17b11abb37dd984af16c0623d18f))


## v0.1.1 (2022-08-11)

### Fix

* fix: handle nested objects that are not list or set

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`4bc5252`](https://github.com/madpah/serializable/commit/4bc525258d0ee655beabace18e41323b4b67ae1b))

### Unknown

* 0.1.1

Automatically generated by python-semantic-release ([`fc77999`](https://github.com/madpah/serializable/commit/fc77999d8ab8c8ac2f6273f64387f95104551e56))


## v0.1.0 (2022-08-10)

### Feature

* feat: first alpha release

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`c95a772`](https://github.com/madpah/serializable/commit/c95a7724186b6e45554624b5238c719d172ffc9f))

* feat: first working draft of library for (de-)serialization to/from JSON and XML

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`7af4f9c`](https://github.com/madpah/serializable/commit/7af4f9c4a100f1ce10502ecef228f42ea61e9c22))

### Unknown

* 0.1.0

Automatically generated by python-semantic-release ([`701a522`](https://github.com/madpah/serializable/commit/701a522410783677087a0da682f899f4fbd4368d))

* doc: fixed doc config and added first pass documentation

Signed-off-by: Paul Horton &lt;paul.horton@owasp.org&gt; ([`38705a1`](https://github.com/madpah/serializable/commit/38705a1156d04a5ae5fc96c6cd691e1d1a0e2ead))

* Initial commit ([`70ca2a5`](https://github.com/madpah/serializable/commit/70ca2a5d8d4042c969e1120e5604ea37878ac5c3))
