#!/usr/bin/env python
#ident "@(#) $Id: setup.py,v 1.22 2003/07/14 21:02:02 ballie01 Exp $"
# vi:set sw=4 ts=8 showmode ai:
#-----------------------------------------------------------------------+
# Name:		setup.py						|
#									|
# Synopsis:	python setup.py build	# Build the module.		|
#		python setup.py install	# Install the module.		|
#									|
#		See http://www.python.org/sigs/distutils-sig/doc/ for	|
#		more information on using distutils to install Python	|
#		programs and modules.					|
#									|
# Description:	Setup script (using the distutils framework) for	|
#		pyPgSQL.						|
#=======================================================================|
# Copyright 2001, 2002 by Gerhard Haering.				|
# All rights reserved.							|
#									|
# Permission to use, copy, modify, and distribute this software and its	|
# documentation for any purpose and without fee is hereby granted, pro-	|
# vided that the above copyright notice appear in all copies and that	|
# both that copyright notice and this permission notice appear in sup-	|
# porting documentation, and that the copyright owner's name not be	|
# used in advertising or publicity pertaining to distribution of the	|
# software without specific, written prior permission.			|
#									|
# THE AUTHOR(S) DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,	|
# INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS.  IN	|
# NO EVENT SHALL THE AUTHOR(S) BE LIABLE FOR ANY SPECIAL, INDIRECT OR	|
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS	|
# OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE	|
# OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE	|
# USE OR PERFORMANCE OF THIS SOFTWARE.					|
#=======================================================================|
# People who have worked on this code.					|
#									|
# Ini Name								|
# --- ----------------------------------------------------------------- |
#  gh Gerhard Haering <gerhard.haering@gmx.de>				|
# bga Billy G. Allie <bill.allie@mug.org>				|
#=======================================================================|
# Revision History:							|
#									|
# Date      Ini Description						|
# --------- --- ------------------------------------------------------- |
# 25APR2003 gh	Added changes for registration with the Python Package	|
#		index (PyPI) (http://python.org/pypi).			|
# 01DEC2002 gh	Simplified build process and got rid of setup.config.	|
#		setup.config prevented the bdist_rpm command of dist-	|
#		utils to work and generally wasn't such a good idea as	|
#		it looked first. Pretty much the same effect is now	|
#		reached by the USE_CUSTOM variable with which users	|
#		can override the platform detection.			|
# 06OCT2002 bga Added support for UnixWare7 and OpenUNIX 8.		|
# 16SEP2002 gh  Total rework to make setup.py work out of the box for   |
#		most popular platforms, while still allowing flexibi-	|
#		lity through setup.config.				|
# 29AUG2001 gh  Reflected changed PostgreSQL win32 build process (Post- |
#		greSQL now built with mingw32)				|
# 28AUG2001 bga Add include_dirs and lib_dirs for building on cygwin.	|
#		This change should allow pyPgSQL to build 'out of the	|
#		box' on MS Windows using the cygwin environment.	|
# 20AUG2001 bga Modified to include the new source files.		|
#	    --- Added code to determine any needed runtime library	|
#		search directories.					|
# 04AUG2001 gh  Modified to include the files pgversion.c,		|
#		pymemstrdup.c and strtok.c.				|
# 26JUL2001 bga Modified to use included strtoll.c and strtoull.c files.|
#	    --- Added this flower box and cleaned up file.		|
# 22JUL2001 gh  Modified to build win32 version.			|
# 01JUN2001 gh	Initial version created by Gerhard Haering.		|
#-----------------------------------------------------------------------+
import os, os.path, sys

from distutils.core import setup
from distutils.extension import Extension

__version__ = "2.4"

# Define the runtime library path for this module.  It starts out as None.

def main():
    # Set this to 1 if you need to use your own settings
    USE_CUSTOM = 0

    # Default settings, may be overriden for specific platforms
    pypgsql_rt_dirs = None
    optional_libs = ["pq"]
    modname = "pyPgSQL.libpq.libpqmodule"

    sources = ["libpqmodule.c",  "pgboolean.c",
	"pgint2object.c", "pgint8object.c",
	"pgversion.c",    "pglargeobject.c",
	"pgnotify.c",     "pgconnection.c",
	"pgresult.c",     "pymemstrdup.c",
	"port/strtoll.c", "port/strtoull.c",
	"port/strtok.c"]

    if USE_CUSTOM:
	include_dirs = YOUR_LIST_HERE
	library_dirs = YOUR_LIST_HERE
    elif sys.platform == "linux2":
	include_dirs = ["/usr/include", "/usr/include/postgresql",
	    "/usr/include/pgsql"]
	library_dirs = ["/usr/lib"]

	# XXX: This is an ugly hack to make bdist_rpm find the include files.
	include_dirs.append("../" * 5)
    elif sys.platform[:8] == "unixware":
	LOCALBASE = os.environ.get('LOCALBASE', '/usr/local/pgsql')
	include_dirs = ['%s/include' % LOCALBASE]
	library_dirs = ['%s/lib' % LOCALBASE]
	pypgsql_rt_dirs = library_dirs
    elif sys.platform[:8] == "openunix":
	LOCALBASE = os.environ.get('LOCALBASE', '/usr/local/pgsql')
	include_dirs = ['%s/include' % LOCALBASE]
	library_dirs = ['%s/lib' % LOCALBASE]
	pypgsql_rt_dirs = library_dirs
    elif sys.platform == "freebsd4":
	LOCALBASE = os.environ.get('LOCALBASE', '/usr/local')
	include_dirs = ['%s/include' % LOCALBASE]
	library_dirs = ['%s/lib' % LOCALBASE]
    elif sys.platform == "openbsd3":
	LOCALBASE = os.environ.get('LOCALBASE', '/usr/local')
	include_dirs = ['%s/include/postgresql' % LOCALBASE]
	library_dirs = ['%s/lib' % LOCALBASE]
    elif sys.platform == "netbsd1":
	LOCALBASE = os.environ.get('LOCALBASE', '/usr/pkg')
	include_dirs = ['%s/include/pgsql' % LOCALBASE]
	library_dirs = ['%s/lib' % LOCALBASE]
    elif sys.platform == "cygwin":
	include_dirs  = ["/usr/include/postgresql"]
	library_dirs  = ["/usr/lib"]
    elif sys.platform == "darwin": # Mac OS X
	include_dirs = ["/usr/local/pgsql/include"]
	library_dirs = ["/usr/local/pgsql/lib"]
	optional_libs += ["ssl", "crypto"]
    elif sys.platform == "win32":
	# This works with the PostgreSQL source tree, so it's a bit ugly ...
	# Lines commented out are for using MSVC instead of mingw
	win_pg_build_root = os.getenv("PG_SRC", "../postgresql")

	include_dirs = [os.path.join(win_pg_build_root, p) for p in
			["src/include",
			 "src/include/libpq",
			 "src",
			 "src/interfaces/libpq"]]

	library_dirs = [win_pg_build_root + "/src/interfaces/libpq"]
	#library_dirs = [win_pg_build_root + "/src/interfaces/libpq/Release"]
	optional_libs += ["wsock32", "advapi32"]
	#optional_libs = ["libpq", "wsock32", "advapi32"]
	modname="pyPgSQL.libpq.libpq"
    else:
	# Assume a Unixish system
	include_dirs = ["/usr/local/include"]
	library_dirs = ["/usr/local/lib"]

    # patch distutils if it can't cope with the "classifiers" keyword
    if sys.version < '2.2.3':
	from distutils.dist import DistributionMetadata
	DistributionMetadata.classifiers = None
	DistributionMetadata.download_url = None

    classifiers = [
	"Development Status :: 5 - Production/Stable",
	"Environment :: Other Environment",
	"Intended Audience :: Developers",
	"License :: OSI Approved :: Python License (CNRI Python License)",
	"Natural Language :: English",
	"Operating System :: Microsoft :: Windows :: Windows 95/98/2000",
	"Operating System :: POSIX",
	"Programming Language :: C",
	"Programming Language :: Python",
	"Topic :: Database :: Front-Ends"]

    setup (
	name = "pyPgSQL",
	version = __version__,
	description = \
	    "pyPgSQL - A Python DB-API 2.0 compliant interface to PostgreSQL.",
	maintainer = "pyPgSQL developers",
	maintainer_email = "pypgsql-devel@lists.sourceforge.net",
	url = "http://pypgsql.sourceforge.net/",
	licence = "Python",
	packages = ["pyPgSQL", "pyPgSQL.libpq"],
	ext_modules = [Extension(
	    name=modname,
	    sources = sources,
	    include_dirs = include_dirs,
	    library_dirs = library_dirs,
	    runtime_library_dirs = pypgsql_rt_dirs,
	    libraries = optional_libs
	    )],
	classifiers = classifiers
    )

if __name__ == "__main__":
    main()
