%define name pyPgSQL
%define version 2.4
%define release 0

#  automatically set GCC flags based on version
%{expand:%%define gccmajorvers %(gcc -v 2>&1 | tail -1 | awk '{ print $3 }' | awk -F. '{ print $1 }')}
%if %{gccmajorvers} >= 3
%define cflags -std=c99 $RPM_OPT_FLAGS
%else
%define cflags $RPM_OPT_FLAGS
%endif

Summary: pyPgSQL - A Python DB-API 2.0 compliant interface to PostgreSQL.
Name: %{name}
Version: %{version}
Release: %{release}
Source: http://telia.dl.sourceforge.net/sourceforge/pypgsql/pypgsql-%{version}.tar.gz
Copyright: BSD
Group: Development/Libraries
BuildRoot: %{_tmppath}/%{name}-buildroot
Prefix: %{_prefix}
Vendor: pyPgSQL developers <pypgsql-devel@lists.sourceforge.net>
Url: http://pypgsql.sourceforge.net/
Requires: egenix-mx-base
Requires: python2
Requires: postgresql-libs
BuildPrereq: python2-devel
BuildPrereq: postgresql-devel

%description
pyPgSQL is a package of two modules that provide a Python DB-API 2.0
compliant interface to PostgreSQL databases. The first module, libpq,
exports the PostgreSQL C API to Python. This module is written in C and
can be compiled into Python or can be dynamically loaded on demand. The
second module, PgSQL, provides the DB-API 2.0 compliant interface and
support for various PostgreSQL data types, such as INT8, NUMERIC, MONEY,
BOOL, ARRAYS, etc. This module is written in Python.

%prep
%setup -n pypgsql

%build
env CFLAGS="%{cflags}" /usr/bin/python2 setup.py build

#  change the path in the test/examples
find test examples -type f | while read file
do
   echo "Fixing path in $file"
   sed 's|^#!.*|#!/usr/bin/env python2|' <$file >/tmp/pathrep.$$
   cat </tmp/pathrep.$$ >$file
   rm -f /tmp/pathrep.$$
done

%install
/usr/bin/python2 setup.py install --root=$RPM_BUILD_ROOT --record=INSTALLED_FILES

%clean
rm -rf $RPM_BUILD_ROOT

%files -f INSTALLED_FILES
%doc README Announce ChangeLog
%doc examples test
%defattr(-,root,root)

%changelog
* Wed Jul 16 2003 Gerhard Hring <gh@ghaering.de>
- Changed version number to 2.4.

* Sun Dec 01 2002 Gerhard Hring <gerhard.haering@gmx.de>
- Changed Vendor field to the pyPgSQL developers list.
- Changed Source field to Sourceforge mirror.

* Sun Oct 27 2002 Sean Reifschneider <jafo-rpms@tummy.com>
- Define CFLAGS for gcc 3.x compilers so that the C version of PgInt8 gets
  built.

* Sat Oct 19 2002 Gerhard Hring <gerhard.haering@gmx.de>
- Updated to version 2.3.

* Sun Sep 08 2002 Sean Reifschneider <jafo-rpms@tummy.com>
- Updated to version 2.2.
- Added README to %doc (suggested by Gerhard Hring)
- Added examples, test, Announce and ChangeLog to %doc
- Added postgresql-devel to BuildPrereq and postgresql-libs to requires
  (suggested by Gerhard Hring).
- Fix the path in the examples.

* Sun Sep 08 2002 Gerhard Hring <gerhard.haering@gmx.de>
- Changed copyright to 'BSD'

* Fri Sep 06 2002 Sean Reifschneider <jafo-rpms@tummy.com>
- Updated to version 2.1.
- Added a description.
- Added dependencies on egenix-mx-base and python2
