/*
 * Copyright (C) 2001 Rok Papez <rok.papez@lugos.si>
 * Rok Papez
 * Hribovska pot 17
 * 1231 Ljubljana - Crnuce
 * EUROPE, Slovenia
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifdef   HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdlib.h>
#include <string.h>

#include "util.h"

//------------------------------------------------------------------------------------------------------------
void *safe_malloc(size_t size) {
  if(!size)
    return NULL;
  return malloc(size);
}
//------------------------------------------------------------------------------------------------------------
void *safe_calloc(size_t nmemb, size_t size) {
  void *tmp;
  tmp = safe_malloc(nmemb*size);
  if(tmp)
    memset(tmp, 0x00, nmemb*size);
  return tmp;
}
//------------------------------------------------------------------------------------------------------------
