
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define LINESIZE 100
#define MAXFH 20
#define MAXNT 2048
#define MAXCHAR 512

static int ptr[MAXCHAR];
static unsigned long token[MAXNT];
char buf[LINESIZE];
int nt;
static char comment[MAXCHAR][LINESIZE];
static char filehead[MAXFH][LINESIZE];

void addtoken(unsigned long t)
{
	if (nt >= MAXNT) 
	{ 
		fprintf(stderr, "Too many Unicode entries. Recompile "
				"map2uni with a bigger MAXNT\n"); 
		exit(1); 
	}

	if ((t > 0 && t < 0x20) || (t >= 0x7F && t < 0xA0))
	{
		fprintf(stderr, "Token 0x%lx (control code) ignored!\n", t);
		return;
	} 
	token[nt++] = t;
}

void setup_map(int nc, char *p)
{
	char *tmp;
	unsigned long uni;

	ptr[nc] = nt;
	if (strstr(p, "idem")) 
	{
		addtoken(nc);
	}
	else while ((tmp = strstr(p, "U+")))
	{
		sscanf(tmp, "U+%lx", &uni);
		addtoken(uni);
		p = tmp + 1;
	}
	if (strstr(p, "U*"))
	{
		addtoken(0x1FFFF);
		while ((tmp = strstr(p, "U*")))
		{
			sscanf(tmp, "U*%lx", &uni);
			addtoken(uni);
			p = tmp + 1;
		}
	}
	addtoken(0xFFFF);
}

int main(int argc, char **argv)
{
	nt = 0;
	int from, to;
	char *p, *c;
	FILE *fp = fopen(argv[2], "r");
	int fh = 0;
	int maxchar = 0;
	int entries = 0;

	/* Characters not named will default to entry 0, no mapping */
	addtoken(0xFFFF);
	while (fgets(buf, LINESIZE, fp))
	{
		if (buf[0] == '#' && fh >= 0 && fh < MAXFH)
		{
			strcpy(filehead[fh], buf + 1);
			p = strchr(filehead[fh], '\n');
			if (p) *p = 0;
			++fh;
		}
		if (buf[0] != '0') continue;
		fh = -1;
		c = strchr(buf, '#');
		if (c) 
		{ 
			*c = 0; 
			++c; 
			p = strchr(c, '\n');
			if (p) *p = 0;
		}
		if (strchr(buf, '-'))
		{
			sscanf(buf, "0x%x-0x%x", &from, &to);
		}
		else
		{
			sscanf(buf, "0x%x", &from);
			to = from;
		}
		while (from <= to)
		{
			if (c) strcpy(comment[from], c);
			setup_map(from++, buf);	
		}	
		if (maxchar < to) maxchar = to;
	}
	fclose(fp);
	p = strchr(argv[1], '.');
	if (p) *p = 0;
	p = strchr(argv[1], '-');
	if (p) *p = '_';

	printf("/* This file was autogenerated from the Unicode mapping \n"
	       " * table %s in the format used by the Linux kbd package */\n\n", argv[2]);
	for (from = 0; from < MAXFH; from++)
	{
		if (filehead[from][0])
			printf("/* %s */\n", filehead[from]);
	}
	printf("#include <stdio.h>\n#include \"psflib.h\"\n\n");
	printf("static psf_dword values[] = {\n");
	for (from = 0; from < nt; from++)
	{
		printf("0x%04lx, ", token[from]); 
		if ((from & 7) == 7) printf("\n");
	}
	printf("};\n\n");

	if (maxchar <= 255)
	{
		printf("struct psf_mapping256 m_%s = { ", argv[1]);
		entries = 256;
	}
	else
	{
		printf("struct psf_mapping512 m_%s = { ", argv[1]);
		entries = MAXCHAR;
	}

	p = strchr(argv[1], '_');
	if (p) *p = '-';
	printf("\"%s\",\n", argv[1]);
	printf("%d, {\n", maxchar + 1);
	for (from = 0; from < entries; from++)
	{
		printf("&values[%d], /* %d %s */\n", ptr[from], from, comment[from]); 
	}
	printf("}};\n");

	return 0;
}
