#ifdef LUACONSOLE
#ifdef _MSC_VER
#include "Platform.h"
#include "resource.h"
#endif
#include "lua/LuaCompat.h"

void luaopen_eventcompat(lua_State *l)
{
#ifndef _MSC_VER
	int eventcompat_luac_sz = 5494;
	const char* eventcompat_luac = "if not event then\n\011return\nend\n\nlocal deprecated_scripts = {}\nlocal timer = nil\nlocal function print_deprecation_warnings()\n\011if not timer or timer <= 0 then\n\011\011event.unregister(event.tick, print_deprecation_warnings)\n\011else\n\011\011timer = timer - 1\n\011\011return\n\011end\n\n\011local deprecated = {}\n\011for k,v in pairs(deprecated_scripts) do\n\011\011table.insert(deprecated, k)\n\011end\n\011local start_message = #deprecated == 1 and \"This script is\" or \"These scripts are\"\n\011print(start_message..\" using a legacy event api and should be updated: \")\n\011print(\"\\\"\"..table.concat(deprecated, \"\\\", \\\"\")..\"\\\"\")\nend\n\nlocal function deprecationwarning()\n\011-- no warning for now\n\011--[[local calling_file_info = debug.getinfo(3, \"S\")\n\011if calling_file_info then\n\011\011calling_file_info = calling_file_info[\"short_src\"]\n\n\011\011if calling_file_info then\n\011\011\011deprecated_scripts[calling_file_info] = true\n\011\011\011if not timer then\n\011\011\011\011timer = 5\n\011\011\011\011event.register(event.tick, print_deprecation_warnings)\n\011\011\011end\n\011\011end\n\011end]]\nend\n\n\nfunction tpt.register_step(f)\n\011deprecationwarning()\n\n\011event.register(event.tick, f)\nend\n\nfunction tpt.unregister_step(f)\n\011deprecationwarning()\n\n\011event.unregister(event.tick, f)\nend\n\nlocal registered_mouseclicks = {}\nfunction tpt.register_mouseclick(f)\n\011deprecationwarning()\n\n\011if registered_mouseclicks[f] then return end\n\n\011local mousex = -1\n\011local mousey = -1\n\011local mousedown = -1\n\011local function mousedownfunc(x, y, button)\n\011\011--replicate hack in original function\n\011\011if button == 3 then\n\011\011\011button = 4\n\011\011end\n\011\011mousex = x\n\011\011mousey = y\n\011\011mousedown = button\n\011\011return f(x, y, button, 1, 0)\n\011end\n\011local function mouseupfunc(x, y, button, evt)\n\011\011--ignore automatic mouseup event sent when switching windows\n\011\011if mousedown == -1 and evt == 1 then\n\011\011\011return\n\011\011end\n\011\011--replicate hack in original function\n\011\011if button == 3 then\n\011\011\011button = 4\n\011\011end\n\011\011local evtType = 2\n\011\011if evt == 1 then\n\011\011\011evtType = 4\n\011\011elseif evt == 2 then\n\011\011\011evtType = 5\n\011\011end\n\011\011--zoom window cancel\n\011\011--Original function would have started returning 0 for mousetick events\n\011\011--(until the actual mousedown), but we don't replicate that here\n\011\011if evt ~= 2 then\n\011\011\011mousedown = -1\n\011\011end\n\011\011return f(x, y, button, evtType, 0)\n\011end\n\011local function mousemovefunc(x, y, dx, dy)\n\011\011mousex = x\n\011\011mousey = y\n\011end\n\011local function mousewheelfunc(x, y, d)\n\011\011return f(x, y, 0, 0, d)\n\011end\n\011local function tickfunc()\n\011\011if mousedown ~= -1 then\n\011\011\011return f(mousex, mousey, mousedown, 3, 0)\n\011\011end\n\011end\n\n\011event.register(event.mousedown, mousedownfunc)\n\011event.register(event.mouseup, mouseupfunc)\n\011event.register(event.mousemove, mousemovefunc)\n\011event.register(event.mousewheel, mousewheelfunc)\n\011event.register(event.tick, tickfunc)\n\011\n\011local funcs = {mousedownfunc, mouseupfunc, mousemovefunc, mousewheelfunc, tickfunc}\n\011registered_mouseclicks[f] = funcs\nend\ntpt.register_mouseevent = tpt.register_mouseclick\n\nfunction tpt.unregister_mouseclick(f)\n\011if not registered_mouseclicks[f] then return end\n\n\011local funcs = registered_mouseclicks[f]\n\011event.unregister(event.mousedown, funcs[1])\n\011event.unregister(event.mouseup, funcs[2])\n\011event.unregister(event.mousemove, funcs[3])\n\011event.unregister(event.mousewheel, funcs[4])\n\011event.unregister(event.tick, funcs[5])\n\011\n\011registered_mouseclicks[f] = nil\nend\ntpt.unregister_mouseevent = tpt.unregister_mouseclick\n\nlocal registered_keypresses = {}\nfunction tpt.register_keypress(f)\n\011deprecationwarning()\n\n\011if registered_keypresses[f] then return end\n\n\011local keyMapping = {}\n\n\011-- lctrl, rctlr, lshift, rshift, lalt, ralt\n\011keyMapping[225] = 304\n\011keyMapping[229] = 303\n\011keyMapping[224] = 306\n\011keyMapping[228] = 305\n\011keyMapping[226] = 308\n\011keyMapping[230] = 307\n\n\011--up, down, right, left\n\011keyMapping[82] = 273\n\011keyMapping[81] = 274\n\011keyMapping[79] = 275\n\011keyMapping[80] = 276\n\n\011-- shift mapping for US keyboard layout\n\011local shiftMapping = {\n\011\011[\"`\"] = \"~\",\n\011\011[\"1\"] = \"!\",\n\011\011[\"2\"] = \"@\",\n\011\011[\"3\"] = \"#\",\n\011\011[\"4\"] = \"$\",\n\011\011[\"5\"] = \"%\",\n\011\011[\"6\"] = \"^\",\n\011\011[\"7\"] = \"&\",\n\011\011[\"8\"] = \"*\",\n\011\011[\"9\"] = \"(\",\n\011\011[\"0\"] = \")\",\n\011\011[\"-\"] = \"_\",\n\011\011[\"=\"] = \"+\",\n\n\011\011[\"[\"] = \"{\",\n\011\011[\"]\"] = \"}\",\n\011\011[\"\\\\\"] = \"|\",\n\011\011[\";\"] = \":\",\n\011\011[\"'\"] = \"\\\"\",\n\011\011[\",\"] = \"<\",\n\011\011[\".\"] = \">\",\n\011\011[\"/\"] = \"?\"\n\011}\n\n\011local function keypress(key, scan, rep, shift, ctrl, alt)\n\011\011if rep then return end\n\011\011local mod = event.getmodifiers()\n\n\011\011-- attempt to convert to string representation\n\011\011err, keyStr = pcall(string.char, key)\n\011\011if not err then keyStr = \"\" end\n\011\011if keyStr ~= \"\" and shift then\n\011\011\011keyStr = shiftMapping[keyStr] and shiftMapping[keyStr] or string.upper(keyStr)\n\011\011end\n\n\011\011-- key mapping for common keys, extremely incomplete\n\011\011if keyMapping[scan] then key = keyMapping[scan] end\n\011\011return f(keyStr, key, mod, 1)\n\011end\n\n\011local function keyrelease(key, scan, rep, shift, ctrl, alt)\n\011\011local mod = event.getmodifiers()\n\n\011\011-- attempt to convert to string representation\n\011\011err, keyStr = pcall(string.char, key)\n\011\011if not err then keyStr = \"\" end\n\n\011\011-- key mapping for common keys, extremely incomplete\n\011\011if keyMapping[scan] then key = keyMapping[scan] end\n\011\011return f(keyStr, key, mod, 2)\n\011end\n\n\011event.register(event.keypress, keypress)\n\011event.register(event.keyrelease, keyrelease)\n\011\n\011local funcs = { keypress, keyrelease }\n\011registered_keypresses[f] = funcs\nend\ntpt.register_keyevent = tpt.register_keypress\n\nfunction tpt.unregister_keypress(f)\n\011if not registered_keypresses[f] then return end\n\n\011local funcs = registered_keypresses[f]\n\011event.unregister(event.keypress, funcs[1])\n\011event.unregister(event.keyrelease, funcs[2])\n\011registered_mouseclicks[f] = nil\nend\ntpt.unregister_keyevent = tpt.unregister_keypress\n";
	luaL_loadbuffer(l, eventcompat_luac, eventcompat_luac_sz, "@eventcompat.lua");
	lua_pcall(l, 0, 0, 0);
#else
	unsigned int size = 0;
	const char* data = NULL;
	Platform::LoadFileInResource(IDI_EVENTCOMPAT, LUASCRIPT, size, data);
	char *buffer = new char[size+1];
	::memcpy(buffer, data, size);
	buffer[size] = 0;
	luaL_loadbuffer(l, buffer, size, "@eventcompat.lua");
	lua_pcall(l, 0, 0, 0);
	delete[] buffer;
#endif
}
#endif
