------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--           C O R B A . D O M A I N M A N A G E R . H E L P E R            --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--         Copyright (C) 2005-2012, Free Software Foundation, Inc.          --
--                                                                          --
-- This specification is derived from the CORBA Specification, and adapted  --
-- for use with PolyORB. The copyright notice above, and the license        --
-- provisions that follow apply solely to the contents neither explicitly   --
-- nor implicitly specified by the CORBA Specification defined by the OMG.  --
--                                                                          --
-- This is free software;  you can redistribute it  and/or modify it  under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  This software is distributed in the hope  that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License for  more details.                                               --
--                                                                          --
-- As a special exception under Section 7 of GPL version 3, you are granted --
-- additional permissions described in the GCC Runtime Library Exception,   --
-- version 3.1, as published by the Free Software Foundation.               --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

with CORBA.Object;

package CORBA.DomainManager.Helper is

   function Unchecked_To_Ref (The_Ref : Object.Ref'Class) return Ref;

   function To_Ref (The_Ref : Object.Ref'Class) return Ref;

   function TC_DomainManager return TypeCode.Object;

   function From_Any (Item : Any) return Ref;

   function To_Any (Item : Ref) return Any;

   --  DomainManager sequence

   function TC_IDL_SEQUENCE_DomainManager return TypeCode.Object;

   function From_Any (Item : Any)
      return IDL_SEQUENCE_DomainManager.Sequence;

   function To_Any
     (Item : IDL_SEQUENCE_DomainManager.Sequence)
      return Any;

   function TC_DomainManagersList return TypeCode.Object;

end CORBA.DomainManager.Helper;
