/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gPLINK2.forms;

import edu.harvard.mgh.purcell.gCLINE.data.FileInfo;
import edu.harvard.mgh.purcell.gPLINK2.GPLINK;
import edu.harvard.mgh.purcell.gPLINK2.baseForm.Form;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class NearNeigh
extends Form {
    public static String name = "Nearest Neighbour";
    JTextField neigh1Text;
    JTextField neigh2Text;
    JTextField genomicText;
    JCheckBox neighButton;

    public NearNeigh(GPLINK mf) {
        super(mf, name);
        this.pack();
        this.setVisible(true);
    }

    protected JPanel createBody() {
        JPanel body = new JPanel();
        this.genomicText = new JTextField(10);
        this.genomicText.getDocument().addDocumentListener(this.validateBodyDL);
        this.neigh1Text = new JTextField(4);
        this.neigh1Text.getDocument().addDocumentListener(this.validateBodyDL);
        this.neigh2Text = new JTextField(4);
        this.neigh2Text.getDocument().addDocumentListener(this.validateBodyDL);
        JTextField[] temp = new JTextField[]{this.neigh1Text, this.neigh2Text};
        this.neighButton = new JCheckBox("Outlier statistics");
        this.neighButton.addActionListener(this.validateBodyAL);
        NearNeigh.bundel((JToggleButton)this.neighButton, temp);
        body.setLayout(new GridBagLayout());
        JPanel genoPanel = new JPanel();
        genoPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.ipadx = 5;
        c.weightx = 0.0;
        c.fill = 2;
        genoPanel.add((Component)new JLabel("IBS distance file (--read-genome)"), c);
        c.weightx = 1.0;
        c.gridx = 1;
        genoPanel.add((Component)this.genomicText, c);
        c.gridx = 2;
        c.weightx = 0.0;
        genoPanel.add((Component)new Form.BrowseButton(this.genomicText, ".genome", "GENOME"), c);
        JPanel neighPanel = new JPanel();
        neighPanel.setAlignmentX(0.0f);
        c = new GridBagConstraints();
        neighPanel.add((Component)this.neighButton, c);
        c.gridx = 1;
        neighPanel.add((Component)this.neigh1Text, c);
        c.gridx = 2;
        neighPanel.add((Component)this.neigh2Text, c);
        c = new GridBagConstraints();
        c.fill = 2;
        c.weighty = 1.0;
        c.weightx = 1.0;
        body.add((Component)genoPanel, c);
        c.gridy = 1;
        c.fill = 3;
        c.anchor = 17;
        body.add((Component)neighPanel, c);
        return body;
    }

    protected String processBody() {
        String ans = "";
        ans = String.valueOf(ans) + "--cluster ";
        ans = String.valueOf(ans) + "--read-genome " + FileInfo.quote(this.genomicText.getText());
        if (this.neighButton.isSelected()) {
            ans = String.valueOf(ans) + " --neighbour " + this.neigh1Text.getText() + " " + this.neigh2Text.getText();
        }
        return ans;
    }

    protected void isBodyValid() {
        this.validBody = this.genomicText.getText().length() < 0 ? false : !this.neighButton.isSelected() || this.neigh1Text.getText().matches("\\d+") && this.neigh2Text.getText().matches("\\d+");
        this.okForm();
    }
}

