/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gPLINK2.forms;

import edu.harvard.mgh.purcell.gCLINE.data.FileInfo;
import edu.harvard.mgh.purcell.gPLINK2.GPLINK;
import edu.harvard.mgh.purcell.gPLINK2.baseForm.Form;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AlleleFreq
extends Form {
    public static String name = "Allele Frequencies";
    private JRadioButton freqButton;
    private JRadioButton countButton;
    private JRadioButton withinButton;
    private JTextField withinField;
    private Form.BrowseButton pickWithin;

    public AlleleFreq(GPLINK mf) {
        super(mf, name);
        this.pack();
        this.setVisible(true);
    }

    protected JPanel createBody() {
        ActionListener validateAL = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlleleFreq.this.isBodyValid();
            }
        };
        DocumentListener validateDL = new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
            }

            public void insertUpdate(DocumentEvent e) {
                AlleleFreq.this.isBodyValid();
            }

            public void removeUpdate(DocumentEvent e) {
                AlleleFreq.this.isBodyValid();
            }
        };
        JPanel body = new JPanel();
        this.freqButton = new JRadioButton("Frequencies (--freq)");
        this.freqButton.addActionListener(validateAL);
        this.freqButton.setSelected(true);
        this.validBody = true;
        this.countButton = new JRadioButton("Frequency Counts (--freq --counts)");
        this.countButton.addActionListener(validateAL);
        this.withinButton = new JRadioButton("Frequencies Stratify by (--freq --within)");
        this.withinButton.addActionListener(validateAL);
        this.withinField = new JTextField(30);
        this.withinField.getDocument().addDocumentListener(validateDL);
        this.pickWithin = new Form.BrowseButton(this.withinField, null, null);
        ButtonGroup pickOne = new ButtonGroup();
        pickOne.add(this.freqButton);
        pickOne.add(this.countButton);
        pickOne.add(this.withinButton);
        body.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        body.add((Component)this.freqButton, c);
        c.gridy = 1;
        body.add((Component)this.countButton, c);
        c.gridy = 2;
        body.add((Component)AlleleFreq.bundel((JToggleButton)this.withinButton, this.withinField, this.pickWithin), c);
        return body;
    }

    protected void isBodyValid() {
        this.validBody = !this.withinButton.isSelected() || !this.withinField.getText().equals("");
        this.okForm();
    }

    protected String processBody() {
        String ans = "--freq";
        if (this.countButton.isSelected()) {
            ans = String.valueOf(ans) + " --counts";
        }
        if (this.withinButton.isSelected()) {
            ans = String.valueOf(ans) + " --within " + FileInfo.quote(this.withinField.getText());
        }
        return ans;
    }
}

