/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gPLINK2.baseForm;

import edu.harvard.mgh.purcell.gCLINE.data.FileInfo;
import edu.harvard.mgh.purcell.gCLINE.general.GCFileChooser;
import edu.harvard.mgh.purcell.gPLINK2.baseForm.Form;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class FilterDialog
extends JDialog {
    private Form parent;
    private JComboBox chrCBox;
    private JComboBox toCBox;
    private JComboBox fromCBox;
    private JComboBox eeCBox;
    private JComboBox krCBox;
    private JComboBox sexFilterCBox;
    private JComboBox ccFilterCBox;
    private JComboBox fFilterCBox;
    private JTextField setField;
    private JTextField geneField;
    private JTextField fromField;
    private JTextField toField;
    private JTextField SNPField;
    private JTextField windowField;
    private JTextField eeField;
    private JTextField krField;
    private JTextField filterFileField;
    private JTextField filterKeyField;
    private JTextField mfilterField;
    private JCheckBox chrButton;
    private JCheckBox sgButton;
    private JCheckBox ftButton;
    private JCheckBox swButton;
    private JCheckBox eeButton;
    private JCheckBox krButton;
    private JCheckBox fileFilterButton;
    private JCheckBox sexFilterButton;
    private JCheckBox ccFilterButton;
    private JCheckBox fFilterButton;
    private BrowseButton setButton;
    private BrowseButton eeBrowse;
    private BrowseButton krBrowse;
    private BrowseButton filterBrowse;
    private JButton okButton;
    private JButton cancelButton;
    JLabel geneLable;
    JLabel toLabel;
    JLabel wLabel;
    private String[] lengthOpt1 = new String[]{"SNP"};
    private String[] lengthOpt2 = new String[]{"kb", "Mb", "bp"};
    private ActionListener pickMap = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (e.getSource().equals(FilterDialog.this.chrButton)) {
                if (FilterDialog.this.chrButton.isSelected()) {
                    FilterDialog.this.chrCBox.setEnabled(true);
                    FilterDialog.this.swButton.setSelected(false);
                    FilterDialog.this.SNPField.setEditable(false);
                    FilterDialog.this.windowField.setEditable(false);
                } else {
                    FilterDialog.this.chrCBox.setEnabled(false);
                }
            }
            if (e.getSource().equals(FilterDialog.this.swButton)) {
                if (FilterDialog.this.swButton.isSelected()) {
                    FilterDialog.this.SNPField.setEditable(true);
                    FilterDialog.this.windowField.setEditable(true);
                    FilterDialog.this.chrButton.setSelected(false);
                    FilterDialog.this.chrCBox.setEnabled(false);
                    FilterDialog.this.ftButton.setSelected(false);
                    FilterDialog.this.fromCBox.setEnabled(false);
                    FilterDialog.this.fromField.setEditable(false);
                    FilterDialog.this.toCBox.setEnabled(false);
                    FilterDialog.this.toField.setEditable(false);
                } else {
                    FilterDialog.this.SNPField.setEditable(false);
                    FilterDialog.this.windowField.setEditable(false);
                }
            }
            if (e.getSource().equals(FilterDialog.this.ftButton)) {
                if (FilterDialog.this.ftButton.isSelected()) {
                    FilterDialog.this.fromCBox.setEnabled(true);
                    FilterDialog.this.fromField.setEditable(true);
                    FilterDialog.this.toCBox.setEnabled(true);
                    FilterDialog.this.toField.setEditable(true);
                    FilterDialog.this.swButton.setSelected(false);
                    FilterDialog.this.SNPField.setEditable(false);
                    FilterDialog.this.windowField.setEditable(false);
                } else {
                    FilterDialog.this.fromCBox.setEnabled(false);
                    FilterDialog.this.fromField.setEditable(false);
                    FilterDialog.this.toCBox.setEnabled(false);
                    FilterDialog.this.toField.setEditable(false);
                }
            }
        }
    };
    private ActionListener pickList = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (e.getSource().equals(FilterDialog.this.sgButton)) {
                if (FilterDialog.this.sgButton.isSelected()) {
                    FilterDialog.this.setField.setEditable(true);
                    FilterDialog.this.setButton.setEnabled(true);
                    FilterDialog.this.geneField.setEditable(true);
                    FilterDialog.this.eeButton.setSelected(false);
                    FilterDialog.this.eeCBox.setEnabled(false);
                    FilterDialog.this.eeField.setEditable(false);
                    FilterDialog.this.eeBrowse.setEnabled(false);
                } else {
                    FilterDialog.this.setField.setEditable(false);
                    FilterDialog.this.setButton.setEnabled(false);
                    FilterDialog.this.geneField.setEditable(false);
                }
            }
            if (e.getSource().equals(FilterDialog.this.eeButton)) {
                if (FilterDialog.this.eeButton.isSelected()) {
                    FilterDialog.this.eeCBox.setEnabled(true);
                    FilterDialog.this.eeField.setEditable(true);
                    FilterDialog.this.eeBrowse.setEnabled(true);
                    FilterDialog.this.sgButton.setSelected(false);
                    FilterDialog.this.setField.setEditable(false);
                    FilterDialog.this.setButton.setEnabled(false);
                    FilterDialog.this.geneField.setEditable(false);
                } else {
                    FilterDialog.this.eeCBox.setEnabled(false);
                    FilterDialog.this.eeField.setEditable(false);
                    FilterDialog.this.eeBrowse.setEnabled(false);
                }
            }
            if (e.getSource().equals(FilterDialog.this.krButton)) {
                if (FilterDialog.this.krButton.isSelected()) {
                    FilterDialog.this.krCBox.setEnabled(true);
                    FilterDialog.this.krField.setEditable(true);
                    FilterDialog.this.krBrowse.setEnabled(true);
                } else {
                    FilterDialog.this.krCBox.setEnabled(false);
                    FilterDialog.this.krField.setEditable(false);
                    FilterDialog.this.krBrowse.setEnabled(false);
                }
            }
        }
    };
    private ActionListener pickFilter = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            boolean state;
            if (e.getSource().equals(FilterDialog.this.fileFilterButton)) {
                state = FilterDialog.this.fileFilterButton.isSelected();
                FilterDialog.this.filterBrowse.setEnabled(state);
                FilterDialog.this.filterFileField.setEditable(state);
                FilterDialog.this.filterKeyField.setEditable(state);
                FilterDialog.this.mfilterField.setEditable(state);
            }
            if (e.getSource().equals(FilterDialog.this.sexFilterButton)) {
                state = FilterDialog.this.sexFilterButton.isSelected();
                FilterDialog.this.sexFilterCBox.setEnabled(state);
            }
            if (e.getSource().equals(FilterDialog.this.ccFilterButton)) {
                state = FilterDialog.this.ccFilterButton.isSelected();
                FilterDialog.this.ccFilterCBox.setEnabled(state);
            }
            if (e.getSource().equals(FilterDialog.this.fFilterButton)) {
                state = FilterDialog.this.fFilterButton.isSelected();
                FilterDialog.this.fFilterCBox.setEnabled(state);
            }
        }
    };
    private ItemListener changeFromTo = new ItemListener(){

        public void itemStateChanged(ItemEvent arg0) {
            FilterDialog.this.fromCBox.removeAllItems();
            FilterDialog.this.toCBox.removeAllItems();
            if (FilterDialog.this.chrButton.isSelected()) {
                int i = 0;
                while (i < FilterDialog.this.lengthOpt2.length) {
                    FilterDialog.this.fromCBox.addItem(FilterDialog.this.lengthOpt2[i]);
                    FilterDialog.this.toCBox.addItem(FilterDialog.this.lengthOpt2[i]);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < FilterDialog.this.lengthOpt1.length) {
                    FilterDialog.this.fromCBox.addItem(FilterDialog.this.lengthOpt1[i]);
                    FilterDialog.this.toCBox.addItem(FilterDialog.this.lengthOpt1[i]);
                    ++i;
                }
            }
        }
    };
    private WindowListener properClosing = new WindowListener(){

        public void windowActivated(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
            FilterDialog.this.parent.openButtons();
        }

        public void windowClosing(WindowEvent e) {
            FilterDialog.this.parent.openButtons();
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }
    };
    private ActionListener cancel = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            FilterDialog.this.parent.resetFilter();
            FilterDialog.this.dispose();
        }
    };
    private ActionListener process = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (FilterDialog.this.chrButton.isSelected()) {
                FilterDialog.this.parent.addFilter(" --chr " + (String)FilterDialog.this.chrCBox.getSelectedItem());
            }
            if (FilterDialog.this.sgButton.isSelected()) {
                FilterDialog.this.parent.addFilter(" --set " + FileInfo.quote(FilterDialog.this.setField.getText()));
                if (!FilterDialog.this.geneField.getText().equals("")) {
                    FilterDialog.this.parent.addFilter(" --gene " + FilterDialog.this.geneField.getText());
                }
            }
            if (FilterDialog.this.ftButton.isSelected()) {
                FilterDialog.this.parent.addFilter(" --from");
                if (FilterDialog.this.fromCBox.getSelectedItem().toString().equals("kb")) {
                    FilterDialog.this.parent.addFilter("-kb");
                }
                if (FilterDialog.this.fromCBox.getSelectedItem().toString().equals("Mb")) {
                    FilterDialog.this.parent.addFilter("-mb");
                }
                if (FilterDialog.this.fromCBox.getSelectedItem().toString().equals("bp")) {
                    FilterDialog.this.parent.addFilter("-bp");
                }
                FilterDialog.this.parent.addFilter(" " + FilterDialog.this.fromField.getText() + " --to");
                if (FilterDialog.this.toCBox.getSelectedItem().toString().equals("kb")) {
                    FilterDialog.this.parent.addFilter("-kb");
                }
                if (FilterDialog.this.toCBox.getSelectedItem().toString().equals("Mb")) {
                    FilterDialog.this.parent.addFilter("-mb");
                }
                if (FilterDialog.this.toCBox.getSelectedItem().toString().equals("bp")) {
                    FilterDialog.this.parent.addFilter("-bp");
                }
                FilterDialog.this.parent.addFilter(" " + FilterDialog.this.toField.getText());
            }
            if (FilterDialog.this.swButton.isSelected()) {
                if (!FilterDialog.this.SNPField.getText().equals("")) {
                    FilterDialog.this.parent.addFilter(" --snp " + FilterDialog.this.SNPField.getText());
                }
                if (!FilterDialog.this.windowField.getText().equals("")) {
                    FilterDialog.this.parent.addFilter(" --window " + FilterDialog.this.windowField.getText());
                }
            }
            if (FilterDialog.this.eeButton.isSelected() && !FilterDialog.this.eeField.getText().equals("")) {
                if (FilterDialog.this.eeCBox.getSelectedItem().toString().equals("extract")) {
                    FilterDialog.this.parent.addFilter(" --extract " + FileInfo.quote(FilterDialog.this.eeField.getText()));
                } else {
                    FilterDialog.this.parent.addFilter(" --exclude " + FileInfo.quote(FilterDialog.this.eeField.getText()));
                }
            }
            if (FilterDialog.this.krButton.isSelected() && !FilterDialog.this.krField.getText().equals("")) {
                if (FilterDialog.this.krCBox.getSelectedItem().toString().equals("keep")) {
                    FilterDialog.this.parent.addFilter(" --keep " + FileInfo.quote(FilterDialog.this.krField.getText()));
                } else {
                    FilterDialog.this.parent.addFilter(" --remove " + FileInfo.quote(FilterDialog.this.krField.getText()));
                }
            }
            if (FilterDialog.this.fileFilterButton.isSelected()) {
                FilterDialog.this.parent.addFilter(" --filter " + FileInfo.quote(FilterDialog.this.filterFileField.getText()) + " " + FilterDialog.this.filterKeyField.getText());
                if (!FilterDialog.this.mfilterField.getText().equals("")) {
                    FilterDialog.this.parent.addFilter(" --mfilter " + FilterDialog.this.mfilterField.getText());
                }
            }
            if (FilterDialog.this.sexFilterButton.isSelected()) {
                FilterDialog.this.parent.addFilter(" --filter-" + FilterDialog.this.sexFilterCBox.getSelectedItem().toString());
            }
            if (FilterDialog.this.ccFilterButton.isSelected()) {
                FilterDialog.this.parent.addFilter(" --filter-" + FilterDialog.this.ccFilterCBox.getSelectedItem().toString());
            }
            if (FilterDialog.this.fFilterButton.isSelected()) {
                FilterDialog.this.parent.addFilter(" --filter-" + FilterDialog.this.fFilterCBox.getSelectedItem().toString());
            }
            FilterDialog.this.dispose();
        }
    };

    private void initalize() {
        this.chrCBox = new JComboBox<String>(new String[]{" 1", " 2", " 3", " 4", " 5", " 6", " 7", " 8", " 9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", " X", " Y"});
        this.chrCBox.setSelectedIndex(0);
        this.chrCBox.setPreferredSize(new Dimension(this.chrCBox.getPreferredSize().width * 2, this.chrCBox.getPreferredSize().height));
        this.chrCBox.setEnabled(false);
        this.chrButton = new JCheckBox("Chromosome (--chr) ");
        this.chrButton.addItemListener(this.changeFromTo);
        this.chrButton.addActionListener(this.pickMap);
        this.swButton = new JCheckBox("Specific SNP (--snp) ");
        this.swButton.addActionListener(this.pickMap);
        this.SNPField = new JTextField(10);
        this.wLabel = new JLabel("Optional kb window (--window)");
        this.windowField = new JTextField(10);
        this.ftButton = new JCheckBox("--from");
        this.ftButton.addActionListener(this.pickMap);
        this.fromCBox = new JComboBox<String>(this.lengthOpt1);
        this.fromCBox.setSelectedIndex(0);
        this.fromCBox.setEnabled(false);
        this.fromField = new JTextField(10);
        this.toLabel = new JLabel(" --to");
        this.toCBox = new JComboBox<String>(this.lengthOpt1);
        this.toCBox.setSelectedIndex(0);
        this.toCBox.setEnabled(false);
        this.toField = new JTextField(10);
        this.sgButton = new JCheckBox("SNP set-file (--set) ", null);
        this.sgButton.addActionListener(this.pickList);
        this.setField = new JTextField(10);
        this.setButton = new BrowseButton(this.setField, ".set", "SET file");
        this.geneLable = new JLabel("Optional specific gene (--gene) ");
        this.geneField = new JTextField(5);
        this.eeButton = new JCheckBox("SNPs --");
        this.eeButton.addActionListener(this.pickList);
        this.eeCBox = new JComboBox<String>(new String[]{"extract", "exclude"});
        this.eeCBox.setEnabled(false);
        this.eeField = new JTextField(10);
        this.eeBrowse = new BrowseButton(this.eeField, ".list", "LIST file");
        this.krButton = new JCheckBox("Individuals --");
        this.krButton.addActionListener(this.pickList);
        this.krCBox = new JComboBox<String>(new String[]{"keep", "remove"});
        this.krCBox.setEnabled(false);
        this.krField = new JTextField(10);
        this.krBrowse = new BrowseButton(this.krField, ".list", "LIST file");
        this.sexFilterCBox = new JComboBox<String>(new String[]{"males", "females"});
        this.sexFilterCBox.setEnabled(false);
        this.ccFilterCBox = new JComboBox<String>(new String[]{"cases", "controls"});
        this.ccFilterCBox.setEnabled(false);
        this.fFilterCBox = new JComboBox<String>(new String[]{"founders", "nonfounders"});
        this.fFilterCBox.setEnabled(false);
        this.filterFileField = new JTextField(10);
        this.filterKeyField = new JTextField(5);
        this.mfilterField = new JTextField(5);
        this.filterBrowse = new BrowseButton(this.filterFileField, ".txt", "Text file");
        this.fileFilterButton = new JCheckBox("Filter variables (--filter) ", null);
        this.fileFilterButton.addActionListener(this.pickFilter);
        this.sexFilterButton = new JCheckBox("Sex filter --filter-", null);
        this.sexFilterButton.addActionListener(this.pickFilter);
        this.ccFilterButton = new JCheckBox("Individuals --", null);
        this.ccFilterButton.addActionListener(this.pickFilter);
        this.fFilterButton = new JCheckBox("Individuals --", null);
        this.fFilterButton.addActionListener(this.pickFilter);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this.process);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this.cancel);
    }

    private void create() {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel chrPanel = new JPanel();
        chrPanel.setLayout(new FlowLayout(3));
        chrPanel.add(this.chrButton);
        chrPanel.add(this.chrCBox);
        JPanel sgPanel = new JPanel();
        sgPanel.setLayout(new FlowLayout(3));
        sgPanel.add(this.sgButton);
        sgPanel.add(this.setField);
        sgPanel.add(this.setButton);
        sgPanel.add(this.geneLable);
        sgPanel.add(this.geneField);
        JPanel ftPanel = new JPanel();
        ftPanel.setLayout(new FlowLayout(3));
        ftPanel.add(this.ftButton);
        ftPanel.add(this.fromCBox);
        ftPanel.add(this.fromField);
        ftPanel.add(this.toLabel);
        ftPanel.add(this.toCBox);
        ftPanel.add(this.toField);
        JPanel swPanel = new JPanel();
        swPanel.setLayout(new FlowLayout(3));
        swPanel.add(this.swButton);
        swPanel.add(this.SNPField);
        swPanel.add(this.wLabel);
        swPanel.add(this.windowField);
        JPanel eePanel = new JPanel();
        eePanel.setLayout(new FlowLayout(3));
        eePanel.add(this.eeButton);
        eePanel.add(this.eeCBox);
        eePanel.add(this.eeField);
        eePanel.add(this.eeBrowse);
        JPanel krPanel = new JPanel();
        krPanel.setLayout(new FlowLayout(3));
        krPanel.add(this.krButton);
        krPanel.add(this.krCBox);
        krPanel.add(this.krField);
        krPanel.add(this.krBrowse);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JPanel mapPanel = new JPanel();
        mapPanel.setLayout(new BoxLayout(mapPanel, 3));
        mapPanel.setBorder(new TitledBorder("By Map"));
        mapPanel.add(chrPanel);
        mapPanel.add(ftPanel);
        mapPanel.add(swPanel);
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BoxLayout(listPanel, 3));
        listPanel.setBorder(new TitledBorder("By List"));
        listPanel.add(sgPanel);
        listPanel.add(eePanel);
        listPanel.add(krPanel);
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout(new FlowLayout(3));
        filterPanel.add(this.fileFilterButton);
        filterPanel.add(this.filterFileField);
        filterPanel.add(this.filterBrowse);
        filterPanel.add(this.filterKeyField);
        filterPanel.add(new JLabel("Optional column (--mfilter)"));
        filterPanel.add(this.mfilterField);
        JPanel sexFilterPanel = new JPanel();
        sexFilterPanel.setLayout(new FlowLayout(3));
        sexFilterPanel.add(this.sexFilterButton);
        sexFilterPanel.add(this.sexFilterCBox);
        JPanel ccFilterPanel = new JPanel();
        ccFilterPanel.setLayout(new FlowLayout(3));
        ccFilterPanel.add(this.ccFilterButton);
        ccFilterPanel.add(this.ccFilterCBox);
        JPanel fFilterPanel = new JPanel();
        fFilterPanel.setLayout(new FlowLayout(3));
        fFilterPanel.add(this.fFilterButton);
        fFilterPanel.add(this.fFilterCBox);
        JPanel indPanel = new JPanel();
        indPanel.setLayout(new BoxLayout(indPanel, 3));
        indPanel.setBorder(new TitledBorder("By Individual SNP"));
        indPanel.add(filterPanel);
        indPanel.add(sexFilterPanel);
        indPanel.add(ccFilterPanel);
        indPanel.add(fFilterPanel);
        this.getContentPane().add(mapPanel);
        this.getContentPane().add(listPanel);
        this.getContentPane().add(indPanel);
        this.getContentPane().add(buttonPanel);
    }

    public FilterDialog(Form owner) {
        super((Dialog)owner, "Filter SNPs and/or Individuals");
        this.parent = owner;
        this.parent.resetFilter();
        this.parent.closeButtons();
        this.initalize();
        this.create();
        this.addWindowListener(this.properClosing);
        this.pack();
        this.setVisible(true);
    }

    protected class BrowseButton
    extends JButton {
        private String suffex;
        private String suffexDisc;
        private JTextField target;
        private GCFileChooser pick;

        public BrowseButton(JTextField givenTarget) {
            this(givenTarget, null, null);
        }

        public BrowseButton(JTextField givenTarget, String givenSuffex, String givenSuffexDisc) {
            super("Browse");
            this.target = givenTarget;
            this.suffex = givenSuffex;
            this.suffexDisc = givenSuffexDisc;
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileFilter temp = null;
                    if (BrowseButton.this.suffex != null) {
                        temp = new FileFilter(this){
                            final /* synthetic */ 1 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public boolean accept(File f) {
                                return f.getAbsolutePath().endsWith(BrowseButton.access$0(1.access$0(this.this$2)));
                            }

                            public String getDescription() {
                                return BrowseButton.access$1(1.access$0(this.this$2));
                            }
                        };
                    }
                    BrowseButton.this.pick = new GCFileChooser(FilterDialog.this, temp, !((FilterDialog)((BrowseButton)BrowseButton.this).FilterDialog.this).parent.parent.data.isRemote(), false, ((FilterDialog)((BrowseButton)BrowseButton.this).FilterDialog.this).parent.parent.data.getConn(), ((FilterDialog)((BrowseButton)BrowseButton.this).FilterDialog.this).parent.parent.data.getHomeFolder());
                    BrowseButton.this.pick.addFileChoosenListener(new GCFileChooser.FileChoosenListener(this){
                        final /* synthetic */ 1 this$2;
                        {
                            this.this$2 = var1_1;
                        }

                        public void fileChoosenOccures(GCFileChooser.FileChoosenEvent evt) {
                            BrowseButton.access$4(1.access$0(this.this$2)).setText(BrowseButton.access$3((BrowseButton)1.access$0(this.this$2)).fileName);
                        }
                    });
                    BrowseButton.this.pick.showChooser();
                }

                static /* synthetic */ BrowseButton access$0(1 var0) {
                    return var0.BrowseButton.this;
                }
            });
        }

        static /* synthetic */ String access$1(BrowseButton browseButton) {
            return browseButton.suffexDisc;
        }

        static /* synthetic */ JTextField access$4(BrowseButton browseButton) {
            return browseButton.target;
        }
    }
}

