/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gCLINE.tester;

import com.sshtools.j2ssh.SshClient;
import edu.harvard.mgh.purcell.gCLINE.general.ErrorManager;
import edu.harvard.mgh.purcell.gCLINE.general.GCFileChooser;
import edu.harvard.mgh.purcell.gCLINE.tester.TestFrame;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public final class Open
extends JDialog {
    private Logger logger = Logger.getLogger(Open.class);
    protected TestFrame parent;
    private GCFileChooser localChooser;
    private GCFileChooser remoteChooser;
    private JTextField localProject;
    private JTextField remoteProject;
    private JTextField host;
    private JTextField user;
    private JTextField port;
    private SshClient conn;
    private TestFrame.myProject data;
    private JCheckBox remoteFlag;
    private JPanel remotePanel;

    private JPanel createLocal() {
        JPanel ans = new JPanel();
        this.localProject = new JTextField(20);
        this.localChooser = new GCFileChooser(this.parent, (FileFilter)new gCLINEFilter(), true, true, null, "");
        this.localChooser.addFileChoosenListener(new GCFileChooser.FileChoosenListener(){

            public void fileChoosenOccures(GCFileChooser.FileChoosenEvent evt) {
                Open.this.logger.info("(createLocal()) adding the localProject");
                Open.this.localProject.setText(((Open)Open.this).localChooser.fileName);
            }
        });
        JButton browse = new JButton("Browse");
        browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Open.this.localChooser.showChooser();
            }
        });
        ans.add(this.localProject);
        ans.add(browse);
        return ans;
    }

    private JPanel createRemoteFlag() {
        JPanel ans = new JPanel();
        this.remoteFlag = new JCheckBox("Project is remote.");
        this.remoteFlag.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Open.this.remotePanel.setVisible(Open.this.remoteFlag.isSelected());
                Open.this.pack();
            }
        });
        ans.add(this.remoteFlag);
        return ans;
    }

    private JPanel createConnection() {
        JPanel ans = new JPanel();
        this.user = new JTextField(10);
        this.host = new JTextField(30);
        this.port = new JTextField(5);
        JButton login = new JButton("Login");
        login.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Open.this.conn = TestFrame.myProject.connect(new ErrorManager(Open.this.parent), Open.this.parent, Open.this.host.getText(), Open.this.user.getText(), new Integer(Open.this.port.getText()));
            }
        });
        ans.add(new JLabel("user: "));
        ans.add(this.user);
        ans.add(new JLabel("host: "));
        ans.add(this.host);
        ans.add(new JLabel("port: "));
        ans.add(this.port);
        ans.add(login);
        return ans;
    }

    private JPanel createRemote() {
        JPanel ans = new JPanel();
        this.remoteProject = new JTextField(20);
        JButton browse = new JButton("Browse");
        browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Open.this.remoteChooser = new GCFileChooser(Open.this.parent, null, false, true, Open.this.conn, "");
                Open.this.remoteChooser.addFileChoosenListener(new GCFileChooser.FileChoosenListener(){

                    public void fileChoosenOccures(GCFileChooser.FileChoosenEvent evt) {
                        Open.this.logger.info("(createLocal()) adding the localProject");
                        Open.this.remoteProject.setText(((Open)(this).Open.this).remoteChooser.fileName);
                    }
                });
                Open.this.remoteChooser.showChooser();
            }
        });
        ans.add(new JLabel("Remote Project:"));
        ans.add(this.remoteProject);
        ans.add(browse);
        return ans;
    }

    private JPanel createButton() {
        JPanel ans = new JPanel();
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Open.this.parent.data.properClosing();
                if (Open.this.remoteFlag.isSelected()) {
                    Open.this.parent.data = null;
                    TestFrame testFrame = Open.this.parent;
                    testFrame.getClass();
                    Open.this.data = new TestFrame.myProject(testFrame, Open.this.parent, Open.this.localProject.getText(), Open.this.remoteProject.getText(), Open.this.host.getText(), Open.this.user.getText(), Open.this.port.getText(), Open.this.conn);
                } else {
                    Open.this.parent.data = null;
                    String localFolder = Open.this.localProject.getText();
                    if (!new File(localFolder).isDirectory()) {
                        localFolder = new File(localFolder).getParent();
                    }
                    TestFrame testFrame = Open.this.parent;
                    testFrame.getClass();
                    Open.this.data = new TestFrame.myProject(testFrame, Open.this.parent, localFolder);
                }
                Open.this.parent.layoutPanels(Open.this.data);
                Open.this.dispose();
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Open.this.data != null) {
                    Open.this.data.properClosing();
                }
                TestFrame testFrame = Open.this.parent;
                testFrame.getClass();
                Open.this.data = new TestFrame.myProject(testFrame, Open.this.parent);
                Open.this.parent.layoutPanels(Open.this.data);
                Open.this.dispose();
            }
        });
        ans.add(ok);
        ans.add(cancel);
        return ans;
    }

    public Open(TestFrame p) {
        super((Frame)p, "Open project");
        this.parent = p;
        this.remotePanel = new JPanel();
        this.remotePanel.setLayout(new BoxLayout(this.remotePanel, 3));
        this.remotePanel.add(this.createConnection());
        this.remotePanel.add(this.createRemote());
        this.remotePanel.setVisible(false);
        this.getRootPane().setLayout(new BoxLayout(this.getRootPane(), 3));
        this.getRootPane().add(this.createLocal());
        this.getRootPane().add(this.createRemoteFlag());
        this.getRootPane().add(this.remotePanel);
        this.getRootPane().add(this.createButton());
        this.pack();
        this.setVisible(true);
    }

    public Open(TestFrame f, String local) {
        this(f);
        this.localProject.setText(local);
    }

    private class gCLINEFilter
    extends FileFilter {
        private gCLINEFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }

        public String getDescription() {
            return "directory";
        }
    }
}

