/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.authentication.KBIPrompt;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;

public class SshMsgUserAuthInfoRequest
extends SshMessage {
    public static final int SSH_MSG_USERAUTH_INFO_REQUEST = 60;
    private String name;
    private String instruction;
    private String langtag;
    private KBIPrompt[] prompts;

    public SshMsgUserAuthInfoRequest() {
        super(60);
    }

    public SshMsgUserAuthInfoRequest(String name, String instruction, String langtag) {
        super(60);
        this.name = name;
        this.instruction = instruction;
        this.langtag = langtag;
    }

    public void addPrompt(String prompt, boolean echo) {
        if (this.prompts == null) {
            this.prompts = new KBIPrompt[1];
            this.prompts[0] = new KBIPrompt(prompt, echo);
        } else {
            KBIPrompt[] temp = new KBIPrompt[this.prompts.length + 1];
            System.arraycopy(this.prompts, 0, temp, 0, this.prompts.length);
            this.prompts = temp;
            this.prompts[this.prompts.length - 1] = new KBIPrompt(prompt, echo);
        }
    }

    public KBIPrompt[] getPrompts() {
        return this.prompts;
    }

    public String getName() {
        return this.name;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public String getLanguageTag() {
        return this.langtag;
    }

    public String getMessageName() {
        return "SSH_MSG_USERAUTH_INFO_REQUEST";
    }

    protected void constructByteArray(ByteArrayWriter baw) throws InvalidMessageException {
        try {
            if (this.name != null) {
                baw.writeString(this.name);
            } else {
                baw.writeString("");
            }
            if (this.instruction != null) {
                baw.writeString(this.instruction);
            } else {
                baw.writeString("");
            }
            if (this.langtag != null) {
                baw.writeString(this.langtag);
            } else {
                baw.writeString("");
            }
            if (this.prompts == null) {
                baw.writeInt(0);
            } else {
                baw.writeInt(this.prompts.length);
                int i = 0;
                while (i < this.prompts.length) {
                    baw.writeString(this.prompts[i].getPrompt());
                    baw.write(this.prompts[i].echo() ? 1 : 0);
                    ++i;
                }
            }
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Failed to write message data");
        }
    }

    protected void constructMessage(ByteArrayReader bar) throws InvalidMessageException {
        try {
            this.name = bar.readString();
            this.instruction = bar.readString();
            this.langtag = bar.readString();
            long num = bar.readInt();
            int i = 0;
            while ((long)i < num) {
                String prompt = bar.readString();
                boolean echo = bar.read() == 1;
                this.addPrompt(prompt, echo);
                ++i;
            }
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Failed to read message data");
        }
    }
}

