/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.util;

import com.sshtools.daemon.util.StringPattern;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class StringUtil {
    public static final char CH_SPACE = ' ';
    public static final char CH_NEWLINE = '\n';
    public static final char CH_CR = '\r';
    public static final char CH_TAB = '\t';
    public static final String STR_SPACE = " ";
    public static final String STR_NEWLINE = "\n";
    public static final String STR_CR = "\r";
    public static final String STR_TAB = "\t";
    private static final String WORD_DELIM = " \t\n\r";
    private static StringUtil singleton = null;

    private static StringUtil getSingleton() {
        return singleton;
    }

    private static void setSingleton(StringUtil inst) {
        singleton = inst;
    }

    public static StringUtil current() {
        if (StringUtil.getSingleton() == null) {
            StringUtil.setSingleton(new StringUtil());
        }
        return StringUtil.getSingleton();
    }

    public String replaceAll(String sourceStr, String oldSubStr, String newSubStr) {
        String part = null;
        String result = "";
        int index = -1;
        int subLen = 0;
        subLen = oldSubStr.length();
        part = sourceStr;
        while (part.length() > 0 && subLen > 0) {
            index = part.indexOf(oldSubStr);
            if (index >= 0) {
                result = String.valueOf(result) + part.substring(0, index) + newSubStr;
                part = part.substring(index + subLen);
                continue;
            }
            result = String.valueOf(result) + part;
            part = "";
        }
        return result;
    }

    public String repeat(char ch, int count) {
        StringBuffer buffer = null;
        buffer = new StringBuffer(count);
        int i = 1;
        while (i <= count) {
            buffer.append(ch);
            ++i;
        }
        return buffer.toString();
    }

    public String[] words(String text) {
        return this.parts(text, WORD_DELIM);
    }

    public String[] parts(String text, String delimiters) {
        return this.parts(text, delimiters, false);
    }

    public String[] allParts(String text, String delimiters) {
        return this.parts(text, delimiters, true);
    }

    public String[] substrings(String text, String separator) {
        return this.substrings(text, separator, false);
    }

    public String[] allSubstrings(String text, String separator) {
        return this.substrings(text, separator, true);
    }

    public String getDelimitedSubstring(String text, String startDelimiter, String endDelimiter) {
        int stop;
        int start;
        String subStr = "";
        if (text != null && startDelimiter != null && endDelimiter != null && (start = text.indexOf(startDelimiter)) >= 0 && (stop = text.indexOf(endDelimiter, start + 1)) > start) {
            subStr = text.substring(start + 1, stop);
        }
        return subStr;
    }

    public String getDelimitedSubstring(String text, String delimiter) {
        return this.getDelimitedSubstring(text, delimiter, delimiter);
    }

    public String stackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public String leftPadCh(String str, int len, char ch) {
        return this.padCh(str, len, ch, true);
    }

    public String leftPad(String str, int len) {
        return this.leftPadCh(str, len, ' ');
    }

    public String leftPadCh(int value, int len, char fillChar) {
        return this.leftPadCh(Integer.toString(value), len, fillChar);
    }

    public String leftPad(int value, int len) {
        return this.leftPadCh(value, len, '0');
    }

    public String rightPadCh(String str, int len, char ch) {
        return this.padCh(str, len, ch, false);
    }

    public String rightPad(String str, int len) {
        return this.rightPadCh(str, len, ' ');
    }

    public String rightPadCh(int value, int len, char fillChar) {
        return this.rightPadCh(Integer.toString(value), len, fillChar);
    }

    public String rightPad(int value, int len) {
        return this.rightPadCh(value, len, ' ');
    }

    public String centerCh(String str, int len, char ch) {
        String buffer = null;
        int missing = len - str.length();
        int half = 0;
        if (missing <= 0) {
            return str;
        }
        half = missing / 2;
        buffer = this.rightPadCh(str, len - half, ch);
        return this.leftPadCh(buffer, len, ch);
    }

    public String center(String str, int len) {
        return this.centerCh(str, len, ' ');
    }

    public String[] append(String[] strings, String string) {
        String[] appStr = new String[]{string};
        return this.append(strings, appStr);
    }

    public String[] append(String[] strings, String[] appendStrings) {
        String[] newStrings = null;
        if (strings == null) {
            return appendStrings;
        }
        if (appendStrings == null) {
            return strings;
        }
        newStrings = new String[strings.length + appendStrings.length];
        System.arraycopy(strings, 0, newStrings, 0, strings.length);
        System.arraycopy(appendStrings, 0, newStrings, strings.length, appendStrings.length);
        return newStrings;
    }

    public String[] appendIfNotThere(String[] strings, String appendString) {
        if (this.contains(strings, appendString)) {
            return strings;
        }
        return this.append(strings, appendString);
    }

    public String[] appendIfNotThere(String[] strings, String[] appendStrings) {
        String[] newStrings = strings;
        if (appendStrings == null) {
            return newStrings;
        }
        int i = 0;
        while (i < appendStrings.length) {
            newStrings = this.appendIfNotThere(newStrings, appendStrings[i]);
            ++i;
        }
        return newStrings;
    }

    public String[] remove(String[] strings, String[] removeStrings) {
        if (strings == null || removeStrings == null || strings.length == 0 || removeStrings.length == 0) {
            return strings;
        }
        return this.removeFromStringArray(strings, removeStrings);
    }

    public String[] remove(String[] strings, String removeString) {
        String[] removeStrings = new String[]{removeString};
        return this.remove(strings, removeStrings);
    }

    public String[] removeNull(String[] strings) {
        if (strings == null) {
            return strings;
        }
        return this.removeFromStringArray(strings, null);
    }

    public String asString(String[] strings, String separator) {
        StringBuffer buffer = null;
        buffer = new StringBuffer(strings.length * 20);
        if (strings.length > 0) {
            buffer.append(strings[0].toString());
            int i = 1;
            while (i < strings.length) {
                buffer.append(separator);
                if (strings[i] != null) {
                    buffer.append(strings[i]);
                }
                ++i;
            }
        }
        return buffer.toString();
    }

    public String asString(String[] strings) {
        return this.asString(strings, ",");
    }

    public int indexOf(String[] strArray, StringPattern pattern) {
        if (strArray == null || strArray.length == 0) {
            return -1;
        }
        boolean found = false;
        int i = 0;
        while (i < strArray.length) {
            if (strArray[i] == null) {
                if (pattern == null) {
                    found = true;
                }
            } else if (pattern != null) {
                found = pattern.matches(strArray[i]);
            }
            if (found) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(String[] strArray, String searchStr) {
        return this.indexOfString(strArray, searchStr, false);
    }

    public int indexOfIgnoreCase(String[] strArray, String searchStr) {
        return this.indexOfString(strArray, searchStr, true);
    }

    public boolean contains(String[] strArray, String searchStr, boolean ignoreCase) {
        if (ignoreCase) {
            return this.containsIgnoreCase(strArray, searchStr);
        }
        return this.contains(strArray, searchStr);
    }

    public boolean contains(String[] strArray, StringPattern pattern) {
        return this.indexOf(strArray, pattern) >= 0;
    }

    public boolean contains(String[] strArray, String searchStr) {
        return this.indexOf(strArray, searchStr) >= 0;
    }

    public boolean containsIgnoreCase(String[] strArray, String searchStr) {
        return this.indexOfIgnoreCase(strArray, searchStr) >= 0;
    }

    public String[] copyFrom(String[] from, int start) {
        if (from == null) {
            return null;
        }
        return this.copyFrom(from, start, from.length - 1);
    }

    public String[] copyFrom(String[] from, int start, int end) {
        int count;
        int stop = end;
        if (from == null) {
            return null;
        }
        if (stop > from.length - 1) {
            stop = from.length - 1;
        }
        if ((count = stop - start + 1) < 1) {
            return new String[0];
        }
        String[] result = new String[count];
        System.arraycopy(from, start, result, 0, count);
        return result;
    }

    public String cutTail(String text, String separator) {
        if (text == null || separator == null) {
            return text;
        }
        int index = text.lastIndexOf(separator);
        if (index < 0) {
            return text;
        }
        return text.substring(0, index);
    }

    public String cutHead(String text, String separator) {
        if (text == null || separator == null) {
            return text;
        }
        int index = text.lastIndexOf(separator);
        if (index < 0) {
            return text;
        }
        return text.substring(index + 1);
    }

    public String[] splitNameValue(String str, String separator) {
        String[] result = new String[]{"", ""};
        if (str != null) {
            int index = str.indexOf(separator);
            if (index > 0) {
                result[0] = str.substring(0, index);
                result[1] = str.substring(index + separator.length());
            } else {
                result[0] = str;
            }
        }
        return result;
    }

    public String prefix(String str, String separator) {
        return this.prefix(str, separator, true);
    }

    public String suffix(String str, String separator) {
        return this.suffix(str, separator, true);
    }

    public String upTo(String str, String separator) {
        return this.prefix(str, separator, false);
    }

    public String startingFrom(String str, String separator) {
        return this.suffix(str, separator, false);
    }

    public String reverse(String str) {
        if (str == null) {
            return null;
        }
        char[] newStr = new char[str.length()];
        StringCharacterIterator iterator = new StringCharacterIterator(str);
        int i = 0;
        char ch = iterator.last();
        while (ch != '\uffff') {
            newStr[i] = ch;
            ++i;
            ch = iterator.previous();
        }
        return new String(newStr);
    }

    public Map toMap(String str, String elementSeparator, String keyValueSeparator, Map map) {
        if (str == null) {
            return map;
        }
        Map result = map == null ? new Hashtable() : map;
        String elemSep = elementSeparator == null ? "," : elementSeparator;
        String kvSep = keyValueSeparator == null ? "=" : keyValueSeparator;
        String[] assignments = this.parts(str, elemSep);
        int i = 0;
        while (i < assignments.length) {
            String[] nameValue = this.splitNameValue(assignments[i], kvSep);
            nameValue[0] = nameValue[0].trim();
            nameValue[1] = nameValue[1].trim();
            if (nameValue[0].length() > 0) {
                result.put(nameValue[0], nameValue[1]);
            }
            ++i;
        }
        return result;
    }

    public Map asMap(String str) {
        return this.toMap(str, null, null, null);
    }

    public Map asMap(String str, String elementSeparator) {
        return this.toMap(str, elementSeparator, null, null);
    }

    public Map asMap(String str, String elementSeparator, String keyValueSeparator) {
        return this.toMap(str, elementSeparator, keyValueSeparator, null);
    }

    public Map toMap(String str, String elementSeparator, Map map) {
        return this.toMap(str, elementSeparator, null, map);
    }

    public Map toMap(String str, Map map) {
        return this.toMap(str, null, null, map);
    }

    public Properties asProperties(String str) {
        return this.toProperties(str, null);
    }

    public Properties toProperties(String str, Properties properties) {
        Properties props = properties == null ? new Properties() : properties;
        return (Properties)this.toMap(str, null, null, props);
    }

    protected String trimSeparator(String text, String separator) {
        int sepLen = separator.length();
        while (text.startsWith(separator)) {
            text = text.substring(separator.length());
        }
        while (text.endsWith(separator)) {
            text = text.substring(0, text.length() - sepLen);
        }
        return text;
    }

    protected String[] parts(String text, String delimiters, boolean all) {
        ArrayList result = null;
        StringTokenizer tokenizer = null;
        if (text == null) {
            return null;
        }
        if (delimiters == null || delimiters.length() == 0) {
            String[] resultArray = new String[]{text};
            return resultArray;
        }
        if (text.length() == 0) {
            return new String[0];
        }
        result = new ArrayList();
        tokenizer = new StringTokenizer(text, delimiters, all);
        if (all) {
            this.collectParts(result, tokenizer, delimiters);
        } else {
            this.collectParts(result, tokenizer);
        }
        return result.toArray(new String[0]);
    }

    protected void collectParts(List list, StringTokenizer tokenizer) {
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
    }

    protected void collectParts(List list, StringTokenizer tokenizer, String delimiter) {
        boolean lastWasDelimiter = false;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (delimiter.indexOf(token) >= 0) {
                if (lastWasDelimiter) {
                    list.add("");
                }
                lastWasDelimiter = true;
                continue;
            }
            list.add(token);
            lastWasDelimiter = false;
        }
    }

    protected String[] substrings(String text, String separator, boolean all) {
        int index = 0;
        int start = 0;
        int sepLen = 0;
        int strLen = 0;
        String str = text;
        ArrayList<String> strings = new ArrayList<String>();
        if (text == null) {
            return new String[0];
        }
        if (separator == null || separator.length() == 0) {
            if (text.length() == 0) {
                return new String[0];
            }
            String[] resultArray = new String[]{text};
            return resultArray;
        }
        if (!all) {
            str = this.trimSeparator(text, separator);
        }
        if ((strLen = str.length()) > 0) {
            sepLen = separator.length();
            index = str.indexOf(separator, start);
            while (index >= 0) {
                if (all) {
                    if (index > 0) {
                        strings.add(str.substring(start, index));
                    }
                } else if (index > start + sepLen) {
                    strings.add(str.substring(start, index));
                }
                start = index + sepLen;
                index = str.indexOf(separator, start);
            }
            if (start < strLen) {
                strings.add(str.substring(start));
            }
        }
        return strings.toArray(new String[0]);
    }

    protected String padCh(String str, int len, char ch, boolean left) {
        StringBuffer buffer = null;
        int missing = len - str.length();
        if (missing <= 0) {
            return str;
        }
        buffer = new StringBuffer(len);
        if (!left) {
            buffer.append(str);
        }
        int i = 1;
        while (i <= missing) {
            buffer.append(ch);
            ++i;
        }
        if (left) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    protected int indexOfString(String[] strArray, String searchStr, boolean ignoreCase) {
        if (strArray == null || strArray.length == 0) {
            return -1;
        }
        boolean found = false;
        int i = 0;
        while (i < strArray.length) {
            if (strArray[i] == null) {
                if (searchStr == null) {
                    found = true;
                }
            } else {
                found = ignoreCase ? strArray[i].equalsIgnoreCase(searchStr) : strArray[i].equals(searchStr);
            }
            if (found) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected String prefix(String str, String separator, boolean returnNull) {
        if (str == null) {
            return null;
        }
        if (separator == null) {
            return returnNull ? null : str;
        }
        int index = str.indexOf(separator);
        if (index >= 0) {
            return str.substring(0, index);
        }
        return returnNull ? null : str;
    }

    protected String suffix(String str, String separator, boolean returnNull) {
        if (str == null) {
            return null;
        }
        if (separator == null) {
            return returnNull ? null : str;
        }
        int index = str.indexOf(separator);
        if (index >= 0) {
            return str.substring(index + separator.length());
        }
        return returnNull ? null : str;
    }

    protected String[] removeFromStringArray(String[] strings, String[] removeStrings) {
        ArrayList<String> list = new ArrayList<String>(strings.length);
        int i = 0;
        while (i < strings.length) {
            boolean remains;
            if (removeStrings == null) {
                remains = strings[i] != null;
            } else {
                boolean bl = remains = !this.contains(removeStrings, strings[i]);
            }
            if (remains) {
                list.add(strings[i]);
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }
}

