/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.session;

import com.sshtools.daemon.configuration.AllowedSubsystem;
import com.sshtools.daemon.configuration.ServerConfiguration;
import com.sshtools.daemon.platform.NativeProcessProvider;
import com.sshtools.daemon.scp.ScpServer;
import com.sshtools.daemon.session.PseudoTerminalWrapper;
import com.sshtools.daemon.subsystem.SubsystemServer;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.agent.SshAgentForwardingListener;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.connection.ChannelOutputStream;
import com.sshtools.j2ssh.connection.IOChannel;
import com.sshtools.j2ssh.connection.InvalidChannelException;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.IOStreamConnector;
import com.sshtools.j2ssh.util.StartStopState;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionChannelServer
extends IOChannel {
    private static Log log = LogFactory.getLog(SessionChannelServer.class);
    public static final String SESSION_CHANNEL_TYPE = "session";
    private static Map allowedSubsystems = new HashMap();
    private Map environment = new HashMap();
    private NativeProcessProvider processInstance;
    private SubsystemServer subsystemInstance;
    private Thread thread;
    private IOStreamConnector ios;
    private ChannelOutputStream stderrOut;
    private InputStream stderrIn;
    private ProcessMonitorThread processMonitor;
    private PseudoTerminalWrapper pty;
    private SshAgentForwardingListener agent;
    private ServerConfiguration config = (ServerConfiguration)ConfigurationLoader.getConfiguration(ServerConfiguration.class);

    public SessionChannelServer() throws ConfigurationException {
        allowedSubsystems.putAll(this.config.getSubsystems());
    }

    private void bindStderrInputStream(InputStream stderrIn) {
        this.stderrIn = stderrIn;
        this.ios = new IOStreamConnector(stderrIn, this.stderrOut);
    }

    protected void onChangeTerminalDimensions(int cols, int rows, int width, int height) {
    }

    protected void onChannelClose() throws IOException {
        if (this.agent != null) {
            this.agent.removeReference(this);
        }
        if (this.processInstance != null && this.processInstance.stillActive()) {
            this.processInstance.kill();
        }
        if (this.subsystemInstance != null) {
            this.subsystemInstance.stop();
        }
        if (this.processMonitor != null) {
            StartStopState state = this.processMonitor.getStartStopState();
            try {
                state.waitForState(2);
            }
            catch (InterruptedException ex) {
                throw new IOException("The process monitor was interrupted");
            }
        }
    }

    protected void onChannelEOF() throws IOException {
    }

    protected void onChannelExtData(byte[] data) throws IOException {
    }

    protected void onChannelOpen() throws InvalidChannelException {
        this.stderrOut = new ChannelOutputStream(this, new Integer(1));
    }

    protected boolean onExecuteCommand(String command) throws IOException {
        log.debug("Executing command " + command);
        if (command.startsWith("scp ") && this.processInstance == null) {
            this.processInstance = new ScpServer();
        }
        if (this.processInstance == null) {
            this.processInstance = NativeProcessProvider.newInstance();
        }
        if (this.processInstance == null) {
            log.debug("Failed to create process");
            return false;
        }
        boolean result = this.processInstance.createProcess(command, this.environment);
        if (result) {
            if (this.pty != null) {
                this.pty.bindMasterOutputStream(this.getOutputStream());
                this.pty.bindMasterInputStream(this.getInputStream());
                this.pty.bindSlaveInputStream(this.processInstance.getInputStream());
                this.pty.bindSlaveOutputStream(this.processInstance.getOutputStream());
                this.pty.initialize();
                this.bindInputStream(this.pty.getMasterInputStream());
                this.bindStderrInputStream(this.processInstance.getStderrInputStream());
            } else {
                this.bindInputStream(this.processInstance.getInputStream());
                this.bindOutputStream(this.processInstance.getOutputStream());
                this.bindStderrInputStream(this.processInstance.getStderrInputStream());
            }
        }
        return result;
    }

    protected boolean onRequestPseudoTerminal(String term, int cols, int rows, int width, int height, String modes) {
        try {
            this.processInstance = NativeProcessProvider.newInstance();
            if (this.processInstance.supportsPseudoTerminal(term)) {
                return this.processInstance.allocatePseudoTerminal(term, cols, rows, width, height, modes);
            }
            this.pty = new PseudoTerminalWrapper(term, cols, rows, width, height, modes);
            return true;
        }
        catch (IOException ioe) {
            log.warn("Failed to allocate pseudo terminal " + term, ioe);
            return false;
        }
    }

    protected void onSetEnvironmentVariable(String name, String value) {
        this.environment.put(name, value);
    }

    protected boolean onStartShell() throws IOException {
        String shell = this.config.getTerminalProvider();
        if (this.processInstance == null) {
            this.processInstance = NativeProcessProvider.newInstance();
        }
        if (shell != null && !shell.trim().equals("")) {
            int idx = shell.indexOf("%DEFAULT_TERMINAL%");
            if (idx > -1) {
                shell = String.valueOf(idx > 0 ? shell.substring(0, idx) : "") + this.processInstance.getDefaultTerminalProvider() + (idx + 18 < shell.length() ? shell.substring(idx + 18) : "");
            }
        } else {
            shell = this.processInstance.getDefaultTerminalProvider();
        }
        return this.onExecuteCommand(shell);
    }

    protected boolean onStartSubsystem(String subsystem) {
        String provider;
        block7: {
            AllowedSubsystem obj;
            block6: {
                block5: {
                    boolean result = false;
                    try {
                        if (allowedSubsystems.containsKey(subsystem)) break block5;
                        log.error(String.valueOf(subsystem) + " Subsystem is not available");
                        return false;
                    }
                    catch (Exception e) {
                        log.error("Failed to start subsystem " + subsystem, e);
                        return false;
                    }
                }
                obj = (AllowedSubsystem)allowedSubsystems.get(subsystem);
                if (!obj.getType().equals("class")) break block6;
                Class<?> cls = Class.forName(obj.getProvider());
                this.subsystemInstance = (SubsystemServer)cls.newInstance();
                this.subsystemInstance.setSession(this);
                this.bindInputStream(this.subsystemInstance.getInputStream());
                this.bindOutputStream(this.subsystemInstance.getOutputStream());
                return true;
            }
            provider = obj.getProvider();
            File f = new File(provider);
            if (f.exists() || (f = new File(provider = String.valueOf(ConfigurationLoader.getHomeDirectory()) + "bin" + File.separator + provider)).exists()) break block7;
            log.error("Failed to locate subsystem provider " + obj.getProvider());
            return false;
        }
        return this.onExecuteCommand(provider);
    }

    public byte[] getChannelOpenData() {
        return null;
    }

    public byte[] getChannelConfirmationData() {
        return null;
    }

    protected int getMinimumWindowSpace() {
        return 1024;
    }

    protected int getMaximumWindowSpace() {
        return 32648;
    }

    protected int getMaximumPacketSize() {
        return 32648;
    }

    public String getChannelType() {
        return SESSION_CHANNEL_TYPE;
    }

    protected void onChannelRequest(String requestType, boolean wantReply, byte[] requestData) throws IOException {
        block32: {
            ByteArrayReader bar;
            log.debug("Channel Request received: " + requestType);
            boolean success = false;
            if (requestType.equals("shell")) {
                success = this.onStartShell();
                if (success) {
                    if (wantReply) {
                        this.connection.sendChannelRequestSuccess(this);
                    }
                    this.processInstance.start();
                    this.processMonitor = new ProcessMonitorThread(this.processInstance);
                } else if (wantReply) {
                    this.connection.sendChannelRequestFailure(this);
                }
            }
            if (requestType.equals("env")) {
                bar = new ByteArrayReader(requestData);
                String name = bar.readString();
                String value = bar.readString();
                this.onSetEnvironmentVariable(name, value);
                if (wantReply) {
                    this.connection.sendChannelRequestSuccess(this);
                }
            }
            if (requestType.equals("exec")) {
                bar = new ByteArrayReader(requestData);
                String command = bar.readString();
                success = this.onExecuteCommand(command);
                if (success) {
                    if (wantReply) {
                        this.connection.sendChannelRequestSuccess(this);
                    }
                    this.processInstance.start();
                    this.processMonitor = new ProcessMonitorThread(this.processInstance);
                } else if (wantReply) {
                    this.connection.sendChannelRequestFailure(this);
                }
            }
            if (requestType.equals("subsystem")) {
                bar = new ByteArrayReader(requestData);
                String subsystem = bar.readString();
                success = this.onStartSubsystem(subsystem);
                if (success) {
                    if (wantReply) {
                        this.connection.sendChannelRequestSuccess(this);
                    }
                    if (this.processInstance != null) {
                        this.processInstance.start();
                        this.processMonitor = new ProcessMonitorThread(this.processInstance);
                    } else if (this.subsystemInstance != null) {
                        this.subsystemInstance.start();
                        this.processMonitor = new ProcessMonitorThread(this.subsystemInstance);
                    }
                } else if (wantReply) {
                    this.connection.sendChannelRequestFailure(this);
                }
            }
            if (requestType.equals("pty-req")) {
                bar = new ByteArrayReader(requestData);
                String term = bar.readString();
                int cols = (int)bar.readInt();
                int rows = (int)bar.readInt();
                int width = (int)bar.readInt();
                int height = (int)bar.readInt();
                String modes = bar.readString();
                success = this.onRequestPseudoTerminal(term, cols, rows, width, height, modes);
                if (wantReply && success) {
                    this.connection.sendChannelRequestSuccess(this);
                } else if (wantReply) {
                    this.connection.sendChannelRequestFailure(this);
                }
            }
            if (requestType.equals("window-change")) {
                bar = new ByteArrayReader(requestData);
                int cols = (int)bar.readInt();
                int rows = (int)bar.readInt();
                int width = (int)bar.readInt();
                int height = (int)bar.readInt();
                this.onChangeTerminalDimensions(cols, rows, width, height);
                if (wantReply && success) {
                    this.connection.sendChannelRequestSuccess(this);
                } else if (wantReply) {
                    this.connection.sendChannelRequestFailure(this);
                }
            }
            if (requestType.equals("auth-agent-req")) {
                try {
                    SshThread thread = SshThread.getCurrentThread();
                    this.agent = SshAgentForwardingListener.getInstance(thread.getSessionIdString(), this.connection);
                    this.agent.addReference(this);
                    this.environment.put("SSH_AGENT_AUTH", this.agent.getConfiguration());
                    thread.setProperty("sshtools.agent", this.agent.getConfiguration());
                    if (wantReply) {
                        this.connection.sendChannelRequestSuccess(this);
                    }
                }
                catch (Exception ex) {
                    if (!wantReply) break block32;
                    this.connection.sendChannelRequestFailure(this);
                }
            }
        }
    }

    class ProcessMonitorThread
    extends Thread {
        private NativeProcessProvider process;
        private SubsystemServer subsystem;
        private StartStopState state;

        public ProcessMonitorThread(NativeProcessProvider process) {
            this.process = process;
            this.state = new StartStopState(1);
            this.start();
        }

        public ProcessMonitorThread(SubsystemServer subsystem) {
            this.state = subsystem.getState();
        }

        public StartStopState getStartStopState() {
            return this.state;
        }

        public void run() {
            try {
                log.info("Monitor waiting for process exit code");
                int exitcode = this.process.waitForExitCode();
                if (exitcode == 9999999) {
                    log.error("Process monitor failed to retrieve exit code");
                } else {
                    log.debug("Process exit code is " + String.valueOf(exitcode));
                    this.process.getInputStream().close();
                    this.process.getOutputStream().close();
                    this.process.getStderrInputStream().close();
                    ByteArrayWriter baw = new ByteArrayWriter();
                    baw.writeInt(exitcode);
                    if (SessionChannelServer.this.connection.isConnected() && SessionChannelServer.this.isOpen()) {
                        SessionChannelServer.this.connection.sendChannelRequest(SessionChannelServer.this, "exit-status", false, baw.toByteArray());
                    }
                    this.state.setValue(2);
                    SessionChannelServer.this.close();
                }
            }
            catch (IOException ioe) {
                log.error("Failed to kill process", ioe);
            }
        }
    }
}

