/* -----------------------------------------------------------------------
   Header file for Linux PIC84 programmer
   
   Copyright 1994-1998 by Brian C. Lane
   ----------------------------------------------------------------------- */
#include <stdio.h>
#include <curses.h>
#include <unistd.h>
#include <sys/types.h>

#define flushall() fflush(NULL)


#define VERSION " Linux PIC programmer     v2.3c           Copyright 1994-1998 by Brian C. Lane "

#define	PIC16C84	0

/* How to genericly handle the ports, lines, and polarities? */
struct _pconfig
{
  int	port;				/* /dev/lpX		 	*/
  int	colors;				/* Color support 1 or 0		*/
  int	PIC_type;			/* Default PIC type		*
  				         * 0 = PIC16C84			*
  					 * Others to be defined		*/
  uint	CFaddr;				/* Config Fuses Address 0x2007	*/
  uint	IDaddr;				/* ID Memory address 0x2000	*/
  uint	EEaddr;				/* EEPROM address 0x2100	*/
  uint  progmax;			/* Maximum program memory address */
  uint  datamax;			/* Max EEPROM data address      */
  int	VPP_pin;			/* Pin for VPP control		*/
  int	VPP_pol;			/* Polarity 0=inverted 1=normal	*/
  int	VDD_pin;			/* Pin for Vdd control		*/
  int	VDD_pol;			/* Polarity 0=inverted 1=normal	*/
  int	CLK_pin;			/* Pin for Clock control	*/
  int	CLK_pol;			/* Polarity 0=inverted 1=normal	*/
  int	DATAO_pin;			/* Pin for Data to PIC control	*/
  int	DATAO_pol;			/* Polarity 0=inverted 1=normal	*/
  int	DATAI_pin;			/* Pin for Data from PIC control*/
  int	DATAI_pol;			/* Polarity 0=inverted 1=normal	*/
  int	PGM_pin;			/* Pin for PGM control		*/
  int	PGM_pol;			/* Polarity 0=inverted 1=normal	*/

  uint   alt;                           /* Added by Aisha 4/1/00 */
};

// Added BAJ 5/18/2002
typedef struct {
   uint dev_id;				/* PIC device ID                */
   uint dev_mask;			/* PIC device ID mask           */
   uint progmax;			/* PIC device max program addr  */
   uint datamax;			/* PIC device max data addr     */
   uint algorithm;                      /* PIC device programming algorithm */
   char *name;				/* PIC device name 		*/
   char **confstr;			/* PIC config string list       */
} dev_id_t, *dev_id_p;

/* Structure to hold all the data about the currently loaded processor	*/
#define MAXPICSIZE 65535

struct _pic
{
  unsigned int	mem[MAXPICSIZE];	/* up to 16 bit words		*/
};


int init_port();
int verify_pic( WINDOW * );
int program_pic( WINDOW * );
int read_pic( WINDOW * );
int readihex( FILE *, unsigned int *, int *, int * );
int writeihex16( FILE *, unsigned int *, int, int );
int writeiend16( FILE * );
void attr_clear(WINDOW *, int, int, chtype);
void show_err( char *fmt, ... );
int inbit();
int vppon();
int vppoff();
int vddon();
int vddoff();
int pgmon();
int pgmoff();
int clkhi();
int clklo();
int outhi();
int outlo();
unsigned int get_device_id(void);

/* Memory storage functions */
void	init_pic();
