
/*	$NetBSD$	*/

/*-
 * Copyright (c) 2019 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Kamil Rytarowski.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef TRACE_UTILS_H
#define TRACE_UTILS_H

#include <sys/cdefs.h>
#include <sys/param.h>
#include <sys/ptrace.h>
#include <sys/sysctl.h>
#include <sys/wait.h>

#include <err.h>
#include <errno.h>
#include <inttypes.h>
#include <libgen.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <threads.h>
#include <unistd.h>

#include "xstringlist.h"

int xthrd_create(thrd_t *, thrd_start_t, void *);
int xthrd_detach(thrd_t thr);
int xmtx_init(mtx_t *, int);
int xmtx_lock(mtx_t *);
int xmtx_unlock(mtx_t *);
int xcnd_init(cnd_t *c);
int xcnd_signal(cnd_t *);
int xcnd_wait(cnd_t *, mtx_t *);
pid_t xwaitpid(pid_t, int *, int);
int xptrace(int, pid_t, void *, int);
pid_t xfork(void);
int xsysctl(const int *, u_int, void *, size_t *, const void *, size_t);
int xsnprintf(char * __restrict, size_t, const char * __restrict, ...)
    __printflike(3,4);
int xtimespec_get(struct timespec *, int);

/* xstringlist */

char *xsl_concat(StringList *);
StringList *xsl_initf(const char * restrict, ...) __printflike(1, 2);
StringList *xsl_vinitf(const char * restrict, va_list) __printflike(1, 0);
int xsl_addf(StringList *, const char * restrict, ...) __printflike(2, 3);
int xsl_vaddf(StringList *, const char * restrict, va_list) __printflike(2, 0);
size_t xsl_fwrite(StringList * restrict, FILE * restrict);
size_t xsl_fdump(StringList * restrict, FILE * restrict);

#endif /* TRACE_UTILS_H */
